/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.content;

import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10529;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2484;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5614;
import net.minecraft.class_5820;
import net.minecraft.class_7833;
import net.minecraft.class_8242;
import net.minecraft.class_827;
import net.minecraft.class_836;
import net.pneumono.gravestones.block.AbstractGravestoneBlockEntity;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractGravestoneBlockEntityRenderer<T extends AbstractGravestoneBlockEntity>
implements class_827<T> {
    protected static final float TEXT_SCALE = 0.14285715f;
    protected static final int TEXT_LINE_HEIGHT = 7;
    protected final class_327 textRenderer;
    protected final Function<class_2484.class_2485, class_5598> models;

    public AbstractGravestoneBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.textRenderer = ctx.method_32143();
        this.models = class_156.method_34866(type -> class_836.method_32160((class_5599)ctx.method_32142(), (class_2484.class_2485)type));
    }

    public void render(T entity, float tickProgress, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.0f, 0.5f);
        int rotation = switch (((AbstractGravestoneBlockEntity)((Object)entity)).getGravestoneDirection()) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033, class_2350.field_11036, class_2350.field_11043 -> 0;
            case class_2350.field_11039 -> 90;
            case class_2350.field_11035 -> 180;
            case class_2350.field_11034 -> 270;
        };
        matrices.method_22907(class_7833.field_40716.rotationDegrees((float)rotation));
        matrices.method_46416(-0.5f, 0.0f, -0.5f);
        this.renderText(entity, matrices, vertexConsumers, light);
        this.renderPositionedHead(entity, matrices, vertexConsumers, light);
        matrices.method_22909();
    }

    public void renderText(T info, class_4587 matrices, class_4597 vertexConsumers, int light) {
        int finalLight;
        boolean renderOutline;
        int color;
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        matrices.method_22905(0.0625f, -0.0625f, 0.0625f);
        matrices.method_22904(-8.0, -14.0, -11.95);
        matrices.method_22905(0.14285715f, 0.14285715f, 0.14285715f);
        class_8242 signText = this.getSignText(info);
        int textColor = class_10529.method_65822((class_8242)signText);
        class_5481[] orderedTexts = signText.method_49868(class_310.method_1551().method_33883(), text -> {
            List list = this.textRenderer.method_1728((class_5348)text, 120);
            return list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
        });
        if (signText.method_49856()) {
            color = signText.method_49872().method_16357();
            renderOutline = AbstractGravestoneBlockEntityRenderer.shouldRenderTextOutline(info.method_11016(), color);
            finalLight = 0xF000F0;
        } else {
            color = textColor;
            renderOutline = false;
            finalLight = light;
        }
        for (int i = 0; i < 4; ++i) {
            class_5481 orderedText = orderedTexts[i];
            float x = -this.textRenderer.method_30880(orderedText) / 2;
            int y = (i + 1) * 7 * 2;
            if (renderOutline) {
                this.textRenderer.method_37296(orderedText, x, (float)y, color, textColor, matrices.method_23760().method_23761(), vertexConsumers, finalLight);
                continue;
            }
            this.textRenderer.method_22942(orderedText, x, (float)y, color, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33995, 0, finalLight);
        }
        matrices.method_22909();
    }

    private static boolean shouldRenderTextOutline(class_2338 pos, int color) {
        return class_10529.method_65827((class_2338)pos, (int)color);
    }

    public void renderPositionedHead(T info, class_4587 matrices, class_4597 vertexConsumers, int light) {
        matrices.method_22903();
        matrices.method_46416(0.0f, -0.0625f, 0.0f);
        class_2338 pos = info.method_11016();
        long seed = ("Pos: " + pos.toString() + ", Some other text, I don't know, it doesn't matter what goes here.").hashCode();
        class_5820 random = new class_5820(seed);
        float yaw = random.method_43057() * 70.0f - 35.0f;
        float pitch = random.method_43057() * -30.0f;
        matrices.method_46416(0.5f, 0.0f, 0.475f);
        matrices.method_22905(-1.0f, -1.0f, 1.0f);
        this.renderHead(info, matrices, vertexConsumers, yaw, pitch, light);
        matrices.method_22909();
    }

    public abstract void renderHead(T var1, class_4587 var2, class_4597 var3, float var4, float var5, int var6);

    public void renderHeadModel(class_4587 matrices, class_5598 model, class_4588 vertexConsumer, float yaw, float pitch, int light) {
        model.method_2821(0.0f, yaw, pitch);
        model.method_60879(matrices, vertexConsumer, light, class_4608.field_21444);
    }

    public abstract class_8242 getSignText(T var1);
}

