/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.content;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.block.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.content.DeathArgumentType;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.gravestones.GravestoneDataSaving;
import net.pneumono.gravestones.gravestones.GravestoneManager;
import net.pneumono.gravestones.gravestones.RecentGraveHistory;
import net.pneumono.gravestones.multiversion.GraveOwner;
import net.pneumono.gravestones.multiversion.VersionUtil;

public class GravestonesCommands {
    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gravestones").requires(source -> source.method_9259(4))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"getdata").then(class_2170.method_9247((String)"gravestone").then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_2338 pos;
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            if (!world.method_8320(pos = class_2262.method_48299((CommandContext)context, (String)"position")).method_27852(GravestonesRegistry.GRAVESTONE_TECHNICAL)) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.gravestones.getdata.gravestone.no_gravestone").method_27692(class_124.field_1061), false);
            } else {
                class_2586 patt0$temp = world.method_8321(pos);
                if (patt0$temp instanceof TechnicalGravestoneBlockEntity) {
                    TechnicalGravestoneBlockEntity entity = (TechnicalGravestoneBlockEntity)patt0$temp;
                    GraveOwner graveOwner = entity.getGraveOwner();
                    if (graveOwner != null) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.gravestones.getdata.gravestone.all_data", (Object[])new Object[]{entity.getSpawnDateTime(), graveOwner.getNotNullName(), graveOwner.getUuid()}).method_27692(class_124.field_1060), false);
                    } else {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.gravestones.getdata.gravestone.no_grave_owner", (Object[])new Object[]{entity.getSpawnDateTime()}).method_27692(class_124.field_1061), false);
                    }
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.gravestones.getdata.gravestone.contents_data", (Object[])new Object[]{class_2512.method_32270((class_2520)entity.getContents())}), false);
                }
            }
            return 1;
        })))).then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            List<RecentGraveHistory> histories = GravestoneDataSaving.readHistories(((class_2168)context.getSource()).method_9211());
            UUID uuid = VersionUtil.getId(class_2186.method_9315((CommandContext)context, (String)"player").method_7334());
            List<class_4208> positions = null;
            for (RecentGraveHistory history : histories) {
                if (!history.owner().equals(uuid)) continue;
                positions = history.getList();
                break;
            }
            if (positions == null) {
                Gravestones.LOGGER.error("Could not find gravestone data file!");
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.gravestones.getdata.player.cannot_find").method_27692(class_124.field_1061), false);
                return 0;
            }
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            class_2561 first = GravestoneManager.posToText((class_4208)positions.get(0));
            class_2561 second = GravestoneManager.posToText(positions.get(1));
            class_2561 third = GravestoneManager.posToText(positions.get(2));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.gravestones.getdata.player.grave_data", (Object[])new Object[]{player.method_5476(), first, second, third}), false);
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deaths").then(class_2170.method_9247((String)"view").then(class_2170.method_9244((String)"death", (ArgumentType)DeathArgumentType.death()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_2487 nbt = DeathArgumentType.getDeath((CommandContext<class_2168>)context, "death");
            source.method_9226(() -> class_2561.method_43469((String)"commands.gravestones.deaths.view", (Object[])new Object[]{class_2512.method_32270((class_2520)VersionUtil.getCompoundOrEmpty(nbt, "contents"))}), false);
            return 1;
        })))).then(class_2170.method_9247((String)"recover").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"death", (ArgumentType)DeathArgumentType.death()).executes(context -> GravestonesCommands.recoverDeath((CommandContext<class_2168>)context, DeathArgumentType.getDeath((CommandContext<class_2168>)context, "death"), ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> GravestonesCommands.recoverDeath((CommandContext<class_2168>)context, DeathArgumentType.getDeath((CommandContext<class_2168>)context, "death"), class_2186.method_9315((CommandContext)context, (String)"player")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"getuuid").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> GravestonesCommands.getUuid((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player"))))).executes(context -> GravestonesCommands.getUuid((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_9207())))));
    }

    private static int recoverDeath(CommandContext<class_2168> context, class_2487 nbt, class_3222 player) {
        GravestonesApi.onCollect(((class_2168)context.getSource()).method_9225(), player.method_24515(), (class_1657)player, 0, VersionUtil.getCompoundOrEmpty(nbt, "contents").method_10553());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.gravestones.deaths.recover"), true);
        return 1;
    }

    private static int getUuid(CommandContext<class_2168> context, class_3222 player) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.gravestones.getuuid", (Object[])new Object[]{player.method_5476(), player.method_5845()}), false);
        return 1;
    }
}

