package net.pneumono.gravestones.content;

import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2319;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_4970;
import net.minecraft.class_5837;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.registry.*;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.api.CancelGravestonePlacementCallback;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.api.InsertGravestoneItemCallback;
import net.pneumono.gravestones.block.*;
import net.pneumono.gravestones.networking.UpdateGravestoneC2SPayload;
import net.pneumono.pneumonocore.util.MultiVersionUtil;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
//? if >=1.20.6 {
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.pneumono.gravestones.networking.GravestoneEditorOpenS2CPayload;
//?}

public class GravestonesRegistry {
    public static final class_2248 GRAVESTONE_TECHNICAL = registerGravestone("gravestone_technical",
            TechnicalGravestoneBlock::new, class_4970.class_2251.method_9630(class_2246.field_10340).method_9629(-1.0F, 3600000.0F).method_22488());
    public static final class_2248 GRAVESTONE = registerAestheticGravestone("gravestone",
            AestheticGravestoneBlock::new, class_4970.class_2251.method_9630(class_2246.field_10340).method_9632(3.5F).method_22488().method_29292());
    public static final class_2248 GRAVESTONE_CHIPPED = registerAestheticGravestone("gravestone_chipped",
            AestheticGravestoneBlock::new, class_4970.class_2251.method_9630(class_2246.field_10340).method_9632(3.5F).method_22488().method_29292());
    public static final class_2248 GRAVESTONE_DAMAGED = registerAestheticGravestone("gravestone_damaged",
            AestheticGravestoneBlock::new, class_4970.class_2251.method_9630(class_2246.field_10340).method_9632(3.5F).method_22488().method_29292());

    public static class_2591<TechnicalGravestoneBlockEntity> TECHNICAL_GRAVESTONE_ENTITY = class_2378.method_10230(
            class_7923.field_41181, Gravestones.id("technical_gravestone"), FabricBlockEntityTypeBuilder.create(
                    TechnicalGravestoneBlockEntity::new,
                    GRAVESTONE_TECHNICAL
            ).build()
    );
    public static class_2591<AestheticGravestoneBlockEntity> AESTHETIC_GRAVESTONE_ENTITY = class_2378.method_10230(
            class_7923.field_41181, Gravestones.id("aesthetic_gravestone"), FabricBlockEntityTypeBuilder.create(
                    AestheticGravestoneBlockEntity::new,
                    GRAVESTONE, GRAVESTONE_CHIPPED, GRAVESTONE_DAMAGED
            )/*? if >=1.21.4 {*//*.canPotentiallyExecuteCommands(true)*//*?}*/.build()
    );

    public static final class_1299<GravestoneSkeletonEntity> GRAVESTONE_SKELETON_ENTITY_TYPE = class_2378.method_10230(
            class_7923.field_41177,
            Gravestones.id("gravestone_skeleton"),
            class_1299.class_1300.<GravestoneSkeletonEntity>method_5903(GravestoneSkeletonEntity::new, class_1311.field_17715)
                    //? if >=1.20.6 {
                    .method_17687(0.6F, 1.99F)
                    //?} else {
                    /*.setDimensions(0.6F, 1.99F)
                    *///?}
                    .method_27299(8)
                    //? if >=1.21.3 {
                    /*.build(RegistryKey.of(RegistryKeys.ENTITY_TYPE, Gravestones.id("gravestone_skeleton")))
                    *///?} else {
                    .method_5905("gravestone_skeleton")
                    //?}
    );

    public static final class_6862<class_1792> ITEM_SKIPS_GRAVESTONES = class_6862.method_40092(class_7924.field_41197, Gravestones.id("skips_gravestones"));
    public static final class_6862<class_1887> ENCHANTMENT_SKIPS_GRAVESTONES = class_6862.method_40092(class_7924.field_41265, Gravestones.id("skips_gravestones"));
    public static final class_6862<class_2248> BLOCK_GRAVESTONE_IRREPLACEABLE = class_6862.method_40092(class_7924.field_41254, Gravestones.id("gravestone_irreplaceable"));

    public static final class_3414 SOUND_BLOCK_WAXED_GRAVESTONE_INTERACT_FAIL = registerSoundEvent("block.gravestone.waxed_interact_fail");
    public static final class_3414 SOUND_BLOCK_GRAVESTONE_ADD_SKULL = registerSoundEvent("block.gravestone.add_skull");
    public static final class_3414 SOUND_BLOCK_GRAVESTONE_REMOVE_SKULL = registerSoundEvent("block.gravestone.remove_skull");

    public static final class_2960 GRAVESTONES_COLLECTED = Gravestones.id("gravestones_collected");

    private static class_2248 registerAestheticGravestone(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        class_2248 block = registerGravestone(name, factory, settings);
        class_2378.method_10230(class_7923.field_41178, Gravestones.id(name), new AestheticGravestoneBlockItem(block,
                new class_1792.class_1793()/*? if >=1.21.3 {*//*.useBlockPrefixedTranslationKey().registryKey(RegistryKey.of(RegistryKeys.ITEM, Gravestones.id(name)))*//*?}*/
        ));
        return block;
    }

    private static class_2248 registerGravestone(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return class_2378.method_10230(class_7923.field_41175, Gravestones.id(name),
                factory.apply(settings/*? if >=1.21.3 {*//*.registryKey(RegistryKey.of(RegistryKeys.BLOCK, Gravestones.id(name)))*//*?}*/)
        );
    }

    private static class_3414 registerSoundEvent(String name) {
        class_2960 id = Gravestones.id(name);
        return class_2378.method_10230(class_7923.field_41172, id, class_3414.method_47908(id));
    }

    public static void registerModContent() {
        FabricDefaultAttributeRegistry.register(GRAVESTONE_SKELETON_ENTITY_TYPE,
                GravestoneSkeletonEntity.method_26905()
        );

        ArgumentTypeRegistry.registerArgumentType(
                Gravestones.id("deaths"),
                DeathArgumentType.class,
                class_2319.method_41999(DeathArgumentType::new)
        );

        registerAPIUsages();

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40197).register(content -> {
            content.method_45421(GRAVESTONE);
            content.method_45421(GRAVESTONE_CHIPPED);
            content.method_45421(GRAVESTONE_DAMAGED);
        });

        class_2378.method_10226(class_7923.field_41183, "gravestones_collected", GRAVESTONES_COLLECTED);
        class_3468.field_15419.method_14955(GRAVESTONES_COLLECTED, class_3446.field_16975);

        //? if >=1.20.6 {
        PayloadTypeRegistry.playS2C().register(GravestoneEditorOpenS2CPayload.PAYLOAD_ID, GravestoneEditorOpenS2CPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(UpdateGravestoneC2SPayload.PAYLOAD_ID, UpdateGravestoneC2SPayload.CODEC);

        ServerPlayNetworking.registerGlobalReceiver(UpdateGravestoneC2SPayload.PAYLOAD_ID, (payload, context) -> {
            List<String> list = Stream.of(payload.getText()).map(class_124::method_539).collect(Collectors.toList());
            context.player().field_13987.method_31279(list).thenAcceptAsync(texts ->
                    onSignUpdate(context.player(), payload, texts), context.server()
            );
        });
        //?} else {
        /*ServerPlayNetworking.registerGlobalReceiver(UpdateGravestoneC2SPayload.ID, (server, player, handler, buf, sender) -> {
            UpdateGravestoneC2SPayload payload = UpdateGravestoneC2SPayload.read(buf);

            List<String> list = Stream.of(payload.getText()).map(Formatting::strip).collect(Collectors.toList());
            player.networkHandler.filterTexts(list).thenAcceptAsync(texts ->
                    onSignUpdate(player, payload, texts), server
            );
        });
        *///?}
    }

    private static void registerAPIUsages() {
        GravestonesApi.registerDataType(Gravestones.id("inventory"), new PlayerInventoryDataType());
        GravestonesApi.registerDataType(Gravestones.id("experience"), new ExperienceDataType());

        InsertGravestoneItemCallback.EVENT.register((player, itemStack) ->
                itemStack.method_31573(ITEM_SKIPS_GRAVESTONES) ||
                //? if >=1.21.1 {
                /*EnchantmentHelper.hasAnyEnchantmentsIn(itemStack, ENCHANTMENT_SKIPS_GRAVESTONES)
                *///?} else {
                hasSkippableEnchantments(itemStack)
                //?}
        );
        InsertGravestoneItemCallback.EVENT.register((player, itemStack) ->
                //? if >=1.21.1 {
                /*EnchantmentHelper.hasAnyEnchantmentsWith(itemStack, EnchantmentEffectComponentTypes.PREVENT_EQUIPMENT_DROP)
                *///?} else {
                class_1890.method_8221(itemStack)
                //?}
        );

        CancelGravestonePlacementCallback.EVENT.register((world, player, deathPos) ->
                world.method_8450().method_8355(class_1928.field_19389) && !GravestonesConfig.SPAWN_GRAVESTONES_WITH_KEEPINV.getValue()
        );
        CancelGravestonePlacementCallback.EVENT.register((world, player, deathPos) ->
                player.method_7337() && !GravestonesConfig.SPAWN_GRAVESTONES_IN_CREATIVE.getValue()
        );
    }

    //? if <1.20.6 {
    /*@SuppressWarnings("deprecation")
    *///?}
    //? if <1.21.1 {
    private static boolean hasSkippableEnchantments(class_1799 stack) {
        //? if >=1.20.6 {
        class_9304 component = stack.method_58657();
        for (class_6880<class_1887> enchantment : component.method_57534()) {
            if (enchantment.method_40220(ENCHANTMENT_SKIPS_GRAVESTONES)) {
                return true;
            }
        }
        return false;
        //?} else {
        /*for (RegistryEntry<Enchantment> enchantment : EnchantmentHelper.get(stack).keySet().stream()
                .map(Registries.ENCHANTMENT::getEntry)
                .toList()
        ) {
            if (enchantment.isIn(ENCHANTMENT_SKIPS_GRAVESTONES)) {
                return true;
            }
        }
        return false;
        *///?}
    }
    //?}

    @SuppressWarnings("deprecation")
    private static void onSignUpdate(class_3222 player, UpdateGravestoneC2SPayload payload, List<class_5837> signText) {
        player.method_14234();
        class_3218 serverWorld = (class_3218) MultiVersionUtil.getWorld(player);
        class_2338 blockPos = payload.pos();
        if (serverWorld.method_22340(blockPos)) {
            if (!(serverWorld.method_8321(blockPos) instanceof AestheticGravestoneBlockEntity blockEntity)) {
                return;
            }

            blockEntity.tryChangeText(player, signText);
        }
    }
}
