package net.pneumono.gravestones.gravestones;

import net.minecraft.block.*;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.api.CancelGravestonePlacementCallback;
import net.pneumono.gravestones.api.GravestonePlacedCallback;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.block.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.multiversion.GraveOwner;
import net.pneumono.gravestones.multiversion.VersionUtil;
import net.pneumono.pneumonocore.util.MultiVersionUtil;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class GravestoneCreation extends GravestoneManager {
    public static void create(class_1657 player) {
        class_1937 world = MultiVersionUtil.getWorld(player);
        if (!(world instanceof class_3218 serverWorld)) {
            return;
        }

        checkConsoleInfoConfig();

        info("----- Beginning Gravestone Creation -----");
        info("If you don't want to see this, disable 'Console Info' in the configs!");
        create(serverWorld, player);
        info("----- Finishing Gravestone Creation -----");
    }

    private static void create(class_3218 deathWorld, class_1657 player) {
        class_4208 deathPos = VersionUtil.createGlobalPos(deathWorld.method_27983(), player.method_24515());
        MinecraftServer server = deathWorld.method_8503();

        // Check if placement should be cancelled
        info("Checking if Gravestone Placement should be cancelled...");
        if (CancelGravestonePlacementCallback.EVENT.invoker().shouldCancel(
                deathWorld, player, deathPos
        )) {
            info("Placement cancelled!");
            return;
        }
        info("Placement not cancelled");

        // Read gravestone history
        CompletableFuture<List<RecentGraveHistory>> historiesFuture = CompletableFuture.supplyAsync(() -> {
            info("Reading gravestone history...");
            return GravestoneDataSaving.readHistories(server);
        });

        // Create contents data
        info("Creating gravestone contents data...");
        class_2487 contents = createContentsData(player);
        // Backup contents data
        CompletableFuture.runAsync(() -> {
            info("Backing up gravestone contents data...");
            GravestoneDataSaving.saveBackup(contents, player);
        });

        // Calculate placement position
        info("Calculating gravestone placement position...");
        class_4208 gravestonePos = getPlacementPos(deathWorld, player, deathPos);

        historiesFuture.thenAcceptAsync(histories -> {
            histories = new ArrayList<>(histories);
            RecentGraveHistory history = getHistory(histories, player.method_5667());

            // Create new gravestone history
            info("Updating gravestone history...");
            RecentGraveHistory newHistory;
            if (history == null) {
                newHistory = new RecentGraveHistory(player.method_5667(), gravestonePos);
            } else {
                newHistory = history.getShifted(gravestonePos);
            }
            histories.add(newHistory);

            // Write new gravestone history
            info("Writing updated gravestone history...");
            GravestoneDataSaving.writeData(server, histories);
        });

        String playerName = VersionUtil.getName(player.method_7334());

        // Place gravestone
        info("Placing gravestone...");
        if (gravestonePos != null && (class_1937)(server.method_3847(VersionUtil.getDimension(gravestonePos))) instanceof class_3218 graveWorld) {
            placeGravestone(server, gravestonePos);
            Gravestones.LOGGER.info("Placed {}'s Gravestone at {}", playerName, posToString(gravestonePos));
        } else {
            GravestonesApi.onBreak(deathWorld, VersionUtil.getPos(deathPos), 0, contents == null ? new class_2487() : contents);
            Gravestones.LOGGER.info("Failed to place {}'s Gravestone! The items have been dropped on the ground", playerName);
            return;
        }

        // Insert gravestone contents
        info("Inserting contents into gravestone...");
        insertGravestoneContents(graveWorld, player, gravestonePos, contents);

        // Broadcast chat message
        info("Broadcasting chat message... (if enabled)");
        if (GravestonesConfig.BROADCAST_COORDINATES_IN_CHAT.getValue()) {
            server.method_3760().method_43514(class_2561.method_43469("gravestones.grave_spawned", playerName, posToString(VersionUtil.getPos(gravestonePos))), false);
        }

        info("Damaging existing gravestones... (if enabled)");
        try {
            // Damage existing gravestones
            RecentGraveHistory history = getHistory(new ArrayList<>(historiesFuture.get()), player.method_5667());
            if (history != null) {
                GravestoneDecay.deathDamageOldGravestones(server, history.getList(), gravestonePos);
            }
        } catch (ExecutionException | InterruptedException e) {
            error("Failed to damage existing gravestones", e);
        }

        // Callbacks
        info("Invoking GravestonePlacedCallbacks...");
        GravestonePlacedCallback.EVENT.invoker().afterGravestonePlace(deathWorld, player, deathPos, gravestonePos);
    }

    public static RecentGraveHistory getHistory(List<RecentGraveHistory> histories, UUID uuid) {
        RecentGraveHistory history = null;
        for (int i = 0; i < histories.size(); ++i) {
            RecentGraveHistory checkedHistory = histories.get(i);
            if (checkedHistory.owner().equals(uuid)) {
                history = histories.remove(i);
                break;
            }
        }

        return history;
    }

    private static class_2487 createContentsData(class_1657 player) {
        class_2487 contents;
        try {
            contents = GravestonesApi.getDataToInsert(player);
        } catch (Exception e) {
            return new class_2487();
        }

        return contents;
    }

    private static void insertGravestoneContents(class_3218 world, class_1657 player, class_4208 gravestonePos, class_2487 contents) {
        if (!(world.method_8321(VersionUtil.getPos(gravestonePos)) instanceof TechnicalGravestoneBlockEntity gravestone)) return;

        gravestone.setContents(contents);
        gravestone.setGraveOwner(new GraveOwner(player.method_7334()));
        gravestone.setSpawnDate(GravestoneTime.READABLE.format(new Date()), world.method_8510());

        world.method_8413(VersionUtil.getPos(gravestonePos), gravestone.method_11010(), gravestone.method_11010(), class_2248.field_31028);
    }

    private static class_4208 getPlacementPos(class_3218 world, class_1657 player, class_4208 deathPos) {
        class_2874 dimension = world.method_8597();
        class_4208 clampedDeathPos = VersionUtil.createGlobalPos(VersionUtil.getDimension(deathPos), VersionUtil.getPos(deathPos).method_33096(
                class_3532.method_15340(VersionUtil.getPos(deathPos).method_10264(), dimension.comp_651(), dimension.comp_651() + dimension.comp_652())
        ));
        class_4208 validPos = GravestonePlacement.getRedirectableValidPos(world, player, clampedDeathPos);

        if (validPos == null || world.method_8503().method_3847(VersionUtil.getDimension(validPos)) == null) return null;

        return validPos;
    }

    protected static void placeGravestone(MinecraftServer server, class_4208 gravestonePos) {
        class_3218 world = server.method_3847(VersionUtil.getDimension(gravestonePos));

        if (world == null) return;

        class_2338 pos = VersionUtil.getPos(gravestonePos);
        class_2680 gravestoneBlock = GravestonesRegistry.GRAVESTONE_TECHNICAL.method_9564();
        if (world.method_8320(pos).method_26227().method_15767(class_3486.field_15517)) {
            gravestoneBlock = gravestoneBlock.method_11657(class_2741.field_12508, true);
        }

        world.method_22352(pos, true);
        world.method_8501(pos, gravestoneBlock);
    }
}
