/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core;

import io.homo.superresolution.common.platform.Arch;
import io.homo.superresolution.common.platform.OS;
import io.homo.superresolution.common.platform.OSType;
import io.homo.superresolution.core.SuperResolutionNative;
import io.homo.superresolution.core.utils.Md5CaculateUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import net.minecraft.class_155;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibManager {
    public static final String BASE_PATH = "lib";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution-NativeLib");
    private static final ArrayList<NativeLib> libs = new ArrayList();
    private static boolean nativeApiAvailable;

    public static boolean nativeApiAvailable() {
        return nativeApiAvailable;
    }

    public static void extract(String path) {
        LOGGER.info("\u5f00\u59cb\u63d0\u53d6\u4f9d\u8d56\u5e93\u6587\u4ef6");
        boolean status = true;
        String error = null;
        try {
            for (NativeLib lib : libs) {
                if (NativeLibManager.extractLibrary(path, lib)) continue;
                status = false;
            }
        }
        catch (Exception e) {
            status = false;
            error = e.toString();
        }
        if (!status) {
            LOGGER.error("\u4f9d\u8d56\u5e93\u63d0\u53d6\u5931\u8d25;\u4fe1\u606f: {}", (Object)(error != null ? error : "\u65e0"));
            throw new RuntimeException("\u4f9d\u8d56\u5e93\u63d0\u53d6\u5931\u8d25");
        }
        LOGGER.info("\u4f9d\u8d56\u5e93\u6587\u4ef6\u5df2\u63d0\u53d6\u5230 {}", (Object)path);
    }

    public static boolean check(String path) {
        boolean status = true;
        for (NativeLib lib : libs) {
            if (NativeLibManager.existsLib(path, lib) && NativeLibManager.checkLibMd5(path, lib)) continue;
            status = false;
        }
        return status;
    }

    private static boolean checkLibMd5(String path, NativeLib lib) {
        if (class_155.field_1125) {
            return false;
        }
        return lib.md5.equals(Md5CaculateUtil.getMD5(Paths.get(path, lib.name).toFile()));
    }

    private static boolean existsLib(String path, NativeLib lib) {
        File f = Paths.get(path, lib.name).toFile();
        return f.exists() && f.isFile() && f.canRead() && f.canExecute();
    }

    public static void load(String path) {
        for (NativeLib lib : libs) {
            File f = Paths.get(path, lib.name).toFile();
            LOGGER.info("\u52a0\u8f7d\u4f9d\u8d56\u5e93\uff1a {}", (Object)f.getAbsolutePath());
            System.load(f.getAbsolutePath());
        }
        nativeApiAvailable = true;
        LOGGER.info("\u4f9d\u8d56\u5e93\u7248\u672c\uff1a {}", (Object)SuperResolutionNative.getVersionInfo());
    }

    private static boolean _writeFile(InputStream in, String path) throws IOException {
        if (in == null) {
            return false;
        }
        Path filePath = Path.of(path, new String[0]);
        try {
            Files.copy(in, filePath, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean extractLibrary(String path, NativeLib library) throws IOException {
        Path sourcePath = Paths.get(BASE_PATH, library.name);
        Path targetPath = Paths.get(path, library.name);
        try (InputStream in = NativeLibManager.class.getClassLoader().getResourceAsStream(sourcePath.toFile().toString().replace("\\", "/"));){
            if (in == null) {
                boolean bl = false;
                return bl;
            }
            if (!NativeLibManager._writeFile(in, targetPath.toString())) throw new IOException(library.name + " \u63d0\u53d6\u5931\u8d25");
            LOGGER.info("{} \u63d0\u53d6\u6210\u529f", (Object)library.name);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("{} \u63d0\u53d6\u5931\u8d25;\u4fe1\u606f: {}", (Object)library.name, (Object)e.toString());
            throw e;
        }
    }

    public static void main(String[] args) {
        if (!NativeLibManager.check("I:\\superresolution\\fabric\\run")) {
            LOGGER.info("\u6b63\u5728\u63d0\u53d6\u4f9d\u8d56\u5e93");
            NativeLibManager.extract("I:\\superresolution\\fabric\\run");
        }
        NativeLibManager.load("I:\\superresolution\\fabric\\run");
    }

    static {
        OS os = new OS();
        if (os.type == OSType.WINDOWS && os.arch == Arch.X86_64) {
            libs.add(new NativeLib("libSuperResolution+win64", "7d083c7c15ddee2c2e3cf1c67231e9f7", 1));
        }
        if (os.type == OSType.ANDROID && os.arch == Arch.AARCH64) {
            libs.add(new NativeLib("libSuperResolution+android", "d0b33be24e664881e4b66b9dae1f56b1", 1));
        }
        if (os.type == OSType.LINUX && os.arch == Arch.X86_64) {
            libs.add(new NativeLib("libSuperResolution+linux64", "c2c38eede35a0814f9b490979d491b97", 1));
        }
    }

    public static class NativeLib {
        public String name;
        public String md5;
        public int type = 0;

        public NativeLib(String name, String md5, int type) {
            this.name = NativeLib.formatLibName(name);
            this.md5 = md5;
            this.type = type;
        }

        public NativeLib(String name, String md5) {
            this.name = NativeLib.formatLibName(name);
            this.md5 = md5;
        }

        protected static String formatLibName(String name) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("windows")) {
                return name + ".dll";
            }
            return name + ".so";
        }
    }
}

