/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.pipeline.jobs;

import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.pipeline.GlPipeline;
import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineJobDispatchResource;
import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineJobType;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceAccess;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceDescription;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceDescriptions;

public abstract class GlPipelineJob {
    public GlPipelineResourceDescriptions resourcesMap;
    public GlPipelineJobType type;
    public GlPipeline pipeline;

    public void bindPipeline(GlPipeline pipeline) {
        this.pipeline = pipeline;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupImage2DResource(GlPipelineResourceDescription description) {
        if (description.src() == null) throw new NullPointerException("\u8d44\u6e90\u63cf\u8ff0\u7684\u7eb9\u7406\u4e3a\u7a7a\u503c " + String.valueOf(description));
        if (description.src().getTextureFormat() == null) throw new NullPointerException("\u8d44\u6e90\u63cf\u8ff0\u7684\u7eb9\u7406\u4e0d\u4e3a\u7a7a\u503c\u4f46\u7eb9\u7406\u683c\u5f0f\u4e3a\u7a7a\u503c" + String.valueOf(description));
        int access = switch (description.access()) {
            default -> throw new IncompatibleClassChangeError();
            case GlPipelineResourceAccess.READ -> 35000;
            case GlPipelineResourceAccess.WRITE -> 35001;
            case GlPipelineResourceAccess.BOTH -> 35002;
        };
        Gl.glBindImageTexture(description.unit(), description.src().getTextureId(), 0, false, 0, access, description.src().getTextureFormat().gl());
    }

    public GlPipelineResourceDescription getResource(String name) {
        return this.resourcesMap.resource.get(name);
    }

    protected void setupSampler2DResource(GlPipelineResourceDescription description) {
        if (description.src() != null) {
            int unit = description.unit();
            Gl.glBindTextureUnit(unit, description.src().getTextureId());
            if (description.sampler() != null) {
                Gl.glBindSampler(unit, description.sampler().id);
            }
        }
    }

    protected void setupUniformBufferResource(GlPipelineResourceDescription description) {
        if (description.ubo() != null) {
            int unit = description.unit();
            description.ubo().bind(unit);
        }
    }

    protected void setupResource() {
        this.resourcesMap.resource.forEach((name, description) -> {
            switch (description.type()) {
                case Image2D: {
                    this.setupImage2DResource((GlPipelineResourceDescription)description);
                    break;
                }
                case Sampler2D: {
                    this.setupSampler2DResource((GlPipelineResourceDescription)description);
                    break;
                }
                case UniformBuffer: {
                    this.setupUniformBufferResource((GlPipelineResourceDescription)description);
                }
            }
        });
    }

    public abstract void schedule(GlPipelineJobDispatchResource var1);

    public abstract void execute(GlPipelineJobDispatchResource var1);
}

