/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.platform;

import com.sun.jna.Platform;
import net.minecraft.network.chat.Component;

public enum SystemArchitecture {
    AARCH64("aarch64"),
    ARM32("arm"),
    X86_64("x86-64"),
    X86("x86"),
    ANY("&^*");

    private final String platformArch;

    private SystemArchitecture(String platformArch) {
        this.platformArch = platformArch;
    }

    public static SystemArchitecture get() {
        String arch = Platform.ARCH;
        for (SystemArchitecture a : SystemArchitecture.values()) {
            if (a == ANY || !a.platformArch.equals(arch)) continue;
            return a;
        }
        return ANY;
    }

    public boolean equals(SystemArchitecture arch) {
        return arch == ANY || SystemArchitecture.get() == arch;
    }

    public String getString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case AARCH64 -> "aarch64";
            case ARM32 -> "arm32";
            case X86_64 -> "x64";
            case X86 -> "x32";
            case ANY -> Component.m_237115_((String)"superresolution.requirement.os.any").getString();
        };
    }
}

