/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.config.special;

import io.homo.superresolution.api.SuperResolutionAPI;
import io.homo.superresolution.api.config.ModConfigSpecBuilder;
import io.homo.superresolution.api.config.values.single.BooleanValue;
import io.homo.superresolution.api.config.values.single.EnumValue;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.ConfigSpecType;
import io.homo.superresolution.common.config.special.SpecialConfig;
import io.homo.superresolution.common.config.special.SpecialConfigDescription;
import io.homo.superresolution.common.upscale.AlgorithmDescriptions;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Version;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;

public class FSR2SpecialConfig
extends SpecialConfig {
    public EnumValue<Fsr2Version> VERSION;
    public BooleanValue FP16;

    public FSR2SpecialConfig(ModConfigSpecBuilder specBuilder) {
        super(specBuilder);
        this.VERSION = this.specBuilder.defineEnum("special/fsr2/version", Fsr2Version.class, () -> Fsr2Version.V233);
        this.FP16 = this.specBuilder.defineBoolean("special/fsr2/fp16", () -> true, "");
    }

    @Override
    protected void buildDescriptions(Map<String, SpecialConfigDescription<?>> map) {
        map.put("fp16", new SpecialConfigDescription<Boolean>().setValue((Boolean)this.getSpecialConfigs().FSR2.FP16.get()).setKey("fp16").setName((Component)Component.m_237115_((String)"superresolution.screen.config.special.fsr2.fp16.name")).setTooltip((Component)Component.m_237115_((String)"superresolution.screen.config.special.fsr2.fp16.tooltip")).setType(ConfigSpecType.BOOLEAN).setSaveConsumer(v -> {
            if (this.getSpecialConfigs().FSR2.FP16.get() != v) {
                this.getSpecialConfigs().FSR2.FP16.set(v);
                if (SuperResolutionAPI.getCurrentAlgorithmDescription() == AlgorithmDescriptions.FSR2) {
                    SuperResolution.recreateAlgorithm();
                }
            }
        }).setDefaultValue(true));
        map.put("version", new SpecialConfigDescription().setValue(this.getSpecialConfigs().FSR2.VERSION.get()).setDefaultValue(Fsr2Version.V233).setValueNameSupplier(variant -> switch ((Fsr2Version)((Object)((Object)variant))) {
            default -> throw new IncompatibleClassChangeError();
            case Fsr2Version.V233 -> Optional.of(Component.m_237113_((String)"2.3.3"));
            case Fsr2Version.V221 -> Optional.of(Component.m_237113_((String)"2.2.1"));
        }).setName((Component)Component.m_237115_((String)"superresolution.screen.config.special.fsr2.version.name")).setTooltip((Component)Component.m_237115_((String)"superresolution.screen.config.special.fsr2.version.tooltip")).setKey("version").setSaveConsumer(v -> {
            if (this.getSpecialConfigs().FSR2.VERSION.get() != v) {
                this.getSpecialConfigs().FSR2.VERSION.set(v);
                if (SuperResolutionAPI.getCurrentAlgorithmDescription() == AlgorithmDescriptions.FSR2) {
                    SuperResolution.recreateAlgorithm();
                }
            }
        }).setType(ConfigSpecType.ENUM).setClazz(Fsr2Version.class));
    }
}

