/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.options;

import io.homo.superresolution.common.gui.impl.Text;
import io.homo.superresolution.common.gui.options.OptionBuilder;
import io.homo.superresolution.common.gui.options.OptionCategory;
import io.homo.superresolution.common.gui.screens.MaterialStyleConfigScreen;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class OptionScreenBuilder {
    protected HashMap<Text, OptionCategory> categories = new HashMap();
    protected Text title = Text.empty();

    public Text getTitle() {
        return this.title;
    }

    public OptionScreenBuilder setTitle(Text title) {
        this.title = title;
        return this;
    }

    public OptionCategory getOrCreateCategory(Text name) {
        OptionCategory category;
        if (this.categories.containsKey(name) && (category = this.categories.get(name)) != null) {
            return category;
        }
        category = new OptionCategory(name);
        this.categories.put(name, category);
        return category;
    }

    public OptionBuilder getOptionBuilder(@NotNull OptionCategory category) {
        return new OptionBuilder(category);
    }

    public OptionBuilder getOptionBuilder(@NotNull Text name) {
        return new OptionBuilder(this.getOrCreateCategory(name));
    }

    public MaterialStyleConfigScreen build() {
        return new MaterialStyleConfigScreen(this.title, this.categories.values().stream().toList());
    }
}

