/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.options;

import com.google.common.collect.ImmutableList;
import io.homo.superresolution.common.gui.impl.Text;
import io.homo.superresolution.common.gui.options.AbstractOptionEntry;
import io.homo.superresolution.common.gui.options.OptionContainerWidget;
import io.homo.superresolution.core.gui.MaterialScheme;
import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.widgets.button.MaterialButton;
import io.homo.superresolution.core.gui.widgets.button.MaterialButtonSize;
import io.homo.superresolution.core.gui.widgets.label.MaterialLabel;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class SelectionListOptionEntry<T>
extends AbstractOptionEntry<T, SelectionListOptionEntry<T>> {
    protected final ImmutableList<T> values;
    protected final AtomicInteger index;
    protected final int original;
    protected MaterialButton selectButton;
    protected MaterialLabel label;
    protected Function<T, String> nameProvider;

    public SelectionListOptionEntry(Text name, T value, ImmutableList<T> values) {
        super(name, value);
        this.values = values;
        this.index = new AtomicInteger(values.indexOf(value));
        this.index.compareAndSet(-1, 0);
        this.original = values.indexOf(value);
        this.nameProvider = t -> t.toString();
        this.init();
    }

    @Override
    protected void init() {
        this.container = new OptionContainerWidget(this);
        this.initLayout();
        this.initWidget();
    }

    @Override
    protected void initLayout() {
    }

    @Override
    protected void initWidget() {
        this.selectButton = MaterialButton.create(MaterialButtonSize.Small).text(() -> this.nameProvider.apply(this.value()));
        this.selectButton.onClick(event -> {
            this.index.incrementAndGet();
            this.index.compareAndSet(this.values.size(), 0);
            if (this.saveConsumer != null) {
                this.saveConsumer.accept(this.value());
            }
        });
        this.label = MaterialLabel.create().text(() -> this.name.getString());
        this.container.addChild(this.label);
        this.container.addChild(this.selectButton);
        this.container.scheme(this.scheme);
    }

    @Override
    protected SelectionListOptionEntry<T> setScheme(MaterialScheme scheme) {
        this.selectButton.scheme(scheme);
        this.label.scheme(scheme);
        return (SelectionListOptionEntry)super.setScheme(scheme);
    }

    @Override
    public void render(IUIDrawContext drawContext, UIInputState inputState) {
        this.selectButton.text(this.nameProvider.apply(this.value()));
        this.container.render(drawContext, inputState);
    }

    public boolean isEdited() {
        return !Objects.equals(this.index.get(), this.original);
    }

    @Override
    public T value() {
        return (T)this.values.get(this.index.get());
    }

    private int getDefaultIndex() {
        return this.defaultValue == null ? 0 : Math.max(0, this.values.indexOf(this.defaultValue.get()));
    }

    public SelectionListOptionEntry<T> setNameProvider(Function<T, String> nameProvider) {
        this.nameProvider = nameProvider != null ? nameProvider : t -> t.toString();
        return this;
    }
}

