/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureMipmapSettings;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.impl.texture.TextureWrapMode;
import io.homo.superresolution.core.graphics.opengl.GlDebug;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL43;

public class LegacyStorageFrameBuffer
extends RenderTarget
implements IFrameBuffer,
IBindableFrameBuffer {
    private int colorAttachment1 = -1;
    private boolean stencilEnabled = false;
    private String label;

    public LegacyStorageFrameBuffer(boolean useDepth) {
        super(useDepth);
    }

    public void m_83950_(int width, int height, boolean clearError) {
        RenderSystem.assertOnRenderThreadOrInit();
        int maxSupportedTextureSize = RenderSystem.maxSupportedTextureSize();
        if (width > 0 && width <= maxSupportedTextureSize && height > 0 && height <= maxSupportedTextureSize) {
            this.f_83917_ = width;
            this.f_83918_ = height;
            this.f_83915_ = width;
            this.f_83916_ = height;
            this.f_83922_ = 9728;
            this.f_83920_ = GL43.glGenFramebuffers();
            this.f_83923_ = TextureUtil.generateTextureId();
            this.f_83924_ = TextureUtil.generateTextureId();
            this.colorAttachment1 = TextureUtil.generateTextureId();
            if (this.label == null) {
                this.label = "SRLegacyStorageFrameBuffer";
            }
            GL43.glBindFramebuffer((int)36160, (int)this.f_83920_);
            GL43.glBindTexture((int)3553, (int)this.f_83924_);
            GL43.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL43.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL43.glTexParameteri((int)3553, (int)34892, (int)0);
            GL43.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL43.glTexParameteri((int)3553, (int)10243, (int)33071);
            if (this.stencilEnabled) {
                GL43.glTexStorage2D((int)3553, (int)1, (int)35056, (int)this.f_83915_, (int)this.f_83916_);
                GL43.glFramebufferTexture2D((int)36160, (int)36128, (int)3553, (int)this.f_83924_, (int)0);
            } else {
                GL43.glTexStorage2D((int)3553, (int)1, (int)33190, (int)this.f_83915_, (int)this.f_83916_);
            }
        } else {
            throw new IllegalArgumentException("Window " + width + "x" + height + " size out of bounds (max. size: " + maxSupportedTextureSize + ")");
        }
        GL43.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.f_83924_, (int)0);
        GL43.glBindTexture((int)3553, (int)this.f_83923_);
        GL43.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL43.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL43.glTexStorage2D((int)3553, (int)1, (int)32856, (int)this.f_83915_, (int)this.f_83916_);
        GL43.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.f_83923_, (int)0);
        GL43.glBindTexture((int)3553, (int)this.colorAttachment1);
        GL43.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL43.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL43.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL43.glTexStorage2D((int)3553, (int)1, (int)TextureFormat.RG16F.gl(), (int)this.f_83915_, (int)this.f_83916_);
        this.m_83949_();
        this.m_83954_(clearError);
        this.m_83963_();
        GlDebug.objectLabel(36160, this.f_83920_, this.label);
        GlDebug.objectLabel(5890, this.f_83923_, this.label + "-ColorTexture");
        GlDebug.objectLabel(5890, this.f_83924_, this.label + "-DepthTexture");
    }

    public void enableStencil() {
        if (!this.stencilEnabled) {
            this.stencilEnabled = true;
            this.m_83941_(this.f_83917_, this.f_83918_, Minecraft.f_91002_);
        }
    }

    public boolean isStencilEnabled() {
        return this.stencilEnabled;
    }

    @Override
    public int getWidth() {
        return this.f_83915_;
    }

    @Override
    public int getHeight() {
        return this.f_83916_;
    }

    @Override
    public void destroy() {
        this.m_83930_();
    }

    @Override
    public void clearFrameBuffer() {
        this.m_83954_(Minecraft.f_91002_);
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.m_83941_(width, height, Minecraft.f_91002_);
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.Read) {
            this.m_83956_();
        } else {
            this.m_83947_(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        if (bindPoint == FrameBufferBindPoint.Read) {
            this.m_83963_();
        } else if (bindPoint == FrameBufferBindPoint.Write) {
            this.m_83970_();
        } else {
            this.m_83963_();
            this.m_83970_();
        }
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferAttachmentType.Color -> {
                if (attachmentType.getIndex() == 0) {
                    yield this.f_83923_;
                }
                yield this.colorAttachment1;
            }
            case FrameBufferAttachmentType.AnyDepth, FrameBufferAttachmentType.Depth -> this.f_83924_;
            case FrameBufferAttachmentType.DepthStencil -> this.stencilEnabled ? this.f_83924_ : -1;
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return attachmentType == FrameBufferAttachmentType.Color ? new LegacyFrameBufferTextureAdapter(false, false) : new LegacyFrameBufferTextureAdapter(true, this.stencilEnabled);
    }

    @Override
    public long handle() {
        return this.f_83920_;
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return this.stencilEnabled ? TextureFormat.DEPTH24_STENCIL8 : TextureFormat.DEPTH24;
    }

    @Override
    public void setClearColorRGBA(float red, float green, float blue, float alpha) {
        super.m_83931_(red, green, blue, alpha);
    }

    @Override
    public RenderTarget asMcRenderTarget() {
        return this;
    }

    @Override
    public void label(String label) {
        this.label = label;
    }

    class LegacyFrameBufferTextureAdapter
    implements ITexture {
        private final boolean isDepth;
        private final boolean isStencil;

        private LegacyFrameBufferTextureAdapter(boolean isDepth, boolean isStencil) {
            this.isDepth = isDepth;
            this.isStencil = isStencil;
        }

        @Override
        public TextureFormat getTextureFormat() {
            if (this.isDepth && this.isStencil) {
                return TextureFormat.DEPTH24_STENCIL8;
            }
            if (this.isDepth) {
                return TextureFormat.DEPTH24;
            }
            return TextureFormat.RGBA8;
        }

        @Override
        public TextureUsages getTextureUsages() {
            return TextureUsages.create().sampler().storage().copy();
        }

        @Override
        public TextureDescription getTextureDescription() {
            return TextureDescription.create().filterMode(this.getTextureFilterMode()).format(this.getTextureFormat()).size(this.getWidth(), this.getHeight()).type(this.getTextureType()).wrapMode(this.getTextureWrapMode()).mipmapSettings(this.getMipmapSettings()).usages(this.getTextureUsages()).build();
        }

        @Override
        public TextureType getTextureType() {
            return TextureType.Texture2D;
        }

        @Override
        public TextureFilterMode getTextureFilterMode() {
            return TextureFilterMode.Nearest;
        }

        @Override
        public TextureWrapMode getTextureWrapMode() {
            return TextureWrapMode.ClampToEdge;
        }

        @Override
        public TextureMipmapSettings getMipmapSettings() {
            return TextureMipmapSettings.disabled();
        }

        @Override
        public int getWidth() {
            return LegacyStorageFrameBuffer.this.f_83915_;
        }

        @Override
        public int getHeight() {
            return LegacyStorageFrameBuffer.this.f_83916_;
        }

        @Override
        public long handle() {
            return this.isDepth ? (long)LegacyStorageFrameBuffer.this.f_83924_ : (long)LegacyStorageFrameBuffer.this.f_83923_;
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resize(int width, int height) {
            throw new UnsupportedOperationException();
        }
    }
}

