/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.utils.ColorUtil;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL30;

public class MinecraftRenderTargetWrapper
implements IBindableFrameBuffer {
    public RenderTarget renderTarget;
    private int clearColor = ColorUtil.color(255, 0, 0, 0);

    public MinecraftRenderTargetWrapper(RenderTarget renderTarget) {
        this.renderTarget = renderTarget;
    }

    public static MinecraftRenderTargetWrapper of(RenderTarget renderTarget) {
        if (renderTarget == null) {
            return null;
        }
        MinecraftRenderTargetWrapper wrapper = new MinecraftRenderTargetWrapper(renderTarget);
        wrapper.clearColor = ColorUtil.color(255, 0, 0, 0);
        return wrapper;
    }

    @Override
    public void clearFrameBuffer() {
        this.renderTarget.m_83954_(Minecraft.f_91002_);
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.renderTarget.m_83941_(width, height, Minecraft.f_91002_);
    }

    @Override
    public int getWidth() {
        return this.renderTarget.f_83915_;
    }

    @Override
    public int getHeight() {
        return this.renderTarget.f_83916_;
    }

    @Override
    public void destroy() {
        this.renderTarget.m_83930_();
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.Read) {
            this.renderTarget.m_83956_();
        } else {
            this.renderTarget.m_83947_(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        GL30.glBindFramebuffer((int)GlFrameBuffer.resolveBindTarget(bindPoint), (int)0);
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferAttachmentType.Color -> this.renderTarget.m_83975_();
            case FrameBufferAttachmentType.AnyDepth, FrameBufferAttachmentType.Depth, FrameBufferAttachmentType.DepthStencil -> this.renderTarget.m_83980_();
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferAttachmentType.Color -> FrameBufferTextureAdapter.ofColor(this);
            case FrameBufferAttachmentType.AnyDepth, FrameBufferAttachmentType.Depth, FrameBufferAttachmentType.DepthStencil -> FrameBufferTextureAdapter.ofDepth(this);
        };
    }

    @Override
    public long handle() {
        return this.renderTarget.f_83920_;
    }

    @Override
    public void setClearColorRGBA(float red, float green, float blue, float alpha) {
        this.renderTarget.m_83931_(red, green, blue, alpha);
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return TextureFormat.DEPTH32F;
    }

    @Override
    public RenderTarget asMcRenderTarget() {
        return this.renderTarget;
    }
}

