/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.ffxfsr;

import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.core.NativeLibManager;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.GlState;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.srapi.SRCreateUpscaleContextDesc;
import io.homo.superresolution.srapi.SRDispatchUpscaleDesc;
import io.homo.superresolution.srapi.SRReturnCode;
import io.homo.superresolution.srapi.SRTextureResource;
import io.homo.superresolution.srapi.SRUpscaleContext;
import io.homo.superresolution.srapi.SRUpscaleProvider;
import io.homo.superresolution.srapi.SuperResolutionNativeAPI;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import org.joml.Vector2f;
import org.joml.Vector2i;

public class FfxFSROgl
extends AbstractAlgorithm {
    private SRUpscaleContext context;
    private ITexture srcInputColorGlTexture;
    private ITexture srcInputDepthGlTexture;
    private ITexture srcMotionVectorsGlTexture;
    private ITexture outputColorGlTexture;
    private IFrameBuffer outputColorFrameBuffer;

    public boolean updateFsr() {
        if (NativeLibManager.LIB_SUPER_RESOLUTION_FSRGL == null) {
            return false;
        }
        Path lib = NativeLibManager.LIB_SUPER_RESOLUTION_FSRGL.getTargetPath(Minecraft.m_91087_().f_91069_.toPath());
        if (!lib.toFile().isFile() || !lib.toFile().canRead()) {
            return false;
        }
        if (this.context != null && this.context.nativePtr > 0L) {
            SuperResolutionNativeAPI.srDestroyUpscaleContext(this.context);
        }
        SuperResolutionNativeAPI.srLoadUpscaleProvidersFromLibrary(lib.toAbsolutePath().toString(), "srGetFfxFSRUpscaleProviders", "srGetFfxFSRUpscaleProvidersCount");
        SRUpscaleProvider provider = new SRUpscaleProvider(0L);
        SuperResolutionNativeAPI.srGetUpscaleProvider(provider, 0x8000006L);
        this.context = new SRUpscaleContext(0L);
        SRCreateUpscaleContextDesc upscaleContextDesc = new SRCreateUpscaleContextDesc(null, null, new Vector2i(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight()), new Vector2i(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight()), 0);
        SRReturnCode code = SuperResolutionNativeAPI.srCreateUpscaleContext(this.context, provider, upscaleContextDesc);
        SuperResolution.LOGGER.info(String.valueOf(code.value));
        SuperResolution.LOGGER.info(String.valueOf(this.context.nativePtr));
        SuperResolution.LOGGER.info(String.valueOf(provider.nativePtr));
        return true;
    }

    protected void destroyTexture() {
        if (this.outputColorGlTexture != null) {
            this.outputColorGlTexture.destroy();
        }
        if (this.outputColorFrameBuffer != null) {
            this.outputColorFrameBuffer.destroy();
        }
    }

    protected void createTexture() {
        this.srcInputColorGlTexture = RenderHandlerManager.getRenderTarget().getTexture(FrameBufferAttachmentType.Color);
        this.srcInputDepthGlTexture = RenderHandlerManager.getRenderTarget().getTexture(FrameBufferAttachmentType.AnyDepth);
        this.srcMotionVectorsGlTexture = AlgorithmManager.getMotionVectorsFrameBuffer().getTexture(FrameBufferAttachmentType.Color);
        this.outputColorGlTexture = RenderSystems.opengl().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).usages(TextureUsages.create().sampler().storage()).mipmapsDisabled().filterMode(TextureFilterMode.Linear).format(SuperResolutionConfig.getInternalTextureFormat()).size(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight()).label("SRFSR2-Output").build());
        this.outputColorFrameBuffer = GlFrameBuffer.create(this.outputColorGlTexture, null);
    }

    @Override
    public void init() {
        if (!this.updateFsr()) {
            throw new RuntimeException();
        }
        this.createTexture();
    }

    @Override
    public boolean dispatch(DispatchResource dispatchResource) {
        super.dispatch(dispatchResource);
        if (this.context == null || this.context.nativePtr < 1L) {
            return false;
        }
        SRDispatchUpscaleDesc desc = new SRDispatchUpscaleDesc();
        desc.setCommandList(0L);
        desc.setColor(new SRTextureResource(dispatchResource.resources().colorTexture()));
        desc.setDepth(new SRTextureResource(dispatchResource.resources().depthTexture()));
        desc.setMotionVectors(new SRTextureResource(dispatchResource.resources().motionVectorsTexture()));
        desc.setOutput(new SRTextureResource(this.outputColorGlTexture));
        desc.setJitterOffset(new Vector2f(0.0f));
        desc.setMotionVectorScale(new Vector2f(1.0f));
        desc.setRenderSize(new Vector2i(dispatchResource.renderWidth(), dispatchResource.renderHeight()));
        desc.setUpscaleSize(new Vector2i(dispatchResource.screenWidth(), dispatchResource.screenHeight()));
        desc.setFrameTimeDelta(dispatchResource.frameTimeDelta());
        desc.setEnableSharpening(true);
        desc.setSharpness(SuperResolutionConfig.getSharpness());
        desc.setPreExposure(1.0f);
        desc.setCameraNear(0.8f);
        desc.setCameraFar(dispatchResource.cameraFar());
        desc.setCameraFovAngleVertical((float)Math.toRadians(dispatchResource.verticalFov()));
        desc.setViewSpaceToMetersFactor(0.0f);
        desc.setReset(false);
        desc.setFlags(0);
        try (GlState state = new GlState();){
            SRReturnCode sRReturnCode = SuperResolutionNativeAPI.srDispatchUpscale(this.context, desc);
        }
        return true;
    }

    @Override
    public void destroy() {
        this.destroyTexture();
        if (this.context != null && this.context.nativePtr > 0L) {
            SuperResolutionNativeAPI.srDestroyUpscaleContext(this.context);
        }
    }

    @Override
    public void resize(int width, int height) {
        this.updateFsr();
        this.destroyTexture();
        this.createTexture();
    }

    @Override
    public int getOutputTextureId() {
        return Math.toIntExact(this.outputColorGlTexture.handle());
    }

    @Override
    public IFrameBuffer getOutputFrameBuffer() {
        return this.outputColorFrameBuffer;
    }
}

