/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.none;

import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class None
extends AbstractAlgorithm {
    private static int cachedFrameBufferId = -1;
    private static OnlyNameFramebuffer cachedFrameBuffer;

    @Override
    public void init() {
    }

    @Override
    public boolean dispatch(DispatchResource dispatchResource) {
        if (cachedFrameBufferId < 0 || Gl.DSA.checkNamedFramebufferStatus(cachedFrameBufferId, 36160) != 36053) {
            cachedFrameBufferId = Gl.DSA.createFramebuffer();
        }
        Gl.DSA.framebufferTexture(cachedFrameBufferId, 36064, (int)dispatchResource.resources().colorTexture().handle(), 0);
        cachedFrameBuffer = new OnlyNameFramebuffer(cachedFrameBufferId, dispatchResource.resources().colorTexture());
        return true;
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void destroy() {
        if (cachedFrameBufferId > 0) {
            Gl.DSA.deleteFramebuffer(cachedFrameBufferId);
        }
    }

    @Override
    public int getOutputTextureId() {
        return cachedFrameBuffer.getTextureId(FrameBufferAttachmentType.Color);
    }

    @Override
    public IFrameBuffer getOutputFrameBuffer() {
        return cachedFrameBuffer;
    }

    private static class OnlyNameFramebuffer
    implements IBindableFrameBuffer {
        private final int fboId;
        private final ITexture colorTex;

        public OnlyNameFramebuffer(int fboId, ITexture colorTex) {
            this.fboId = fboId;
            this.colorTex = colorTex;
        }

        @Override
        public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
            int target = GlFrameBuffer.resolveBindTarget(bindPoint);
            GL30.glBindFramebuffer((int)target, (int)this.fboId);
            if (setViewport) {
                GL11.glViewport((int)0, (int)0, (int)this.colorTex.getWidth(), (int)this.colorTex.getHeight());
            }
        }

        @Override
        public void bind(FrameBufferBindPoint bindPoint) {
            this.bind(bindPoint, true);
        }

        @Override
        public void unbind(FrameBufferBindPoint bindPoint) {
            GL30.glBindFramebuffer((int)GlFrameBuffer.resolveBindTarget(bindPoint), (int)0);
        }

        @Override
        public int getWidth() {
            return this.colorTex.getWidth();
        }

        @Override
        public int getHeight() {
            return this.colorTex.getHeight();
        }

        @Override
        public void clearFrameBuffer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resizeFrameBuffer(int width, int height) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getTextureId(FrameBufferAttachmentType attachmentType) {
            if (attachmentType == FrameBufferAttachmentType.Color) {
                return Math.toIntExact(this.colorTex.handle());
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
            if (attachmentType == FrameBufferAttachmentType.Color) {
                return this.colorTex;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void setClearColorRGBA(float red, float green, float blue, float alpha) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TextureFormat getColorTextureFormat() {
            return this.colorTex.getTextureFormat();
        }

        @Override
        public TextureFormat getDepthTextureFormat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long handle() {
            return this.fboId;
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException();
        }
    }
}

