/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.sgsr.v2;

import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.api.InputResourceSet;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.config.enums.SgsrVariant;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.common.upscale.sgsr.v2.AbstractSgsrVariant;
import io.homo.superresolution.common.upscale.sgsr.v2.variants.Sgsr2PassCompute;
import io.homo.superresolution.common.upscale.sgsr.v2.variants.Sgsr2PassFragment;
import io.homo.superresolution.common.upscale.sgsr.v2.variants.Sgsr3PassCompute;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.buffer.BufferDescription;
import io.homo.superresolution.core.graphics.impl.buffer.BufferUsage;
import io.homo.superresolution.core.graphics.impl.buffer.StructuredUniformBuffer;
import io.homo.superresolution.core.graphics.impl.buffer.UniformStructBuilder;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.buffer.GlBuffer;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBufferAttachment;
import io.homo.superresolution.core.impl.Destroyable;
import java.util.function.Consumer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class Sgsr2
extends AbstractAlgorithm {
    private AbstractSgsrVariant variantInstance;
    private SgsrVariant currentVariant;
    private StructuredUniformBuffer paramsData;
    private GlBuffer paramsUbo;
    private GlFrameBuffer output;
    private int sameFrameNum = 0;

    @Override
    public void init() {
        this.output = new GlFrameBuffer();
        this.output.addAttachment(new GlFrameBufferAttachment(GlFrameBufferAttachment.FrameBufferAttachmentType.COLOR, RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getRenderWidth()).height(RenderHandlerManager.getRenderHeight()).usages(TextureUsages.create().sampler().storage().sampler()).format(SuperResolutionConfig.getInternalTextureFormat()).label("Sgsr2Output").build())));
        this.resize(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
        this.paramsData = UniformStructBuilder.start().vec2Entry("renderSize").vec2Entry("displaySize").vec2Entry("renderSizeRcp").vec2Entry("displaySizeRcp").vec2Entry("jitterOffset").mat4Entry("clipToPrevClip").floatEntry("preExposure").floatEntry("cameraFovAngleHor").floatEntry("cameraNear").floatEntry("minLerpContribution").uintEntry("bSameCamera").uintEntry("reset").build();
        this.paramsUbo = RenderSystems.current().device().createBuffer(BufferDescription.create().usage(BufferUsage.Ubo).size(this.paramsData.size()).build());
        this.paramsUbo.setBufferData(this.paramsData);
    }

    protected void updateParams(DispatchResource dispatchResource) {
        Matrix4f currentViewMatrix = new Matrix4f((Matrix4fc)dispatchResource.viewMatrix());
        Matrix4f currentProjectionMatrix = new Matrix4f((Matrix4fc)dispatchResource.projectionMatrix());
        Matrix4f currentViewProjectionMatrix = currentViewMatrix.mul((Matrix4fc)currentProjectionMatrix, new Matrix4f());
        Matrix4f previousViewMatrix = new Matrix4f((Matrix4fc)dispatchResource.lastViewMatrix());
        Matrix4f previousProjectionMatrix = new Matrix4f((Matrix4fc)dispatchResource.lastProjectionMatrix());
        Matrix4f previousViewProjectionMatrix = previousViewMatrix.mul((Matrix4fc)previousProjectionMatrix, new Matrix4f());
        Matrix4f invertViewMatrix = new Matrix4f((Matrix4fc)dispatchResource.viewMatrix()).invert();
        Matrix4f invertProjectionMatrix = new Matrix4f((Matrix4fc)dispatchResource.projectionMatrix()).invert();
        Matrix4f invertViewProjectionMatrix = invertViewMatrix.mul((Matrix4fc)invertProjectionMatrix, new Matrix4f());
        this.paramsData.setVec2("renderSize", dispatchResource.renderSize());
        this.paramsData.setVec2("displaySize", dispatchResource.screenSize());
        this.paramsData.setVec2("renderSizeRcp", new Vector2f().set(1.0f).div((Vector2fc)dispatchResource.renderSize()));
        this.paramsData.setVec2("displaySizeRcp", new Vector2f().set(1.0f).div((Vector2fc)dispatchResource.screenSize()));
        this.paramsData.setVec2("jitterOffset", this.getOriginJitterOffset(dispatchResource.frameCount(), dispatchResource.renderSize(), dispatchResource.screenSize()));
        Matrix4f clipToPrevClipMat = previousViewProjectionMatrix.mul((Matrix4fc)invertViewProjectionMatrix, new Matrix4f());
        this.paramsData.setMat4("clipToPrevClip", clipToPrevClipMat);
        this.paramsData.setFloat("preExposure", 1.0f);
        this.paramsData.setFloat("cameraFovAngleHor", dispatchResource.horizontalFov());
        this.paramsData.setFloat("cameraNear", dispatchResource.cameraNear());
        boolean isCameraStill = Sgsr2.isCameraStill(currentViewProjectionMatrix, previousViewProjectionMatrix, 1.0E-5f);
        double minLerpContribution = 0.0;
        if (isCameraStill) {
            ++this.sameFrameNum;
            if (this.sameFrameNum > 5) {
                minLerpContribution = 0.3;
            }
            if (this.sameFrameNum == 65535) {
                this.sameFrameNum = 1;
            }
        } else {
            this.sameFrameNum = 0;
        }
        this.paramsData.setFloat("minLerpContribution", (float)minLerpContribution);
        this.paramsData.setUint("bSameCamera", isCameraStill ? 1 : 0);
        this.paramsData.setUint("reset", 0);
        this.paramsData.fillBuffer();
        this.paramsUbo.upload();
    }

    private static boolean isCameraStill(Matrix4f currentMVP, Matrix4f prevMVP, float threshold) {
        float diff = 0.0f;
        for (int r = 0; r < 4; ++r) {
            for (int c = 0; c < 4; ++c) {
                diff += Math.abs(currentMVP.get(r, c) - prevMVP.get(r, c));
            }
        }
        return diff < threshold;
    }

    @Override
    public boolean dispatch(DispatchResource dispatchResource) {
        super.dispatch(dispatchResource);
        this.initVariant();
        this.updateParams(dispatchResource);
        this.variantInstance.setOutput(this.output);
        this.variantInstance.dispatch(dispatchResource, this);
        return false;
    }

    @Override
    public Vector2f getJitterOffset(int frameCount, Vector2f renderSize, Vector2f screenSize) {
        Vector2f originJitter = this.getOriginJitterOffset(frameCount, renderSize, screenSize);
        return new Vector2f(originJitter.x, originJitter.y);
    }

    private Vector2f getOriginJitterOffset(int frameCount, Vector2f renderSize, Vector2f screenSize) {
        return new Vector2f(0.0f);
    }

    @Override
    public void destroy() {
        this.safeVariantInstance(Destroyable::destroy);
        this.paramsData.free();
        this.paramsUbo.destroy();
    }

    @Override
    public void resize(int width, int height) {
        this.safeVariantInstance(sgsrVariant -> sgsrVariant.resize(width, height));
        this.output.resizeFrameBuffer(width, height);
    }

    @Override
    public IFrameBuffer getOutputFrameBuffer() {
        return this.output;
    }

    private void initVariant() {
        if (this.checkVariant()) {
            if (this.variantInstance != null) {
                this.variantInstance.destroy();
            }
            this.variantInstance = switch ((SgsrVariant)((Object)SuperResolutionConfig.SPECIAL.SGSR2.VARIANT.get())) {
                default -> throw new IncompatibleClassChangeError();
                case SgsrVariant.CS_2 -> new Sgsr2PassCompute();
                case SgsrVariant.CS_3 -> new Sgsr3PassCompute();
                case SgsrVariant.FS_2 -> new Sgsr2PassFragment();
            };
            this.variantInstance.init(this);
        }
    }

    private boolean checkVariant() {
        if (this.variantInstance == null) {
            return true;
        }
        if (SuperResolutionConfig.SPECIAL.SGSR2.VARIANT.get() != this.currentVariant) {
            this.currentVariant = (SgsrVariant)((Object)SuperResolutionConfig.SPECIAL.SGSR2.VARIANT.get());
            return true;
        }
        return false;
    }

    private void safeVariantInstance(Consumer<AbstractSgsrVariant> callback) {
        if (this.variantInstance != null) {
            callback.accept(this.variantInstance);
        }
    }

    public GlBuffer getParams() {
        return this.paramsUbo;
    }

    public InputResourceSet getInputResourceSet() {
        return this.resources;
    }
}

