/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics;

import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.GpuVendor;
import io.homo.superresolution.core.impl.Pair;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL43;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VK11;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsCapabilities {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution-GraphicsCapabilities");
    private static final ArrayList<Pair<Integer, Integer>> glVersions = new ArrayList();
    private static Set<String> glExtensions = null;
    private static GpuVendor gpuVendor = null;
    private static int[] glVersion = new int[]{-1, -1};

    public static void init() {
    }

    public static GpuVendor detectGpuVendor() {
        if (gpuVendor == null) {
            String renderer = GL43.glGetString((int)7937);
            String vendor = GL43.glGetString((int)7936);
            gpuVendor = GraphicsCapabilities.parseVendorFromName(vendor + " " + renderer);
        }
        return gpuVendor;
    }

    private static GpuVendor parseVendorFromName(String rawName) {
        if (rawName == null) {
            return GpuVendor.Unknown;
        }
        String lowerName = rawName.toLowerCase();
        if (lowerName.contains("nvidia") || lowerName.contains("geforce")) {
            return GpuVendor.Nvidia;
        }
        if (lowerName.contains("amd") || lowerName.contains("radeon") || lowerName.contains("ati ")) {
            return GpuVendor.Amd;
        }
        if (lowerName.contains("intel") || lowerName.contains("iris") || lowerName.contains("hd graphics")) {
            return GpuVendor.Intel;
        }
        return GpuVendor.Unknown;
    }

    private static int[] detectGLVersion() {
        if (glVersion[0] != -1 && glVersion[1] != -1) {
            return glVersion;
        }
        int major = GL43.glGetInteger((int)33307);
        int minor = GL43.glGetInteger((int)33308);
        GraphicsCapabilities.glVersion[0] = major;
        GraphicsCapabilities.glVersion[1] = minor;
        return glVersion;
    }

    public static void detectSupportedVersions() {
        int[][] versionMatrix;
        glVersions.clear();
        for (int[] version : versionMatrix = new int[][]{{4, 6}, {4, 5}, {4, 3}, {4, 2}, {4, 1}}) {
            int major = version[0];
            int minor = version[1];
            GLFW.glfwDefaultWindowHints();
            GLFW.glfwWindowHint((int)131076, (int)0);
            GLFW.glfwWindowHint((int)139266, (int)major);
            GLFW.glfwWindowHint((int)139267, (int)minor);
            long testWindow = GLFW.glfwCreateWindow((int)1, (int)1, (CharSequence)"", (long)0L, (long)0L);
            if (testWindow == 0L) continue;
            GLFW.glfwMakeContextCurrent((long)testWindow);
            int actualMajor = GLFW.glfwGetWindowAttrib((long)testWindow, (int)139266);
            int actualMinor = GLFW.glfwGetWindowAttrib((long)testWindow, (int)139267);
            glVersions.add(Pair.of(actualMajor, actualMinor));
            GLFW.glfwDestroyWindow((long)testWindow);
            LOGGER.info("\u6dfb\u52a0\u53ef\u7528OpenGL\u7248\u672c {}.{}", (Object)actualMajor, (Object)actualMinor);
        }
        LOGGER.info("\u6700\u9ad8OpenGL\u7248\u672c {}.{}", (Object)GraphicsCapabilities.getHighestOpenGLVersion().left(), (Object)GraphicsCapabilities.getHighestOpenGLVersion().right());
    }

    public static Pair<Integer, Integer> getHighestOpenGLVersion() {
        return glVersions.stream().max(Comparator.comparingInt(p -> (Integer)p.left()).thenComparingInt(Pair::right)).orElse(null);
    }

    private static Set<String> detectGLExtensions() {
        int count = GL43.glGetInteger((int)33309);
        return Collections.unmodifiableSet(IntStream.range(0, count).mapToObj(i -> GL43.glGetStringi((int)7939, (int)i)).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
    }

    private static int[] detectVulkanVersion() {
        if (!GraphicsCapabilities.isVulkanSupported()) {
            return new int[]{0, 0, 0};
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer version = stack.mallocInt(1);
            VK11.vkEnumerateInstanceVersion((IntBuffer)version);
            int[] nArray = new int[]{VK10.VK_API_VERSION_MAJOR((int)version.get(0)), VK10.VK_API_VERSION_MINOR((int)version.get(0)), VK10.VK_API_VERSION_PATCH((int)version.get(0))};
            return nArray;
        }
    }

    private static boolean isVulkanSupported() {
        return RenderSystems.isSupportVulkan();
    }

    public static int[] getGLVersion() {
        return GraphicsCapabilities.detectGLVersion();
    }

    public static String getGLVersionString() {
        int[] glVersion = GraphicsCapabilities.detectGLVersion();
        return glVersion[0] + "." + glVersion[1];
    }

    public static Set<String> getGLExtensions() {
        if (glExtensions == null) {
            glExtensions = Collections.unmodifiableSet(GraphicsCapabilities.detectGLExtensions());
        }
        return glExtensions;
    }

    public static boolean hasGLExtension(String name) {
        if (glExtensions == null) {
            glExtensions = Collections.unmodifiableSet(GraphicsCapabilities.detectGLExtensions());
        }
        return glExtensions.contains(name);
    }

    public static int[] getVulkanVersion() {
        return GraphicsCapabilities.detectVulkanVersion();
    }

    public static String getVulkanVersionString() {
        if (!GraphicsCapabilities.isVulkanSupported()) {
            return "0.0.0";
        }
        int[] vkVersion = GraphicsCapabilities.detectVulkanVersion();
        return vkVersion[0] + "." + vkVersion[1] + "." + vkVersion[2];
    }

    public static boolean hasVulkanDeviceExtension(String name) {
        if (GraphicsCapabilities.isVulkanSupported()) {
            return RenderSystems.vulkan().getCapabilities().getDeviceExtensions().contains(name);
        }
        return false;
    }

    public static Set<String> getVulkanDeviceExtensions() {
        if (GraphicsCapabilities.isVulkanSupported()) {
            return Set.copyOf(RenderSystems.vulkan().getCapabilities().getDeviceExtensions().stream().collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        }
        return new HashSet<String>();
    }
}

