/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.buffer;

import io.homo.superresolution.core.graphics.impl.buffer.IBufferData;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.lwjgl.system.MemoryUtil;

public class StaticBufferData
implements IBufferData {
    private final Buffer buffer;
    private final long size;
    private final boolean owned;

    private StaticBufferData(Buffer buffer, long size, boolean owned) {
        this.buffer = buffer;
        this.size = size;
        this.owned = owned;
    }

    public static StaticBufferData create(long size) {
        if (size <= 0L) {
            throw new IllegalArgumentException("Size must be positive");
        }
        ByteBuffer buffer = MemoryUtil.memCalloc((int)1, (int)((int)size));
        return new StaticBufferData(buffer, size, true);
    }

    public static StaticBufferData copy(Buffer buffer) {
        Objects.requireNonNull(buffer, "Buffer cannot be null");
        if (buffer.limit() <= 0) {
            throw new IllegalArgumentException("Buffer must have positive size");
        }
        long size = buffer.limit();
        ByteBuffer internalBuffer = MemoryUtil.memCalloc((int)1, (int)((int)size));
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((Buffer)buffer), (long)MemoryUtil.memAddress((Buffer)internalBuffer), (long)size);
        return new StaticBufferData(internalBuffer, size, true);
    }

    public static StaticBufferData wrap(long address, long size) {
        if (address == 0L) {
            throw new IllegalArgumentException("Address cannot be zero");
        }
        if (size <= 0L) {
            throw new IllegalArgumentException("Size must be positive");
        }
        ByteBuffer buffer = MemoryUtil.memByteBuffer((long)address, (int)((int)size));
        return new StaticBufferData(buffer, size, false);
    }

    public static StaticBufferData wrap(Buffer buffer) {
        Objects.requireNonNull(buffer, "Buffer cannot be null");
        if (buffer.limit() <= 0) {
            throw new IllegalArgumentException("Buffer must have positive size");
        }
        return new StaticBufferData(buffer, buffer.limit(), false);
    }

    @Override
    public Buffer container() {
        return this.buffer;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void free() {
        if (this.owned) {
            MemoryUtil.memFree((Buffer)this.buffer);
        }
    }

    @Override
    public void put(byte[] src, long offset) {
        throw new UnsupportedOperationException("Static buffer does not support modification");
    }

    @Override
    public void updatePartial(Buffer data, long offset, long length) {
        throw new UnsupportedOperationException("Static buffer does not support modification");
    }

    @Override
    public void update(Buffer data) {
        throw new UnsupportedOperationException("Static buffer does not support modification");
    }
}

