/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.pipeline;

import io.homo.superresolution.core.graphics.impl.DrawObject;
import io.homo.superresolution.core.graphics.impl.command.ICommandBuffer;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.GpuComputeJob;
import io.homo.superresolution.core.graphics.impl.pipeline.IPipelineJob;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import java.util.Objects;

public class PipelineGraphicsJob
extends GpuComputeJob<PipelineGraphicsJob>
implements IPipelineJob {
    protected final float[] viewport = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};
    protected IFrameBuffer frameBuffer;
    protected IShaderProgram<?> program = null;

    public PipelineGraphicsJob viewport(float x, float y, float width, float height) {
        this.viewport[0] = x;
        this.viewport[1] = y;
        this.viewport[2] = width;
        this.viewport[3] = height;
        return this;
    }

    public PipelineGraphicsJob targetFrameBuffer(IFrameBuffer frameBuffer) {
        this.frameBuffer = Objects.requireNonNull(frameBuffer, "\u5e27\u7f13\u51b2\u533a\u4e0d\u80fd\u4e3anull");
        return this;
    }

    public PipelineGraphicsJob graphicsProgram(IShaderProgram<?> program) {
        this.program = Objects.requireNonNull(program, "\u56fe\u5f62\u7740\u8272\u5668\u4e0d\u80fd\u4e3anull");
        return this;
    }

    @Override
    public void execute(ICommandBuffer commandBuffer) {
        Objects.requireNonNull(this.program, "\u56fe\u5f62\u7740\u8272\u5668\u672a\u8bbe\u7f6e");
        Objects.requireNonNull(this.frameBuffer, "\u5e27\u7f13\u51b2\u533a\u672a\u8bbe\u7f6e");
        this.setupProgramResources(this.program);
        float[] lastViewport = commandBuffer.getEncoder().renderState().viewport();
        if (this.isViewportValid()) {
            commandBuffer.getEncoder().renderState().viewport(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3]);
        }
        commandBuffer.getEncoder().draw(commandBuffer, this.program, this.frameBuffer, DrawObject.fullscreenQuad(commandBuffer.getDevice()).once(), 0, DrawObject.fullscreenQuadVertexCount());
        commandBuffer.getEncoder().renderState().viewport(lastViewport[0], lastViewport[1], lastViewport[2], lastViewport[3]);
    }

    private boolean isViewportValid() {
        return this.viewport[0] >= 0.0f && this.viewport[1] >= 0.0f && this.viewport[2] > 0.0f && this.viewport[3] > 0.0f;
    }

    @Override
    public void destroy() {
        this.program = null;
        this.frameBuffer = null;
    }
}

