/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.shader;

import io.homo.superresolution.api.platform.Platform;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.shader.ShaderCompiler;
import io.homo.superresolution.core.utils.FileReadHelper;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;

public class ShaderSource {
    private final ShaderType type;
    private final String source;
    private final boolean isFilePath;
    private final Map<String, String> shaderDefines = new HashMap<String, String>();
    private String cachedSource = null;

    public ShaderSource(ShaderType type, String content, boolean isFilePath) {
        this.type = type;
        this.source = content;
        this.isFilePath = isFilePath;
    }

    public static ShaderSource text(ShaderType type, String content) {
        return new ShaderSource(type, content, false);
    }

    public static ShaderSource file(ShaderType type, String path) {
        return new ShaderSource(type, path, true);
    }

    public static String addCustomDefines(String source, Map<String, String> defines) {
        if (Gl.isLegacy()) {
            ShaderCompiler.LOGGER.debug("\u6dfb\u52a0SR_GL41_COMPAT\u5b9a\u4e49");
            defines.put("SR_GL41_COMPAT", "1");
        }
        if (defines.isEmpty()) {
            return source;
        }
        StringBuilder definesBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : defines.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            definesBuilder.append("#define ").append(key);
            if (value != null && !value.isEmpty()) {
                definesBuilder.append(" ").append(value);
            }
            definesBuilder.append("\n");
        }
        String defineBlock = definesBuilder.toString().trim();
        String[] lines = source.split("\\R");
        ArrayList<String> linesList = new ArrayList<String>(Arrays.asList(lines));
        int versionLine = -1;
        for (int i = 0; i < linesList.size(); ++i) {
            if (!((String)linesList.get(i)).trim().startsWith("#version")) continue;
            versionLine = i;
            break;
        }
        if (versionLine == -1) {
            throw new IllegalArgumentException("Shader source must contain #version directive");
        }
        if (!defineBlock.isEmpty()) {
            String[] defineLines = defineBlock.split("\\R");
            for (int i = 0; i < defineLines.length; ++i) {
                linesList.add(versionLine + 1 + i, defineLines[i]);
            }
        }
        String lineSeparator = source.contains("\r\n") ? "\r\n" : "\n";
        return String.join((CharSequence)lineSeparator, linesList);
    }

    public Map<String, String> getShaderDefines() {
        return this.shaderDefines;
    }

    public ShaderSource addDefine(String key, String value) {
        this.shaderDefines.put(key, value);
        return this;
    }

    public ShaderSource addDefines(Map<String, String> map) {
        this.shaderDefines.putAll(map);
        return this;
    }

    public ShaderType getType() {
        return this.type;
    }

    public void updateSource() {
        String shaderSource = this.source;
        if (this.isFilePath) {
            if (!Platform.currentPlatform.isDevelopmentEnvironment()) {
                shaderSource = String.join((CharSequence)"\n", FileReadHelper.readText(this.source));
            }
            Path commonProjectPath = Path.of(Minecraft.m_91087_().f_91069_.getAbsolutePath(), new String[0]).getParent().getParent().resolve("common").resolve("src").resolve("main").resolve("resources");
            Path shaderPath = Path.of(commonProjectPath.toAbsolutePath().toString(), this.source);
            if (shaderPath.toFile().exists()) {
                try {
                    shaderSource = Files.readString(shaderPath);
                    SuperResolution.LOGGER.info("\u52a0\u8f7dShader {}", (Object)shaderPath);
                }
                catch (Throwable e) {
                    shaderSource = String.join((CharSequence)"\n", FileReadHelper.readText(this.source));
                }
            } else {
                shaderSource = String.join((CharSequence)"\n", FileReadHelper.readText(this.source));
            }
        }
        this.cachedSource = ShaderSource.addCustomDefines(shaderSource, this.shaderDefines);
    }

    public String getSource() {
        if (this.cachedSource == null) {
            this.updateSource();
        }
        return this.cachedSource;
    }

    public boolean isFilePath() {
        return this.isFilePath;
    }
}

