/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl;

import io.homo.superresolution.common.config.SuperResolutionConfig;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.KHRDebug;

public class GlDebug {
    public static final int DEBUG_GROUP_COMMANDBUFFER_ID_BEGIN = 983040;
    public static final int DEBUG_GROUP_DRAW_ID_BEGIN = 0x1E0000;
    public static final int DEBUG_GROUP_COMPUTE_ID_BEGIN = 0x2D0000;
    public static final int DEBUG_GROUP_COPY_ID_BEGIN = 0x3C0000;
    public static final int DEBUG_GROUP_CLEAR_ID_BEGIN = 0x4B0000;
    public static final int DEBUG_GROUP_STATE_ID_BEGIN = 0x5A0000;
    private static final AtomicInteger commandBufferIdCounter = new AtomicInteger(983040);
    private static final AtomicInteger drawIdCounter = new AtomicInteger(0x1E0000);
    private static final AtomicInteger computeIdCounter = new AtomicInteger(0x2D0000);
    private static final AtomicInteger copyIdCounter = new AtomicInteger(0x3C0000);
    private static final AtomicInteger clearIdCounter = new AtomicInteger(0x4B0000);
    private static final AtomicInteger stateIdCounter = new AtomicInteger(0x5A0000);

    public static void popGroup() {
        if (!SuperResolutionConfig.isEnableDebug()) {
            return;
        }
        if (GL.getCapabilities().GL_KHR_debug) {
            KHRDebug.glPopDebugGroup();
        }
    }

    public static void pushGroup(int id, String name) {
        if (!SuperResolutionConfig.isEnableDebug()) {
            return;
        }
        if (GL.getCapabilities().GL_KHR_debug) {
            KHRDebug.glPushDebugGroup((int)33354, (int)id, (CharSequence)StringUtils.abbreviate((String)name, (int)255));
        }
    }

    public static void objectLabel(int type, int id, String label) {
        if (!SuperResolutionConfig.isEnableDebug()) {
            return;
        }
        if (GL.getCapabilities().GL_KHR_debug) {
            KHRDebug.glObjectLabel((int)type, (int)id, (CharSequence)StringUtils.abbreviate((String)label, (int)255));
        }
    }

    public static int nextCommandBufferId() {
        if (!SuperResolutionConfig.isEnableDebug()) {
            return 0;
        }
        return commandBufferIdCounter.getAndIncrement();
    }

    public static int nextDrawId() {
        if (!SuperResolutionConfig.isEnableDebug()) {
            return 0;
        }
        return drawIdCounter.getAndIncrement();
    }

    public static int nextComputeId() {
        if (!SuperResolutionConfig.isEnableDebug()) {
            return 0;
        }
        return computeIdCounter.getAndIncrement();
    }

    public static int nextClearId() {
        if (!SuperResolutionConfig.isEnableDebug()) {
            return 0;
        }
        return clearIdCounter.getAndIncrement();
    }

    public static int nextCopyId() {
        if (!SuperResolutionConfig.isEnableDebug()) {
            return 0;
        }
        return copyIdCounter.getAndIncrement();
    }

    public static int nextStateId() {
        if (!SuperResolutionConfig.isEnableDebug()) {
            return 0;
        }
        return stateIdCounter.getAndIncrement();
    }
}

