/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl;

import io.homo.superresolution.core.graphics.opengl.GlDebug;
import org.lwjgl.opengl.GL45;

public class GlState
implements AutoCloseable {
    public static final long STATE_PROGRAM = 1L;
    public static final long STATE_VAO = 2L;
    public static final long STATE_VBO = 4L;
    public static final long STATE_EBO = 8L;
    public static final long STATE_READ_FBO = 16L;
    public static final long STATE_DRAW_FBO = 32L;
    public static final long STATE_TEXTURE = 64L;
    public static final long STATE_ACTIVE_TEXTURE = 128L;
    public static final long STATE_TEXTURES = 256L;
    public static final long STATE_VIEWPORT = 512L;
    public static final long STATE_BLEND_FUNC = 1024L;
    public static final long STATE_BLEND_ENABLE = 2048L;
    public static final long STATE_CULL_FACE_ENABLE = 4096L;
    public static final long STATE_CULL_FACE_MODE = 8192L;
    public static final long STATE_FRONT_FACE = 16384L;
    public static final long STATE_DEPTH_TEST = 32768L;
    public static final long STATE_SCISSOR_TEST = 65536L;
    public static final long STATE_COLOR_MASK = 131072L;
    public static final long STATE_STENCIL_FUNC = 262144L;
    public static final long STATE_STENCIL_OP = 524288L;
    public static final long STATE_STENCIL_MASK = 0x100000L;
    public static final long STATE_UNIFORM_BUFFER = 0x200000L;
    public static final long STATE_UNPACK = 0x400000L;
    public static final long STATE_VERTEX_ATTRIB_ARRAY = 0x800000L;
    public static final long STATE_VERTEX_BINDING_DIVISOR = 0x1000000L;
    public static final long STATE_COPY_READ_BUFFER = 0x2000000L;
    public static final long STATE_COPY_WRITE_BUFFER = 0x4000000L;
    public static final long STATE_PIXEL_PACK_BUFFER = 0x8000000L;
    public static final long STATE_PIXEL_UNPACK_BUFFER = 0x10000000L;
    public static final long STATE_TRANSFORM_FEEDBACK_BUFFER = 0x20000000L;
    public static final long STATE_ATOMIC_COUNTER_BUFFER = 0x40000000L;
    public static final long STATE_DISPATCH_INDIRECT_BUFFER = 0x80000000L;
    public static final long STATE_DRAW_INDIRECT_BUFFER = 0x100000000L;
    public static final long STATE_SHADER_STORAGE_BUFFER = 0x200000000L;
    public static final long STATE_ALL = -1L;
    public static final long STATE_VERTEX_OPERATIONS = 0x1800000L;
    public static final long STATE_BUFFER_OPERATIONS = 17146314752L;
    private static final long DEFAULT_MASK = -1L;
    private static final int MAX_TEXTURES = 16;
    private final long stateMask;
    public int program;
    public int vao;
    public int vbo;
    public int ebo;
    public int wFbo;
    public int rFbo;
    public int texture2D;
    public int texture1D;
    public int activeTextureNumber;
    public int[] textures2D;
    public int[] textures1D;
    public int[] view;
    public int blendSrcRGB;
    public int blendDstRGB;
    public int blendSrcAlpha;
    public int blendDstAlpha;
    public boolean blendEnabled;
    public boolean cullFaceEnabled;
    public int cullFaceMode;
    public int frontFace;
    public boolean depthTestEnabled;
    public boolean scissorTestEnabled;
    public boolean[] colorMask;
    public int stencilFunc;
    public int stencilRef;
    public int stencilValueMask;
    public int stencilMask;
    public int stencilOpFail;
    public int stencilOpZFail;
    public int stencilOpZPass;
    public int uniformBufferBinding;
    public int unpackAlignment;
    public int unpackRowLength;
    public int unpackSkipPixels;
    public int unpackSkipRows;
    public int copyReadBuffer;
    public int copyWriteBuffer;
    public int pixelPackBuffer;
    public int pixelUnpackBuffer;
    public int transformFeedbackBuffer;
    public int atomicCounterBuffer;
    public int dispatchIndirectBuffer;
    public int drawIndirectBuffer;
    public int shaderStorageBuffer;

    public GlState() {
        this(-1L);
    }

    public GlState(long stateMask) {
        this.stateMask = stateMask;
        GlDebug.pushGroup(GlDebug.nextStateId(), "GlSaveState");
        this.saveState();
        GlDebug.popGroup();
    }

    public void saveState() {
        int originalActiveTexture = GL45.glGetInteger((int)34016);
        if ((this.stateMask & 1L) != 0L) {
            this.program = GL45.glGetInteger((int)35725);
        }
        if ((this.stateMask & 2L) != 0L) {
            this.vao = GL45.glGetInteger((int)34229);
        }
        if ((this.stateMask & 4L) != 0L) {
            this.vbo = GL45.glGetInteger((int)34964);
        }
        if ((this.stateMask & 8L) != 0L) {
            this.ebo = GL45.glGetInteger((int)34965);
        }
        if ((this.stateMask & 0x10L) != 0L) {
            this.rFbo = GL45.glGetInteger((int)36010);
        }
        if ((this.stateMask & 0x20L) != 0L) {
            this.wFbo = GL45.glGetInteger((int)36006);
        }
        if ((this.stateMask & 0x100L) != 0L) {
            this.textures2D = new int[16];
            this.textures1D = new int[16];
            for (int i = 0; i < 16; ++i) {
                GL45.glActiveTexture((int)(33984 + i));
                this.textures2D[i] = GL45.glGetInteger((int)32873);
                this.textures1D[i] = GL45.glGetInteger((int)32872);
            }
            GL45.glActiveTexture((int)originalActiveTexture);
        }
        if ((this.stateMask & 0x80L) != 0L) {
            this.activeTextureNumber = originalActiveTexture;
        }
        if ((this.stateMask & 0x40L) != 0L) {
            this.texture2D = GL45.glGetInteger((int)32873);
            this.texture1D = GL45.glGetInteger((int)32872);
        }
        if ((this.stateMask & 0x200L) != 0L) {
            this.view = new int[4];
            GL45.glGetIntegerv((int)2978, (int[])this.view);
        }
        if ((this.stateMask & 0x400L) != 0L) {
            this.blendSrcRGB = GL45.glGetInteger((int)32969);
            this.blendDstRGB = GL45.glGetInteger((int)32968);
            this.blendSrcAlpha = GL45.glGetInteger((int)32971);
            this.blendDstAlpha = GL45.glGetInteger((int)32970);
        }
        if ((this.stateMask & 0x800L) != 0L) {
            this.blendEnabled = GL45.glIsEnabled((int)3042);
        }
        if ((this.stateMask & 0x1000L) != 0L) {
            this.cullFaceEnabled = GL45.glIsEnabled((int)2884);
        }
        if ((this.stateMask & 0x2000L) != 0L) {
            this.cullFaceMode = GL45.glGetInteger((int)2885);
        }
        if ((this.stateMask & 0x4000L) != 0L) {
            this.frontFace = GL45.glGetInteger((int)2886);
        }
        if ((this.stateMask & 0x8000L) != 0L) {
            this.depthTestEnabled = GL45.glIsEnabled((int)2929);
        }
        if ((this.stateMask & 0x10000L) != 0L) {
            this.scissorTestEnabled = GL45.glIsEnabled((int)3089);
        }
        if ((this.stateMask & 0x20000L) != 0L) {
            int[] colorMaskArray = new int[4];
            GL45.glGetIntegerv((int)3107, (int[])colorMaskArray);
            this.colorMask = new boolean[4];
            for (int i = 0; i < 4; ++i) {
                this.colorMask[i] = colorMaskArray[i] != 0;
            }
        }
        if ((this.stateMask & 0x40000L) != 0L) {
            this.stencilFunc = GL45.glGetInteger((int)2962);
            this.stencilRef = GL45.glGetInteger((int)2967);
            this.stencilValueMask = GL45.glGetInteger((int)2963);
        }
        if ((this.stateMask & 0x80000L) != 0L) {
            this.stencilOpFail = GL45.glGetInteger((int)2964);
            this.stencilOpZFail = GL45.glGetInteger((int)2965);
            this.stencilOpZPass = GL45.glGetInteger((int)2966);
        }
        if ((this.stateMask & 0x100000L) != 0L) {
            this.stencilMask = GL45.glGetInteger((int)2968);
        }
        if ((this.stateMask & 0x200000L) != 0L) {
            this.uniformBufferBinding = GL45.glGetInteger((int)35368);
        }
        if ((this.stateMask & 0x400000L) != 0L) {
            this.unpackAlignment = GL45.glGetInteger((int)3317);
            this.unpackRowLength = GL45.glGetInteger((int)3314);
            this.unpackSkipPixels = GL45.glGetInteger((int)3316);
            this.unpackSkipRows = GL45.glGetInteger((int)3315);
        }
        if ((this.stateMask & 0x2000000L) != 0L) {
            this.copyReadBuffer = GL45.glGetInteger((int)36662);
        }
        if ((this.stateMask & 0x4000000L) != 0L) {
            this.copyWriteBuffer = GL45.glGetInteger((int)36663);
        }
        if ((this.stateMask & 0x8000000L) != 0L) {
            this.pixelPackBuffer = GL45.glGetInteger((int)35053);
        }
        if ((this.stateMask & 0x10000000L) != 0L) {
            this.pixelUnpackBuffer = GL45.glGetInteger((int)35055);
        }
        if ((this.stateMask & 0x20000000L) != 0L) {
            this.transformFeedbackBuffer = GL45.glGetInteger((int)35983);
        }
        if ((this.stateMask & 0x40000000L) != 0L) {
            this.atomicCounterBuffer = GL45.glGetInteger((int)37569);
        }
        if ((this.stateMask & 0x80000000L) != 0L) {
            this.dispatchIndirectBuffer = GL45.glGetInteger((int)37103);
        }
        if ((this.stateMask & 0x100000000L) != 0L) {
            this.drawIndirectBuffer = GL45.glGetInteger((int)36675);
        }
        if ((this.stateMask & 0x200000000L) != 0L) {
            this.shaderStorageBuffer = GL45.glGetInteger((int)37075);
        }
    }

    public void restore() {
        GlDebug.pushGroup(GlDebug.nextStateId(), "GlRestoreState");
        if ((this.stateMask & 0x20L) != 0L) {
            GL45.glBindFramebuffer((int)36009, (int)this.wFbo);
        }
        if ((this.stateMask & 0x10L) != 0L) {
            GL45.glBindFramebuffer((int)36008, (int)this.rFbo);
        }
        if ((this.stateMask & 0x100L) != 0L && this.textures2D != null && this.textures1D != null) {
            for (int i = 0; i < 16; ++i) {
                GL45.glActiveTexture((int)(33984 + i));
                if (this.textures2D[i] != 0) {
                    GL45.glBindTexture((int)3553, (int)this.textures2D[i]);
                }
                if (this.textures1D[i] == 0) continue;
                GL45.glBindTexture((int)3552, (int)this.textures1D[i]);
            }
        }
        if ((this.stateMask & 0x80L) != 0L) {
            GL45.glActiveTexture((int)this.activeTextureNumber);
        }
        if ((this.stateMask & 0x40L) != 0L) {
            GL45.glBindTexture((int)3553, (int)this.texture2D);
            GL45.glBindTexture((int)3552, (int)this.texture1D);
        }
        if ((this.stateMask & 2L) != 0L) {
            GL45.glBindVertexArray((int)this.vao);
        }
        if ((this.stateMask & 4L) != 0L) {
            GL45.glBindBuffer((int)34962, (int)this.vbo);
        }
        if ((this.stateMask & 8L) != 0L) {
            GL45.glBindBuffer((int)34963, (int)this.ebo);
        }
        if ((this.stateMask & 1L) != 0L) {
            GL45.glUseProgram((int)this.program);
        }
        if ((this.stateMask & 0x200L) != 0L && this.view != null) {
            GL45.glViewport((int)this.view[0], (int)this.view[1], (int)this.view[2], (int)this.view[3]);
        }
        if ((this.stateMask & 0x400L) != 0L) {
            GL45.glBlendFuncSeparate((int)this.blendSrcRGB, (int)this.blendDstRGB, (int)this.blendSrcAlpha, (int)this.blendDstAlpha);
        }
        if ((this.stateMask & 0x800L) != 0L) {
            this.setGlCap(3042, this.blendEnabled);
        }
        if ((this.stateMask & 0x1000L) != 0L) {
            this.setGlCap(2884, this.cullFaceEnabled);
        }
        if ((this.stateMask & 0x2000L) != 0L) {
            GL45.glCullFace((int)this.cullFaceMode);
        }
        if ((this.stateMask & 0x4000L) != 0L) {
            GL45.glFrontFace((int)this.frontFace);
        }
        if ((this.stateMask & 0x8000L) != 0L) {
            this.setGlCap(2929, this.depthTestEnabled);
        }
        if ((this.stateMask & 0x10000L) != 0L) {
            this.setGlCap(3089, this.scissorTestEnabled);
        }
        if ((this.stateMask & 0x20000L) != 0L && this.colorMask != null) {
            GL45.glColorMask((boolean)this.colorMask[0], (boolean)this.colorMask[1], (boolean)this.colorMask[2], (boolean)this.colorMask[3]);
        }
        if ((this.stateMask & 0x40000L) != 0L) {
            GL45.glStencilFunc((int)this.stencilFunc, (int)this.stencilRef, (int)this.stencilValueMask);
        }
        if ((this.stateMask & 0x100000L) != 0L) {
            GL45.glStencilMask((int)this.stencilMask);
        }
        if ((this.stateMask & 0x80000L) != 0L) {
            GL45.glStencilOp((int)this.stencilOpFail, (int)this.stencilOpZFail, (int)this.stencilOpZPass);
        }
        if ((this.stateMask & 0x200000L) != 0L) {
            GL45.glBindBuffer((int)35345, (int)this.uniformBufferBinding);
        }
        if ((this.stateMask & 0x400000L) != 0L) {
            GL45.glPixelStorei((int)3317, (int)this.unpackAlignment);
            GL45.glPixelStorei((int)3314, (int)this.unpackRowLength);
            GL45.glPixelStorei((int)3316, (int)this.unpackSkipPixels);
            GL45.glPixelStorei((int)3315, (int)this.unpackSkipRows);
        }
        if ((this.stateMask & 0x2000000L) != 0L) {
            GL45.glBindBuffer((int)36662, (int)this.copyReadBuffer);
        }
        if ((this.stateMask & 0x4000000L) != 0L) {
            GL45.glBindBuffer((int)36663, (int)this.copyWriteBuffer);
        }
        if ((this.stateMask & 0x8000000L) != 0L) {
            GL45.glBindBuffer((int)35051, (int)this.pixelPackBuffer);
        }
        if ((this.stateMask & 0x10000000L) != 0L) {
            GL45.glBindBuffer((int)35052, (int)this.pixelUnpackBuffer);
        }
        if ((this.stateMask & 0x20000000L) != 0L) {
            GL45.glBindBuffer((int)35982, (int)this.transformFeedbackBuffer);
        }
        if ((this.stateMask & 0x40000000L) != 0L) {
            GL45.glBindBuffer((int)37568, (int)this.atomicCounterBuffer);
        }
        if ((this.stateMask & 0x80000000L) != 0L) {
            GL45.glBindBuffer((int)37102, (int)this.dispatchIndirectBuffer);
        }
        if ((this.stateMask & 0x100000000L) != 0L) {
            GL45.glBindBuffer((int)36671, (int)this.drawIndirectBuffer);
        }
        if ((this.stateMask & 0x200000000L) != 0L) {
            GL45.glBindBuffer((int)37074, (int)this.shaderStorageBuffer);
        }
        GlDebug.popGroup();
    }

    private void setGlCap(int cap, boolean enabled) {
        if (enabled) {
            GL45.glEnable((int)cap);
        } else {
            GL45.glDisable((int)cap);
        }
    }

    @Override
    public void close() {
        this.restore();
    }
}

