/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.framebuffer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import io.homo.superresolution.common.minecraft.RenderTargetCache;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.IDebuggableObject;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.opengl.GlDebug;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBufferAttachment;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL30;

public class GlFrameBuffer
implements IBindableFrameBuffer,
IDebuggableObject {
    private final float[] clearColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final ArrayList<GlFrameBufferAttachment> attachments = new ArrayList();
    private GlFrameBufferAttachment colorAttachment = null;
    private GlFrameBufferAttachment depthAttachment = null;
    private GlFrameBufferAttachment depthStencilAttachment = null;
    private int frameBufferId = Gl.DSA.createFramebuffer();
    private int width;
    private int height;
    private String label;

    @Override
    public void label(String label) {
        this.label = label;
    }

    @NotNull
    public static GlFrameBuffer create(TextureFormat colorTextureFormat, TextureFormat depthTextureFormat, int width, int height) {
        GlFrameBuffer frameBuffer = new GlFrameBuffer();
        frameBuffer.width = width;
        frameBuffer.height = height;
        frameBuffer.addAttachment(new GlFrameBufferAttachment(GlFrameBufferAttachment.FrameBufferAttachmentType.COLOR, RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).format(colorTextureFormat).width(width).height(height).usages(TextureUsages.create().storage().sampler().attachmentColor()).build())));
        if (depthTextureFormat != null) {
            frameBuffer.addAttachment(new GlFrameBufferAttachment(depthTextureFormat.isStencil() ? GlFrameBufferAttachment.FrameBufferAttachmentType.DEPTH_STENCIL : GlFrameBufferAttachment.FrameBufferAttachmentType.DEPTH, RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).format(depthTextureFormat).width(width).height(height).usages(TextureUsages.create().storage().sampler().attachmentDepth()).build())));
        }
        frameBuffer.validate();
        return frameBuffer;
    }

    @NotNull
    public static GlFrameBuffer create(ITexture colorTexture, ITexture depthTexture, int width, int height) {
        GlFrameBuffer frameBuffer = new GlFrameBuffer();
        frameBuffer.width = width;
        frameBuffer.height = height;
        frameBuffer.addAttachment(new GlFrameBufferAttachment(GlFrameBufferAttachment.FrameBufferAttachmentType.COLOR, colorTexture));
        if (depthTexture != null) {
            frameBuffer.addAttachment(new GlFrameBufferAttachment(depthTexture.getTextureFormat().isStencil() ? GlFrameBufferAttachment.FrameBufferAttachmentType.DEPTH_STENCIL : GlFrameBufferAttachment.FrameBufferAttachmentType.DEPTH, depthTexture));
        }
        frameBuffer.validate();
        return frameBuffer;
    }

    @NotNull
    public static GlFrameBuffer create(int width, int height) {
        return GlFrameBuffer.create(RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).format(TextureFormat.RGBA8).width(width).height(height).usages(TextureUsages.create().storage().sampler().attachmentColor()).build()), RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).format(TextureFormat.DEPTH24).width(width).height(height).usages(TextureUsages.create().storage().sampler().attachmentDepth()).build()), width, height);
    }

    @NotNull
    public static GlFrameBuffer create() {
        return GlFrameBuffer.create(RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).format(TextureFormat.RGBA8).width(1).height(1).usages(TextureUsages.create().storage().sampler().attachmentColor()).build()), RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).format(TextureFormat.DEPTH24).width(1).height(1).usages(TextureUsages.create().storage().sampler().attachmentDepth()).build()), 1, 1);
    }

    @NotNull
    public static GlFrameBuffer create(ITexture colorTexture, ITexture depthTexture) {
        return GlFrameBuffer.create(colorTexture, depthTexture, colorTexture.getWidth(), colorTexture.getHeight());
    }

    public static int resolveBindTarget(FrameBufferBindPoint point) {
        return switch (point) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferBindPoint.Read -> 36008;
            case FrameBufferBindPoint.Write -> 36009;
            case FrameBufferBindPoint.All -> 36160;
        };
    }

    public void addAttachment(GlFrameBufferAttachment attachment) {
        if (attachment.type == GlFrameBufferAttachment.FrameBufferAttachmentType.COLOR) {
            this.colorAttachment = attachment;
        } else if (attachment.type == GlFrameBufferAttachment.FrameBufferAttachmentType.DEPTH) {
            this.depthAttachment = attachment;
        } else {
            this.depthStencilAttachment = attachment;
        }
        Gl.DSA.framebufferTexture(this.frameBufferId, attachment.type.attachmentId(), (int)attachment.texture.handle(), 0);
        this.attachments.add(attachment);
        this.updateDebugLabel(this.getDebugLabel());
    }

    @Override
    public void destroy() {
        if (this.frameBufferId != -1) {
            Gl.DSA.deleteFramebuffer(this.frameBufferId);
            this.frameBufferId = -1;
        }
    }

    public void validate() {
        int status = Gl.DSA.checkNamedFramebufferStatus(this.frameBufferId, 36160);
        if (status != 36053) {
            String errorDesc = switch (status) {
                case 33305 -> "UNDEFINED";
                case 36054 -> "INCOMPLETE_ATTACHMENT";
                case 36055 -> "MISSING_ATTACHMENT";
                case 36061 -> "UNSUPPORTED_FORMAT";
                default -> "UNKNOWN_ERROR";
            };
            throw new IllegalStateException("FBO validation failed: " + errorDesc + " (0x" + Integer.toHexString(status) + ")");
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void clearFrameBuffer() {
        if (this.colorAttachment != null) {
            Gl.DSA.clearNamedFramebufferfv(this.frameBufferId, 6144, 0, this.clearColor);
        }
        if (this.depthAttachment != null) {
            Gl.DSA.clearNamedFramebufferfv(this.frameBufferId, 6145, 0, new float[]{1.0f});
        }
        if (this.depthStencilAttachment != null) {
            Gl.DSA.clearNamedFramebufferfi(this.frameBufferId, 34041, 0, 1.0f, 0);
        }
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        if (width < 1 || height < 1) {
            throw new RuntimeException("%s %s".formatted(width, height));
        }
        for (GlFrameBufferAttachment attachment : this.attachments) {
            attachment.texture.resize(width, height);
        }
        Gl.DSA.deleteFramebuffer(this.frameBufferId);
        this.frameBufferId = Gl.DSA.createFramebuffer();
        this.width = width;
        this.height = height;
        ArrayList<GlFrameBufferAttachment> temp = new ArrayList<GlFrameBufferAttachment>(this.attachments);
        this.attachments.clear();
        for (GlFrameBufferAttachment attachment : temp) {
            this.addAttachment(attachment);
        }
        this.validate();
        this.updateDebugLabel(this.getDebugLabel());
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        int target = GlFrameBuffer.resolveBindTarget(bindPoint);
        GL30.glBindFramebuffer((int)target, (int)this.frameBufferId);
        if (setViewport) {
            GL30.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        GL30.glBindFramebuffer((int)GlFrameBuffer.resolveBindTarget(bindPoint), (int)0);
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferAttachmentType.Color -> {
                if (this.colorAttachment != null) {
                    yield (int)this.colorAttachment.texture.handle();
                }
                yield -1;
            }
            case FrameBufferAttachmentType.Depth -> {
                if (this.depthAttachment != null) {
                    yield (int)this.depthAttachment.texture.handle();
                }
                yield -1;
            }
            case FrameBufferAttachmentType.DepthStencil -> {
                if (this.depthStencilAttachment != null) {
                    yield (int)this.depthStencilAttachment.texture.handle();
                }
                yield -1;
            }
            case FrameBufferAttachmentType.AnyDepth -> this.depthStencilAttachment != null ? (int)this.depthStencilAttachment.texture.handle() : (this.depthAttachment != null ? (int)this.depthAttachment.texture.handle() : -1);
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferAttachmentType.Color -> {
                if (this.colorAttachment != null) {
                    yield this.colorAttachment.texture;
                }
                yield null;
            }
            case FrameBufferAttachmentType.Depth -> {
                if (this.depthAttachment != null) {
                    yield this.depthAttachment.texture;
                }
                yield null;
            }
            case FrameBufferAttachmentType.DepthStencil -> {
                if (this.depthStencilAttachment != null) {
                    yield this.depthStencilAttachment.texture;
                }
                yield null;
            }
            case FrameBufferAttachmentType.AnyDepth -> this.depthStencilAttachment != null ? this.depthStencilAttachment.texture : (this.depthAttachment != null ? this.depthAttachment.texture : null);
        };
    }

    @Override
    public void setClearColorRGBA(float r, float g, float b, float a) {
        this.clearColor[0] = r;
        this.clearColor[1] = g;
        this.clearColor[2] = b;
        this.clearColor[3] = a;
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        if (this.colorAttachment == null) {
            return null;
        }
        return this.colorAttachment.texture.getTextureFormat();
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        if (this.depthAttachment != null) {
            return this.depthAttachment.texture.getTextureFormat();
        }
        if (this.depthStencilAttachment != null) {
            return this.depthStencilAttachment.texture.getTextureFormat();
        }
        return null;
    }

    @Override
    public RenderTarget asMcRenderTarget() {
        return RenderTargetCache.cacheOf(this);
    }

    @Override
    public long handle() {
        return this.frameBufferId;
    }

    @Override
    public String getDebugLabel() {
        return this.label != null ? this.label : "FrameBuffer-%s|Color-%s|Depth-%s|DepthStencil-%s".formatted(this.handle(), this.colorAttachment != null ? this.colorAttachment.texture.string() : "None", this.depthAttachment != null ? this.depthAttachment.texture.string() : "None", this.depthStencilAttachment != null ? this.depthStencilAttachment.texture.string() : "None");
    }

    @Override
    public void updateDebugLabel(String newLabel) {
        GlDebug.objectLabel(36160, (int)this.handle(), newLabel);
    }
}

