/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.vulkan;

import io.homo.superresolution.core.graphics.impl.device.IDevice;
import io.homo.superresolution.core.graphics.system.IRenderSystem;
import io.homo.superresolution.core.graphics.vulkan.VulkanDevice;
import io.homo.superresolution.core.graphics.vulkan.utils.VkReflectionHelper;
import io.homo.superresolution.core.graphics.vulkan.utils.VulkanCapabilities;
import io.homo.superresolution.core.graphics.vulkan.utils.VulkanUtils;
import io.homo.superresolution.core.graphics.vulkan.utils.VulkanValidationLayers;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VK11;
import org.lwjgl.vulkan.VK12;
import org.lwjgl.vulkan.VkApplicationInfo;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCreateInfoEXT;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkDeviceCreateInfo;
import org.lwjgl.vulkan.VkDeviceQueueCreateInfo;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkInstanceCreateInfo;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceFeatures2;
import org.lwjgl.vulkan.VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT;
import org.lwjgl.vulkan.VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR;
import org.lwjgl.vulkan.VkPhysicalDeviceVulkan12Features;
import org.lwjgl.vulkan.VkQueueFamilyProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VkRenderSystem
implements IRenderSystem {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution-Vulkan");
    public static final boolean ENABLE_VALIDATION;
    private static final int DEFAULT_API_VERSION;
    private final List<String> instanceExtensions = new ArrayList<String>();
    private final List<String> deviceExtensions = new ArrayList<String>();
    protected VulkanValidationLayers validationLayers;
    protected VkInstance instance;
    protected VulkanCapabilities capabilities = new VulkanCapabilities();
    private VulkanDevice vulkanDevice;

    public VkInstance getVulkanInstance() {
        return this.instance;
    }

    private static PointerBuffer asPointerBuffer(MemoryStack stack, List<String> list) {
        PointerBuffer buffer = stack.mallocPointer(list.size());
        list.forEach(e -> buffer.put(stack.UTF8((CharSequence)e)));
        return (PointerBuffer)buffer.rewind();
    }

    @Override
    public IDevice device() {
        return this.vulkanDevice;
    }

    @Override
    public void finish() {
        VK10.vkDeviceWaitIdle((VkDevice)this.vulkanDevice.getVkDevice());
    }

    public VkRenderSystem addInstanceExtension(String ext) {
        this.instanceExtensions.add(ext);
        return this;
    }

    public VkRenderSystem addDeviceExtension(String ext) {
        this.deviceExtensions.add(ext);
        return this;
    }

    public VulkanCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void initRenderSystem() {
        this.createInstance();
        this.validationLayers = new VulkanValidationLayers(this.instance);
        if (ENABLE_VALIDATION) {
            this.validationLayers.setupDebugMessenger();
        }
        VkPhysicalDevice physicalDevice = this.selectPhysicalDevice();
        this.capabilities.init(this.instance, physicalDevice);
        this.vulkanDevice = this.createLogicalDeviceWithCapabilities(physicalDevice);
        this.vulkanDevice.getCommandManager().init();
        LOGGER.info("Vulkan \u521d\u59cb\u5316\u5b8c\u6210");
    }

    @Override
    public void destroyRenderSystem() {
        if (this.vulkanDevice != null) {
            this.vulkanDevice.destroy();
            VK10.vkDestroyDevice((VkDevice)this.vulkanDevice.getVkDevice(), null);
            this.vulkanDevice = null;
        }
        if (this.validationLayers != null) {
            this.validationLayers.destroy();
            this.validationLayers = null;
        }
        if (this.instance != null) {
            VK10.vkDestroyInstance((VkInstance)this.instance, null);
            this.instance = null;
        }
        if (this.capabilities != null) {
            this.capabilities.destroy();
            this.capabilities = null;
        }
        LOGGER.info("Vulkan \u5df2\u9500\u6bc1");
    }

    private void createInstance() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkApplicationInfo appInfo = VkApplicationInfo.calloc((MemoryStack)stack).sType(0).apiVersion(DEFAULT_API_VERSION).pEngineName(MemoryUtil.memUTF8((CharSequence)"Engine")).engineVersion(VK10.VK_MAKE_VERSION((int)0, (int)1, (int)0)).pApplicationName(MemoryUtil.memUTF8((CharSequence)"App")).applicationVersion(VK10.VK_MAKE_VERSION((int)1, (int)0, (int)0));
            VkInstanceCreateInfo createInfo = VkInstanceCreateInfo.calloc((MemoryStack)stack).sType(1).pApplicationInfo(appInfo).ppEnabledExtensionNames(VkRenderSystem.asPointerBuffer(stack, this.instanceExtensions));
            if (ENABLE_VALIDATION) {
                createInfo.ppEnabledLayerNames(VulkanValidationLayers.getValidationLayersPointerBuffer(stack));
                VkDebugUtilsMessengerCreateInfoEXT debugCreateInfo = VkDebugUtilsMessengerCreateInfoEXT.calloc((MemoryStack)stack);
                VulkanValidationLayers.populateDebugMessengerCreateInfo(debugCreateInfo);
                createInfo.pNext(debugCreateInfo.address());
            }
            PointerBuffer instancePtr = stack.mallocPointer(1);
            VulkanUtils.VK_CHECK(VK10.vkCreateInstance((VkInstanceCreateInfo)createInfo, null, (PointerBuffer)instancePtr), "Failed to create VkInstance");
            this.instance = VkReflectionHelper.createVkInstanceSafely(instancePtr.get(0), createInfo);
        }
    }

    private VkPhysicalDevice selectPhysicalDevice() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer deviceCount = stack.ints(0);
            VulkanUtils.VK_CHECK(VK10.vkEnumeratePhysicalDevices((VkInstance)this.instance, (IntBuffer)deviceCount, null));
            if (deviceCount.get(0) == 0) {
                throw new RuntimeException("No Vulkan-compatible GPU found");
            }
            PointerBuffer devices = stack.mallocPointer(deviceCount.get(0));
            VulkanUtils.VK_CHECK(VK10.vkEnumeratePhysicalDevices((VkInstance)this.instance, (IntBuffer)deviceCount, (PointerBuffer)devices));
            VkPhysicalDevice vkPhysicalDevice = new VkPhysicalDevice(devices.get(0), this.instance);
            return vkPhysicalDevice;
        }
    }

    private VulkanDevice createLogicalDeviceWithCapabilities(VkPhysicalDevice physicalDevice) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            int graphicsFamilyIndex = this.findGraphicsQueueFamilyIndex(stack, physicalDevice);
            if (graphicsFamilyIndex == -1) {
                throw new RuntimeException("No suitable queue family found");
            }
            VkDeviceQueueCreateInfo.Buffer queueCreateInfos = VkDeviceQueueCreateInfo.calloc((int)1, (MemoryStack)stack);
            ((VkDeviceQueueCreateInfo)queueCreateInfos.get(0)).sType(2).queueFamilyIndex(graphicsFamilyIndex).pQueuePriorities(stack.floats(1.0f));
            ArrayList<String> enableDeviceExts = new ArrayList<String>();
            List<String> supportedDeviceExts = this.capabilities.getDeviceExtensions();
            for (String ext : this.deviceExtensions) {
                if (supportedDeviceExts.contains(ext)) {
                    enableDeviceExts.add(ext);
                    LOGGER.info("\u542f\u7528\u8bbe\u5907\u6269\u5c55: {}", (Object)ext);
                    continue;
                }
                LOGGER.warn("\u6269\u5c55 {} \u4e0d\u88ab\u5f53\u524d\u7269\u7406\u8bbe\u5907\u652f\u6301\uff0c\u5df2\u8df3\u8fc7", (Object)ext);
            }
            VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT mutableDescriptorTypeFeaturesEXT = VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT.calloc((MemoryStack)stack).sType(1000351000);
            VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR shaderIntegerDotProductFeaturesKHR = VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR.calloc((MemoryStack)stack).sType(1000280000).pNext(mutableDescriptorTypeFeaturesEXT.address());
            VkPhysicalDeviceVulkan12Features features12 = VkPhysicalDeviceVulkan12Features.calloc((MemoryStack)stack).sType(51).pNext(shaderIntegerDotProductFeaturesKHR.address());
            VkPhysicalDeviceFeatures2 features2 = VkPhysicalDeviceFeatures2.calloc((MemoryStack)stack).sType(1000059000).pNext(features12.address());
            VK11.vkGetPhysicalDeviceFeatures2((VkPhysicalDevice)physicalDevice, (VkPhysicalDeviceFeatures2)features2);
            boolean deviceSupportsMutableDescriptor = mutableDescriptorTypeFeaturesEXT.mutableDescriptorType();
            boolean deviceSupportsShaderInt8 = features12.shaderInt8();
            boolean deviceSupportsShaderInt16 = features2.features().shaderInt16();
            boolean deviceSupportsShaderFloat16 = features12.shaderFloat16();
            boolean deviceSupportsShaderIntegerDotProduct = shaderIntegerDotProductFeaturesKHR.shaderIntegerDotProduct();
            boolean deviceSupportsShaderStorageImageWriteWithoutFormat = features2.features().shaderStorageImageWriteWithoutFormat();
            LOGGER.info("Vulkan \u8bbe\u5907\u7279\u6027\u652f\u6301\u72b6\u6001:");
            LOGGER.info("  mutableDescriptorType: {}", (Object)deviceSupportsMutableDescriptor);
            LOGGER.info("  shaderInt8: {}", (Object)deviceSupportsShaderInt8);
            LOGGER.info("  shaderInt16: {}", (Object)deviceSupportsShaderInt16);
            LOGGER.info("  shaderFloat16: {}", (Object)deviceSupportsShaderFloat16);
            LOGGER.info("  shaderStorageImageWriteWithoutFormat: {}", (Object)deviceSupportsShaderFloat16);
            LOGGER.info("  shaderIntegerDotProduct: {}", (Object)deviceSupportsShaderIntegerDotProduct);
            VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT deviceMutableFeatures = VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT.calloc((MemoryStack)stack).sType(1000351000).mutableDescriptorType(deviceSupportsMutableDescriptor);
            VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR deviceShaderIntFeatures = VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR.calloc((MemoryStack)stack).sType(1000280000).pNext(deviceMutableFeatures.address()).shaderIntegerDotProduct(deviceSupportsShaderIntegerDotProduct);
            VkPhysicalDeviceVulkan12Features deviceFeatures12 = VkPhysicalDeviceVulkan12Features.calloc((MemoryStack)stack).sType(51).pNext(deviceShaderIntFeatures.address()).shaderFloat16(deviceSupportsShaderFloat16).shaderInt8(deviceSupportsShaderInt8);
            VkPhysicalDeviceFeatures2 deviceFeatures2 = VkPhysicalDeviceFeatures2.calloc((MemoryStack)stack).sType(1000059000).pNext(deviceFeatures12.address());
            deviceFeatures2.features().shaderInt16(deviceSupportsShaderInt16);
            deviceFeatures2.features().shaderStorageImageWriteWithoutFormat(deviceSupportsShaderStorageImageWriteWithoutFormat);
            VkDeviceCreateInfo createInfo = VkDeviceCreateInfo.calloc((MemoryStack)stack).sType(3).pNext(deviceFeatures2.address()).pQueueCreateInfos(queueCreateInfos).ppEnabledExtensionNames(VkRenderSystem.asPointerBuffer(stack, enableDeviceExts)).pEnabledFeatures(null);
            if (ENABLE_VALIDATION) {
                createInfo.ppEnabledLayerNames(VulkanValidationLayers.getValidationLayersPointerBuffer(stack));
            }
            PointerBuffer pDevice = stack.mallocPointer(1);
            VulkanUtils.VK_CHECK(VK10.vkCreateDevice((VkPhysicalDevice)physicalDevice, (VkDeviceCreateInfo)createInfo, null, (PointerBuffer)pDevice), "Failed to create logical device");
            VulkanDevice vulkanDevice = new VulkanDevice(physicalDevice, new VkDevice(pDevice.get(0), physicalDevice, createInfo), graphicsFamilyIndex);
            return vulkanDevice;
        }
    }

    private int findGraphicsQueueFamilyIndex(MemoryStack stack, VkPhysicalDevice physicalDevice) {
        IntBuffer queueFamilyCount = stack.ints(0);
        VK10.vkGetPhysicalDeviceQueueFamilyProperties((VkPhysicalDevice)physicalDevice, (IntBuffer)queueFamilyCount, null);
        VkQueueFamilyProperties.Buffer queueFamilies = VkQueueFamilyProperties.malloc((int)queueFamilyCount.get(0), (MemoryStack)stack);
        VK10.vkGetPhysicalDeviceQueueFamilyProperties((VkPhysicalDevice)physicalDevice, (IntBuffer)queueFamilyCount, (VkQueueFamilyProperties.Buffer)queueFamilies);
        for (int i = 0; i < queueFamilies.capacity(); ++i) {
            if ((((VkQueueFamilyProperties)queueFamilies.get(i)).queueFlags() & 1) == 0) continue;
            return i;
        }
        return -1;
    }

    static {
        if (VulkanValidationLayers.checkValidationLayerSupport()) {
            // empty if block
        }
        ENABLE_VALIDATION = false;
        DEFAULT_API_VERSION = VK12.VK_API_VERSION_1_2;
    }
}

