/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui;

import io.homo.superresolution.core.gui.core.backends.interfaces.IPaint;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.impl.Rectangle;
import io.homo.superresolution.core.utils.Color;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.Animator;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.AnimatorListener;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.BezierInterpolator;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.PropertyValuesHolder;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.TimeInterpolator;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class MaterialRipple {
    private static final int DEFAULT_MAX_RIPPLES = 5;
    private static final long MAX_RIPPLE_AGE = 2000L;
    private final List<SingleRipple> activeRipples = new ArrayList<SingleRipple>();
    private final int maxConcurrentRipples;
    private boolean pressed = false;

    public MaterialRipple() {
        this(5);
    }

    public MaterialRipple(int maxConcurrentRipples) {
        this.maxConcurrentRipples = Math.max(1, maxConcurrentRipples);
    }

    public void update() {
        Iterator<SingleRipple> iterator = this.activeRipples.iterator();
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            SingleRipple ripple = iterator.next();
            if (!ripple.isDestroy() && currentTime - ripple.getCreationTime() <= 2000L) continue;
            ripple.destroy();
            iterator.remove();
        }
    }

    public void setPressed(boolean pressed, Vector2f center, Rectangle region) {
        if (center == null || region == null) {
            return;
        }
        if (pressed) {
            this.addNewRipple(center, region);
            this.pressed = true;
        } else {
            this.releaseAllRipples();
            this.pressed = false;
        }
    }

    private void addNewRipple(Vector2f center, Rectangle region) {
        if (this.activeRipples.size() >= this.maxConcurrentRipples) {
            SingleRipple oldestInactive = this.findOldestInactiveRipple();
            if (oldestInactive != null) {
                oldestInactive.destroy();
                this.activeRipples.remove(oldestInactive);
            } else {
                SingleRipple oldest = this.findOldestRipple();
                if (oldest != null) {
                    oldest.destroy();
                    this.activeRipples.remove(oldest);
                }
            }
        }
        SingleRipple newRipple = new SingleRipple(center, region);
        this.activeRipples.add(newRipple);
    }

    private void releaseAllRipples() {
        for (SingleRipple ripple : this.activeRipples) {
            ripple.setPressed(false);
        }
    }

    private SingleRipple findOldestRipple() {
        SingleRipple oldest = null;
        for (SingleRipple ripple : this.activeRipples) {
            if (oldest != null && ripple.getCreationTime() >= oldest.getCreationTime()) continue;
            oldest = ripple;
        }
        return oldest;
    }

    private SingleRipple findOldestInactiveRipple() {
        SingleRipple oldest = null;
        for (SingleRipple ripple : this.activeRipples) {
            if (ripple.isPressed() || oldest != null && ripple.getCreationTime() >= oldest.getCreationTime()) continue;
            oldest = ripple;
        }
        return oldest;
    }

    public IPaint[] getPaints(Color color, IUIDrawContext drawContext, Vector2f position, Vector2f size) {
        ArrayList<IPaint> paints = new ArrayList<IPaint>();
        for (SingleRipple ripple : this.activeRipples) {
            IPaint paint;
            if (!ripple.shouldRender() || ripple.isDestroy() || (paint = ripple.createPaint(color, drawContext)) == null) continue;
            paints.add(paint);
        }
        return paints.toArray(new IPaint[0]);
    }

    public boolean shouldRender() {
        for (SingleRipple ripple : this.activeRipples) {
            if (!ripple.shouldRender()) continue;
            return true;
        }
        return false;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void clearAllRipples() {
        for (SingleRipple ripple : this.activeRipples) {
            ripple.destroy();
        }
        this.activeRipples.clear();
    }

    public void destroy() {
        this.clearAllRipples();
    }

    public static class SingleRipple {
        private static final long EXPAND_DURATION = 225L;
        private static final long FADE_OUT_DURATION = 375L;
        private static final float PRESSED_ALPHA = 0.12f;
        private ValueAnimator radiusAnimator;
        private ValueAnimator alphaAnimator;
        private AnimatorListener radiusListener;
        private AnimatorListener alphaListener;
        private final Vector2f rippleCenter;
        private final long creationTime;
        private final float maxRippleRadius;
        private volatile boolean isProcessingCallback = false;
        private RippleState state = RippleState.IDLE;
        private boolean pressed = true;
        private boolean isDestroy = false;

        public SingleRipple(Vector2f center, Rectangle region) {
            if (center == null || region == null) {
                throw new IllegalArgumentException("Center and region cannot be null");
            }
            this.rippleCenter = new Vector2f((Vector2fc)center);
            this.maxRippleRadius = this.calcMaxDistance(this.rippleCenter, region);
            this.creationTime = System.currentTimeMillis();
            this.initAnimators();
            this.startRipple();
        }

        private void initAnimators() {
            this.radiusAnimator = ValueAnimator.ofFloat(0.0f, 0.0f);
            this.radiusAnimator.setDuration(225L);
            this.radiusAnimator.setInterpolator(new BezierInterpolator(0.5f, 0.0f, 0.5f, 1.0f));
            this.alphaAnimator = ValueAnimator.ofFloat(1.0f, 1.0f);
            this.alphaAnimator.setDuration(375L);
            this.alphaAnimator.setInterpolator(TimeInterpolator.LINEAR);
            this.radiusListener = new AnimatorListener(){

                @Override
                public void onAnimationEnd(@NotNull Animator animation, boolean isReverse) {
                    if (isProcessingCallback || isDestroy || state != RippleState.EXPANDING) {
                        return;
                    }
                    isProcessingCallback = true;
                    try {
                        this.onExpandComplete();
                    }
                    finally {
                        isProcessingCallback = false;
                    }
                }
            };
            this.alphaListener = new AnimatorListener(){

                @Override
                public void onAnimationEnd(@NotNull Animator animation, boolean isReverse) {
                    if (isProcessingCallback || isDestroy || state != RippleState.FADING_OUT) {
                        return;
                    }
                    isProcessingCallback = true;
                    try {
                        this.onFadeOutComplete();
                    }
                    finally {
                        isProcessingCallback = false;
                    }
                }
            };
        }

        public boolean isPressed() {
            return this.pressed;
        }

        public void setPressed(boolean pressed) {
            if (this.isDestroy) {
                return;
            }
            if (this.pressed == pressed) {
                return;
            }
            this.pressed = pressed;
            if (!pressed && this.state == RippleState.EXPANDED) {
                this.startFadeOut();
            }
        }

        private void startRipple() {
            if (this.isDestroy) {
                return;
            }
            this.state = RippleState.EXPANDING;
            if (this.radiusAnimator.isRunning()) {
                this.radiusAnimator.cancel();
            }
            if (this.alphaAnimator.isRunning()) {
                this.alphaAnimator.cancel();
            }
            this.radiusAnimator.removeListener(this.radiusListener);
            this.alphaAnimator.removeListener(this.alphaListener);
            this.radiusAnimator.setValues(PropertyValuesHolder.ofFloat(0.0f, 1.0f));
            this.radiusAnimator.setDuration(225L);
            this.radiusAnimator.setInterpolator(new BezierInterpolator(0.5f, 0.0f, 0.5f, 1.0f));
            this.alphaAnimator.setValues(PropertyValuesHolder.ofFloat(0.0f, 1.0f));
            this.alphaAnimator.setDuration(67L);
            this.alphaAnimator.setInterpolator(TimeInterpolator.LINEAR);
            this.radiusAnimator.addListener(this.radiusListener);
            this.alphaAnimator.addListener(this.alphaListener);
            this.radiusAnimator.start();
            this.alphaAnimator.start();
        }

        private void onExpandComplete() {
            if (this.state != RippleState.EXPANDING) {
                return;
            }
            this.state = RippleState.EXPANDED;
            if (!this.pressed) {
                this.startFadeOut();
            }
        }

        private void startFadeOut() {
            if (this.state == RippleState.FADING_OUT || this.isDestroy) {
                return;
            }
            this.state = RippleState.FADING_OUT;
            if (this.alphaAnimator.isRunning()) {
                this.alphaAnimator.cancel();
            }
            this.alphaAnimator.removeListener(this.alphaListener);
            this.alphaAnimator.setValues(PropertyValuesHolder.ofFloat(1.0f, 0.0f));
            this.alphaAnimator.setDuration(375L);
            this.alphaAnimator.setInterpolator(TimeInterpolator.LINEAR);
            this.alphaAnimator.addListener(this.alphaListener);
            this.alphaAnimator.start();
        }

        private void onFadeOutComplete() {
            this.destroy();
        }

        private float calcMaxDistance(Vector2f center, Rectangle region) {
            float maxDistance = 0.0f;
            float centerX = center.x;
            float centerY = center.y;
            maxDistance = Math.max(maxDistance, this.distance(centerX, centerY, region.x, region.y));
            maxDistance = Math.max(maxDistance, this.distance(centerX, centerY, region.getLimitX(), region.y));
            maxDistance = Math.max(maxDistance, this.distance(centerX, centerY, region.getLimitX(), region.getLimitY()));
            maxDistance = Math.max(maxDistance, this.distance(centerX, centerY, region.x, region.getLimitY()));
            maxDistance = Math.max(maxDistance, Math.max(region.width, region.height) * 0.5f);
            return maxDistance;
        }

        private float distance(float x1, float y1, float x2, float y2) {
            float dx = x2 - x1;
            float dy = y2 - y1;
            return (float)Math.sqrt(dx * dx + dy * dy);
        }

        public IPaint createPaint(Color color, IUIDrawContext drawContext) {
            if (this.isDestroy || this.state == RippleState.IDLE) {
                return drawContext.createPaint();
            }
            float radiusProgress = ((Float)this.radiusAnimator.getAnimatedValue()).floatValue();
            float alphaProgress = ((Float)this.alphaAnimator.getAnimatedValue()).floatValue();
            float currentRadius = this.maxRippleRadius * radiusProgress;
            float currentAlpha = 0.12f * alphaProgress;
            Color startColor = color.copy().alpha((int)(255.0f * currentAlpha));
            Color endColor = color.copy().alpha(0);
            return drawContext.radialGradient(this.rippleCenter.x, this.rippleCenter.y, 0.0f, currentRadius, startColor, endColor);
        }

        public boolean shouldRender() {
            return !this.isDestroy;
        }

        public RippleState getState() {
            return this.state;
        }

        public boolean isDestroy() {
            return this.isDestroy;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public Vector2f getCenter() {
            return new Vector2f((Vector2fc)this.rippleCenter);
        }

        public void destroy() {
            if (this.isDestroy) {
                return;
            }
            this.isDestroy = true;
            this.state = RippleState.IDLE;
            if (this.radiusAnimator != null) {
                if (this.radiusListener != null) {
                    this.radiusAnimator.removeListener(this.radiusListener);
                }
                if (this.radiusAnimator.isRunning()) {
                    this.radiusAnimator.cancel();
                }
                this.radiusAnimator = null;
            }
            if (this.alphaAnimator != null) {
                if (this.alphaListener != null) {
                    this.alphaAnimator.removeListener(this.alphaListener);
                }
                if (this.alphaAnimator.isRunning()) {
                    this.alphaAnimator.cancel();
                }
                this.alphaAnimator = null;
            }
            this.radiusListener = null;
            this.alphaListener = null;
        }

        public static enum RippleState {
            IDLE,
            EXPANDING,
            EXPANDED,
            FADING_OUT;

        }
    }
}

