/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui;

import io.homo.superresolution.core.gui.core.AbstractWidget;
import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVG;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGContext;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVGDrawContext;
import io.homo.superresolution.core.gui.core.event.GuiEventListener;
import io.homo.superresolution.core.gui.core.impl.Renderable;
import io.homo.superresolution.core.utils.MouseCursor;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;

public abstract class NanoVGScreen<T>
extends Screen {
    protected final NanoVGContext nvg;
    protected final ArrayList<Renderable> renderable = new ArrayList();
    protected final ArrayList<GuiEventListener> eventListener = new ArrayList();
    protected final ArrayList<AbstractWidget<?, ?, ?>> widget = new ArrayList();
    protected boolean transparent = false;

    protected NanoVGScreen(Component title) {
        super(title);
        this.nvg = NanoVG.context;
        this.buildWidgets();
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public NanoVGScreen setTransparent(boolean transparent) {
        this.transparent = transparent;
        return this;
    }

    protected abstract void buildWidgets();

    public void m_7379_() {
        super.m_7379_();
        MouseCursor.ARROW.use();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX_, int mouseY_, float partialTick) {
        float mouseX = (float)(Minecraft.m_91087_().m_91268_().m_85449_() * (double)mouseX_);
        float mouseY = (float)(Minecraft.m_91087_().m_91268_().m_85449_() * (double)mouseY_);
        this.drawBefore(guiGraphics, (int)mouseX, (int)mouseY, partialTick);
        this.nvg.begin(this.transparent);
        this.nvg.resetGlobalTransform();
        this.nvg.resetTransform();
        this.nvg.globalAlpha(1.0f);
        NanoVGDrawContext drawContext = new NanoVGDrawContext(this.nvg);
        this.draw(drawContext, new UIInputState(new Vector2f(mouseX, mouseY), partialTick));
        drawContext.drawAll();
        this.nvg.end();
        this.drawAfter(guiGraphics, (int)mouseX, (int)mouseY, partialTick);
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public void m_6574_(@NotNull Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
    }

    public void draw(IUIDrawContext drawContext, UIInputState inputState) {
        this.drawBefore(drawContext, inputState);
        this.drawWidgets(drawContext, inputState);
        this.drawTooltips(drawContext, inputState);
        this.drawAfter(drawContext, inputState);
    }

    public void drawTooltips(IUIDrawContext drawContext, UIInputState inputState) {
    }

    public void drawAfter(IUIDrawContext drawContext, UIInputState inputState) {
    }

    public void drawBefore(IUIDrawContext drawContext, UIInputState inputState) {
    }

    public void drawAfter(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
    }

    public void drawBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
    }

    public void drawWidgets(IUIDrawContext drawContext, UIInputState inputState) {
        Map layers = Stream.concat(this.renderable.stream(), this.widget.stream()).collect(Collectors.groupingBy(Renderable::getZIndex, TreeMap::new, Collectors.toList()));
        layers.values().forEach(layer -> layer.forEach(r -> r.render(drawContext, inputState)));
    }

    protected void m_169413_() {
        super.m_169413_();
        this.renderable.clear();
        this.widget.clear();
        this.eventListener.clear();
    }

    protected void removeWidget(Object widget) {
        if (widget instanceof Renderable) {
            this.renderable.remove(widget);
        }
        if (widget instanceof AbstractWidget) {
            this.widget.remove(widget);
        }
        if (widget instanceof GuiEventListener) {
            this.eventListener.remove(widget);
        }
    }

    protected <T extends AbstractWidget<?, ?, ?>> T addWidget(T w) {
        this.widget.add(w);
        this.eventListener.add(w);
        return w;
    }

    protected void m_232761_() {
    }

    protected <T extends Renderable> T addRenderableOnly(T renderable) {
        this.renderable.add(renderable);
        return renderable;
    }

    protected <T extends AbstractWidget<?, ?, ?>> T addRenderableWidget(T widget) {
        this.renderable.add(widget);
        this.eventListener.add(widget);
        return widget;
    }

    protected void invokeEventHandle(Consumer<GuiEventListener> consumer) {
        for (GuiEventListener handle : this.eventListener) {
            consumer.accept(handle);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.invokeEventHandle(handle -> handle.mousePress((float)this.transformPos(mouseX), (float)this.transformPos(mouseY), button));
        super.m_6375_(mouseX, mouseY, button);
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.invokeEventHandle(handle -> handle.mouseRelease((float)this.transformPos(mouseX), (float)this.transformPos(mouseY), button));
        super.m_6348_(mouseX, mouseY, button);
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.invokeEventHandle(handle -> handle.mouseDrag((float)this.transformPos(mouseX), (float)this.transformPos(mouseY), (float)this.transformPos(dragX), (float)this.transformPos(dragY), button));
        super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        return true;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.invokeEventHandle(handle -> handle.keyRelease(keyCode, scanCode, modifiers));
        super.m_7920_(keyCode, scanCode, modifiers);
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.invokeEventHandle(handle -> handle.keyPress(keyCode, scanCode, modifiers));
        super.m_7933_(keyCode, scanCode, modifiers);
        return true;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        this.invokeEventHandle(handle -> handle.charTyped(codePoint, modifiers));
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollX) {
        this.invokeEventHandle(handle -> handle.mouseScroll((float)this.transformPos(mouseX), (float)this.transformPos(mouseY), (float)this.transformPos(scrollX)));
        super.m_6050_(mouseX, mouseY, scrollX);
        return true;
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.invokeEventHandle(handle -> handle.mouseMove((float)this.transformPos(mouseX), (float)this.transformPos(mouseY)));
        super.m_94757_(mouseX, mouseY);
    }

    protected double transformPos(double pos) {
        return Minecraft.m_91087_().m_91268_().m_85449_() * pos / (double)this.nvg.globalScale();
    }
}

