/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.backends.interfaces;

import io.homo.superresolution.core.gui.core.backends.interfaces.CommandsBatch;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;

public class BatchManager {
    private final Stack<CommandsBatch> stack = new Stack();
    private final List<CommandsBatch> rootBatches = new ArrayList<CommandsBatch>();

    public CommandsBatch beginBatch() {
        CommandsBatch batch = new CommandsBatch();
        if (!this.stack.isEmpty()) {
            this.stack.peek().addChildBatch(batch);
        } else {
            this.rootBatches.add(batch);
        }
        this.stack.push(batch);
        return batch;
    }

    public void endBatch(int zIndex) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("No active batch to end");
        }
        CommandsBatch current = this.stack.pop();
        current.zIndex(zIndex);
        if (!this.stack.isEmpty()) {
            CommandsBatch parent = this.stack.peek();
            if (zIndex > parent.zIndex()) {
                CommandsBatch grandParent;
                CommandsBatch commandsBatch = grandParent = this.stack.size() >= 2 ? (CommandsBatch)this.stack.get(this.stack.size() - 2) : null;
                if (grandParent != null) {
                    grandParent.addChildBatch(current);
                } else {
                    this.rootBatches.add(current);
                }
            } else {
                parent.addChildBatch(current);
            }
        } else {
            this.rootBatches.add(current);
        }
    }

    public void clearBatches() {
        this.rootBatches.clear();
        this.stack.clear();
    }

    public void closeCurrentBatch() {
        if (!this.stack.isEmpty()) {
            this.stack.pop();
        }
    }

    public CommandsBatch getCurrentBatch() {
        return this.stack.isEmpty() ? null : this.stack.peek();
    }

    public void executeAll() {
        this.rootBatches.sort(Comparator.comparingInt(CommandsBatch::zIndex));
        for (CommandsBatch batch : this.rootBatches) {
            batch.execute();
        }
    }

    public void clear() {
        this.rootBatches.clear();
        this.stack.clear();
    }
}

