/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.backends.interfaces;

import io.homo.superresolution.core.gui.core.backends.interfaces.IFont;
import io.homo.superresolution.core.gui.core.backends.interfaces.IPaint;
import io.homo.superresolution.core.gui.core.backends.interfaces.ITextRenderer;
import io.homo.superresolution.core.gui.core.backends.interfaces.ITransformStack;
import io.homo.superresolution.core.utils.Color;

public interface IUIDrawContext
extends ITextRenderer {
    public ITransformStack transform();

    public void save();

    public void restore();

    public void line(float var1, float var2, float var3, float var4);

    public void rect(float var1, float var2, float var3, float var4);

    public void arc(float var1, float var2, float var3, float var4, float var5);

    default public void arc(float x, float y, float radius) {
        this.arc(x, y, radius, 0.0f, (float)Math.PI * 2);
    }

    default public void roundedRect(float x, float y, float width, float height, float radius) {
        this.roundedRectComplex(x, y, width, height, radius, radius, radius, radius);
    }

    public void roundedRectComplex(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    public void beginPath();

    public void endPath(boolean var1);

    default public void endPath() {
        this.endPath(true);
    }

    default public void drawLine(float x1, float y1, float x2, float y2, float lineWidth, Color color) {
        this.beginPath();
        this.drawColor(false, color);
        this.line(x1, y1, x2, y2);
        this.endPath(false);
    }

    default public void drawRect(float x, float y, float width, float height, Color color, boolean fill) {
        this.beginPath();
        this.drawColor(fill, color);
        this.rect(x, y, width, height);
        this.endPath(fill);
    }

    default public void drawRoundedRect(float x, float y, float width, float height, float radius, Color color, boolean fill) {
        this.beginPath();
        this.drawColor(fill, color);
        this.roundedRect(x, y, width, height, radius);
        this.endPath(fill);
    }

    default public void drawArc(float x, float y, float radius, Color color, boolean fill) {
        this.beginPath();
        this.drawColor(fill, color);
        this.arc(x, y, radius);
        this.endPath(fill);
    }

    public float globalAlpha();

    public void globalAlpha(float var1);

    public void resetScissor();

    public void scissor(float var1, float var2, float var3, float var4);

    public void paint(IPaint var1);

    public IPaint createPaint();

    public IPaint linearGradient(float var1, float var2, float var3, float var4, Color var5, Color var6);

    public IPaint linearGradient(float var1, float var2, float var3, float var4, Color var5, Color var6, IPaint var7);

    public IPaint imagePattern(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, int var9);

    public IPaint radialGradient(float var1, float var2, float var3, Color var4, Color var5);

    public IPaint radialGradient(float var1, float var2, float var3, float var4, Color var5, Color var6);

    public IPaint radialGradient(float var1, float var2, float var3, Color var4, Color var5, IPaint var6);

    public IPaint radialGradient(float var1, float var2, float var3, float var4, Color var5, Color var6, IPaint var7);

    public void strokeWidth(float var1);

    public void strokeColor(Color var1);

    public void fillColor(Color var1);

    public void immediateScissor(float var1, float var2, float var3, float var4);

    public void immediateResetScissor();

    public void immediateSave();

    public void immediateRestore();

    default public void drawColor(boolean fill, Color color) {
        if (fill) {
            this.fillColor(color);
        } else {
            this.strokeColor(color);
        }
    }

    public Color fillColor();

    public Color strokeColor();

    public float strokeWidth();

    public IFont font();

    public void beginBatch();

    public void endBatch(int var1);

    public void closeBatch();

    public void clearBatches();

    public void drawAll();
}

