/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.shadercompat;

import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlOnlyNameTexture;
import io.homo.superresolution.shadercompat.GlTextureInfoGetter;
import io.homo.superresolution.shadercompat.mixin.core.CompositeRendererAccessor;
import java.util.function.Function;
import net.irisshaders.iris.pipeline.CompositeRenderer;
import net.irisshaders.iris.targets.RenderTargets;

public class IrisTextureResolver {
    private static final String COLOR_PREFIX = "colortex";
    private static final String ALT_PREFIX = "alttex";
    private static final String DEPTH_TEX = "depthtex";
    private static final String NO_HAND_DEPTH_TEX = "noHandDepthtex";
    private static final String NO_TRANSLUCENT_DEPTH_TEX = "noTranslucentDepthtex";

    public static GlOnlyNameTexture getIrisTexture(CompositeRenderer renderer, String name) {
        int id = IrisTextureResolver.getIrisTextureByName(renderer, name);
        if (id < 1) {
            return null;
        }
        return new GlOnlyNameTexture(() -> {
            int format = GlTextureInfoGetter.getInternalFormat(3553, id);
            return format == 6402 ? TextureFormat.DEPTH32 : TextureFormat.fromGl(format);
        }, () -> GlTextureInfoGetter.getWidth(3553, id), () -> GlTextureInfoGetter.getHeight(3553, id), () -> id);
    }

    public static int getIrisTextureByName(CompositeRenderer renderer, String name) {
        return IrisTextureResolver.resolveTexture(renderer, name, texId -> IrisTextureResolver.getCompositeRendererRenderTargets(renderer).getOrCreate(texId.intValue()).getMainTexture(), texId -> IrisTextureResolver.getCompositeRendererRenderTargets(renderer).getOrCreate(texId.intValue()).getAltTexture(), depthId -> depthId, -1);
    }

    public static RenderTargets getCompositeRendererRenderTargets(CompositeRenderer renderer) {
        return ((CompositeRendererAccessor)renderer).getRenderTargets();
    }

    private static <T> T resolveTexture(CompositeRenderer renderer, String name, Function<Integer, T> colorResolver, Function<Integer, T> colorAltResolver, Function<Integer, T> depthResolver, T defaultValue) {
        try {
            if (name.startsWith(COLOR_PREFIX)) {
                return colorResolver.apply(Integer.parseInt(name.substring(COLOR_PREFIX.length())));
            }
            if (name.startsWith(ALT_PREFIX)) {
                return colorAltResolver.apply(Integer.parseInt(name.substring(ALT_PREFIX.length())));
            }
            if (name.equals(DEPTH_TEX)) {
                return depthResolver.apply(IrisTextureResolver.getDepthTexId(renderer));
            }
            if (name.equals(NO_HAND_DEPTH_TEX)) {
                return depthResolver.apply(IrisTextureResolver.getNoHandDepthTexId(renderer));
            }
            if (name.equals(NO_TRANSLUCENT_DEPTH_TEX)) {
                return depthResolver.apply(IrisTextureResolver.getNoTranslucentDepthTexId(renderer));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    private static int getDepthTexId(CompositeRenderer renderer) {
        return ((CompositeRendererAccessor)renderer).getRenderTargets().getDepthTexture();
    }

    private static int getNoHandDepthTexId(CompositeRenderer renderer) {
        return ((CompositeRendererAccessor)renderer).getRenderTargets().getDepthTextureNoHand().getTextureId();
    }

    private static int getNoTranslucentDepthTexId(CompositeRenderer renderer) {
        return ((CompositeRendererAccessor)renderer).getRenderTargets().getDepthTextureNoTranslucents().getTextureId();
    }
}

