/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.shadercompat.mixin.core;

import com.google.common.collect.ImmutableList;
import io.homo.superresolution.api.registry.AlgorithmRegistry;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.irisshaders.iris.gl.shader.StandardMacros;
import net.irisshaders.iris.helpers.StringPair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StandardMacros.class})
public class StandardMacrosMixin {
    @Inject(method={"createStandardEnvironmentDefines"}, at={@At(value="TAIL")}, cancellable=true, remap=false)
    private static void addSRDefines(CallbackInfoReturnable<ImmutableList<StringPair>> cir) {
        if (SuperResolutionConfig.isForceDisableShaderCompat()) {
            return;
        }
        ArrayList<StringPair> defines = new ArrayList<StringPair>((Collection)cir.getReturnValue());
        defines.add(new StringPair("SR_INSTALLED", "1"));
        HashMap idMap = new HashMap();
        ArrayList algorithms = new ArrayList(AlgorithmRegistry.getAlgorithmMap().values());
        AlgorithmRegistry.getAlgorithmMap().values().forEach(desc -> {
            int id = algorithms.indexOf(desc) + 345840;
            idMap.put(desc, id);
            defines.add(new StringPair("SR_ALGO_" + desc.codeName.toUpperCase(), Integer.toString(id)));
        });
        if (SuperResolutionConfig.isEnableUpscale()) {
            defines.add(new StringPair("SR_ENABLE", "1"));
            defines.add(new StringPair("SR_DISABLE", "0"));
            defines.add(new StringPair("SR_SUPPORTS_JITTER", SuperResolution.getCurrentAlgorithm().isSupportJitter() ? "1" : "0"));
            defines.add(new StringPair("SR_USING_ALGO", Integer.toString((Integer)idMap.get(SuperResolutionConfig.getUpscaleAlgorithm()))));
        } else {
            defines.add(new StringPair("SR_ENABLE", "0"));
            defines.add(new StringPair("SR_DISABLE", "1"));
            defines.add(new StringPair("SR_SUPPORTS_JITTER", "0"));
            defines.add(new StringPair("SR_USING_ALGO", "0"));
        }
        cir.setReturnValue((Object)ImmutableList.copyOf(defines));
    }
}

