/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaAlign;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaBaselineFunction;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaBoxSizing;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDimension;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirtiedFunction;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDisplay;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaEdge;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaErrata;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaFlexDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaGutter;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaJustify;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaMeasureFunction;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaMeasureMode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNodeType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaOverflow;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPhysicalEdge;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPositionType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaProps;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaSize;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaValue;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaWrap;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.CalculateLayout;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.FlexDirectionUtil;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.config.MutableYogaConfig;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.config.YogaConfig;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.YogaEvent;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.YogaEventType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.node.LayoutResults;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.node.LayoutableChildren;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.Comparison;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.FloatOptional;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.StyleLength;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.StyleSizeLength;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.YogaStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class YogaNode
implements YogaProps {
    private boolean hasNewLayout = true;
    private boolean isReferenceBaseline = false;
    private boolean isDirty = true;
    private boolean alwaysFormsContainingBlock = false;
    private YogaNodeType nodeType = YogaNodeType.DEFAULT;
    private Object context = null;
    private YogaMeasureFunction measureFunc = null;
    private YogaBaselineFunction baselineFunc = null;
    private YogaDirtiedFunction dirtiedFunc = null;
    private YogaStyle style;
    private LayoutResults layout;
    private int lineIndex = 0;
    private int contentsChildrenCount = 0;
    private YogaNode owner = null;
    private List<YogaNode> children;
    private YogaConfig config;
    private StyleSizeLength[] processedDimensions = new StyleSizeLength[2];
    @Nullable
    private String debugName;

    public YogaNode() {
        this(YogaConfig.getDefault());
    }

    public YogaNode(YogaConfig config) {
        Objects.requireNonNull(config, "Attempting to construct Node with null config");
        this.config = config;
        this.style = new YogaStyle();
        this.layout = new LayoutResults();
        this.children = new ArrayList<YogaNode>();
        this.processedDimensions[YogaDimension.WIDTH.ordinal()] = StyleSizeLength.undefined();
        this.processedDimensions[YogaDimension.HEIGHT.ordinal()] = StyleSizeLength.undefined();
        if (config.useWebDefaults()) {
            this.useWebDefaults();
        }
    }

    public YogaNode(YogaNode node) {
        this.hasNewLayout = node.hasNewLayout;
        this.isReferenceBaseline = node.isReferenceBaseline;
        this.isDirty = node.isDirty;
        this.alwaysFormsContainingBlock = node.alwaysFormsContainingBlock;
        this.nodeType = node.nodeType;
        this.context = node.context;
        this.measureFunc = node.measureFunc;
        this.baselineFunc = node.baselineFunc;
        this.dirtiedFunc = node.dirtiedFunc;
        this.style = new YogaStyle(node.style);
        this.layout = new LayoutResults(node.layout);
        this.lineIndex = node.lineIndex;
        this.contentsChildrenCount = node.contentsChildrenCount;
        this.owner = node.owner;
        this.children = new ArrayList<YogaNode>(node.children);
        this.config = node.config;
        this.processedDimensions = (StyleSizeLength[])node.processedDimensions.clone();
    }

    public Object getContext() {
        return this.context;
    }

    public boolean alwaysFormsContainingBlock() {
        return this.alwaysFormsContainingBlock;
    }

    public boolean hasNewLayout() {
        return this.hasNewLayout;
    }

    public YogaNodeType getNodeType() {
        return this.nodeType;
    }

    public boolean hasMeasureFunc() {
        return this.measureFunc != null;
    }

    public YogaSize measure(float availableWidth, YogaMeasureMode widthMode, float availableHeight, YogaMeasureMode heightMode) {
        YogaSize size = this.measureFunc.measure(this, availableWidth, widthMode, availableHeight, heightMode);
        if (Comparison.isUndefined(size.width()) || size.width() < 0.0f || Comparison.isUndefined(size.height()) || size.height() < 0.0f) {
            System.err.printf("Measure function returned an invalid dimension to Yoga: [width=%f, height=%f]%n", Float.valueOf(size.width()), Float.valueOf(size.height()));
            return new YogaSize(Comparison.maxOrDefined(0.0f, size.width()), Comparison.maxOrDefined(0.0f, size.height()));
        }
        return size;
    }

    public boolean isBaselineDefined() {
        return this.baselineFunc != null;
    }

    public float baseline(float width, float height) {
        return this.baselineFunc.baseline(this, width, height);
    }

    public float dimensionWithMargin(YogaFlexDirection axis, float widthSize) {
        return this.getLayout().measuredDimension(FlexDirectionUtil.dimension(axis)) + this.style.computeMarginForAxis(axis, widthSize);
    }

    public boolean isLayoutDimensionDefined(YogaFlexDirection axis) {
        float value = this.getLayout().measuredDimension(FlexDirectionUtil.dimension(axis));
        return Comparison.isDefined(value) && value >= 0.0f;
    }

    public boolean hasDefiniteLength(YogaDimension dimension, float ownerSize) {
        FloatOptional usedValue = this.getProcessedDimension(dimension).resolve(ownerSize);
        return usedValue.isDefined() && usedValue.unwrap() >= 0.0f;
    }

    public boolean hasErrata(YogaErrata errata) {
        return this.config.hasErrata(errata);
    }

    public YogaDirtiedFunction getDirtiedFunc() {
        return this.dirtiedFunc;
    }

    public YogaStyle getStyle() {
        return this.style;
    }

    public LayoutResults getLayout() {
        return this.layout;
    }

    public int getLineIndex() {
        return this.lineIndex;
    }

    public boolean isReferenceBaseline() {
        return this.isReferenceBaseline;
    }

    public YogaNode getOwner() {
        return this.owner;
    }

    public List<YogaNode> getChildren() {
        return this.children;
    }

    public YogaNode getChild(int index) {
        return this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public LayoutableChildren getLayoutChildren() {
        return new LayoutableChildren(this);
    }

    public int getLayoutChildCount() {
        if (this.contentsChildrenCount == 0) {
            return this.children.size();
        }
        int count = 0;
        LayoutableChildren.LayoutIterator iter = this.getLayoutChildren().iterator();
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }

    public YogaConfig getConfig() {
        return this.config;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public StyleSizeLength getProcessedDimension(YogaDimension dimension) {
        return this.processedDimensions[dimension.ordinal()];
    }

    public FloatOptional getResolvedDimension(YogaDirection direction, YogaDimension dimension, float referenceLength, float ownerWidth) {
        FloatOptional value = this.getProcessedDimension(dimension).resolve(referenceLength);
        if (this.style.getBoxSizing() == YogaBoxSizing.BORDER_BOX) {
            return value;
        }
        FloatOptional dimensionPaddingAndBorder = FloatOptional.of(this.style.computePaddingAndBorderForDimension(direction, dimension, ownerWidth));
        return value.add(dimensionPaddingAndBorder.isDefined() ? dimensionPaddingAndBorder : FloatOptional.of(0.0f));
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public void setAlwaysFormsContainingBlock(boolean alwaysFormsContainingBlock) {
        this.alwaysFormsContainingBlock = alwaysFormsContainingBlock;
    }

    public void setHasNewLayout(boolean hasNewLayout) {
        this.hasNewLayout = hasNewLayout;
    }

    public void markLayoutSeen() {
        this.setHasNewLayout(false);
    }

    public void setNodeType(YogaNodeType nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public void setMeasureFunction(YogaMeasureFunction measureFunc) {
        if (measureFunc == null) {
            this.setNodeType(YogaNodeType.DEFAULT);
        } else {
            if (!this.children.isEmpty()) {
                throw new IllegalStateException("Cannot set measure function: Nodes with measure functions cannot have children.");
            }
            this.setNodeType(YogaNodeType.TEXT);
        }
        this.measureFunc = measureFunc;
    }

    @Override
    public void setBaselineFunction(YogaBaselineFunction baselineFunc) {
        this.baselineFunc = baselineFunc;
    }

    public void setDirtiedFunc(YogaDirtiedFunction dirtiedFunc) {
        this.dirtiedFunc = dirtiedFunc;
    }

    public void setStyle(YogaStyle style) {
        this.style = style;
    }

    public void setLayout(LayoutResults layout) {
        this.layout = layout;
    }

    public void setLineIndex(int lineIndex) {
        this.lineIndex = lineIndex;
    }

    @Override
    public void setIsReferenceBaseline(boolean isReferenceBaseline) {
        this.isReferenceBaseline = isReferenceBaseline;
    }

    public void setOwner(YogaNode owner) {
        this.owner = owner;
    }

    public void setChildren(List<YogaNode> children) {
        if (children == null || children.isEmpty()) {
            if (this.getChildCount() > 0) {
                for (YogaNode child : this.getChildren()) {
                    child.setLayout(new LayoutResults());
                    child.setOwner(null);
                }
                this.children = new ArrayList<YogaNode>();
                this.markDirtyAndPropagate();
            }
        } else {
            if (this.getChildCount() > 0) {
                for (YogaNode oldChild : this.getChildren()) {
                    if (children.contains(oldChild)) continue;
                    oldChild.setLayout(new LayoutResults());
                    oldChild.setOwner(null);
                }
            }
            this.children = new ArrayList<YogaNode>(children);
            for (YogaNode child : children) {
                child.setOwner(this);
            }
            this.markDirtyAndPropagate();
        }
    }

    public void setConfig(MutableYogaConfig config) {
        Objects.requireNonNull(config, "Attempting to set a null config on a Node");
        if (config.useWebDefaults() != this.config.useWebDefaults()) {
            throw new IllegalArgumentException("UseWebDefaults may not be changed after constructing a Node");
        }
        if (YogaConfig.configUpdateInvalidatesLayout(this.config, config)) {
            this.markDirtyAndPropagate();
            this.layout.configVersion = 0;
        } else {
            this.layout.configVersion = config.getVersion();
        }
        this.config = config;
    }

    public void setDirty(boolean isDirty) {
        if (this.isDirty == isDirty) {
            return;
        }
        this.isDirty = isDirty;
        if (isDirty && this.dirtiedFunc != null) {
            this.dirtiedFunc.onDirtied(this);
        }
    }

    public void setLayoutDirection(YogaDirection direction) {
        this.layout.setDirection(direction);
    }

    public void setLayoutMargin(float margin, YogaPhysicalEdge edge) {
        this.layout.setMargin(edge, margin);
    }

    public void setLayoutBorder(float border, YogaPhysicalEdge edge) {
        this.layout.setBorder(edge, border);
    }

    public void setLayoutPadding(float padding, YogaPhysicalEdge edge) {
        this.layout.setPadding(edge, padding);
    }

    public void setLayoutLastOwnerDirection(YogaDirection direction) {
        this.layout.lastOwnerDirection = direction;
    }

    public void setLayoutComputedFlexBasis(FloatOptional computedFlexBasis) {
        this.layout.computedFlexBasis = computedFlexBasis;
    }

    public void setLayoutPosition(float position, YogaPhysicalEdge edge) {
        this.layout.setPosition(edge, position);
    }

    public void setLayoutComputedFlexBasisGeneration(long computedFlexBasisGeneration) {
        this.layout.computedFlexBasisGeneration = computedFlexBasisGeneration;
    }

    public void setLayoutMeasuredDimension(float measuredDimension, YogaDimension dimension) {
        this.layout.setMeasuredDimension(dimension, measuredDimension);
    }

    public void setLayoutHadOverflow(boolean hadOverflow) {
        this.layout.setHadOverflow(hadOverflow);
    }

    public void setLayoutDimension(float lengthValue, YogaDimension dimension) {
        this.layout.setDimension(dimension, lengthValue);
    }

    private static String f(float f) {
        if ((float)((int)f) == f) {
            return String.valueOf((int)f);
        }
        return String.valueOf(f);
    }

    @Nullable
    public String getDebugName() {
        return this.debugName;
    }

    public void setDebugName(@Nullable String debugName) {
        this.debugName = debugName;
    }

    public StyleSizeLength processFlexBasis() {
        StyleSizeLength flexBasis = this.style.getFlexBasis();
        if (!flexBasis.isAuto() && !flexBasis.isUndefined()) {
            return flexBasis;
        }
        if (this.style.getFlex().isDefined() && this.style.getFlex().unwrap() > 0.0f) {
            return this.config.useWebDefaults() ? StyleSizeLength.ofAuto() : StyleSizeLength.points(0.0f);
        }
        return StyleSizeLength.ofAuto();
    }

    public FloatOptional resolveFlexBasis(YogaDirection direction, YogaFlexDirection flexDirection, float referenceLength, float ownerWidth) {
        FloatOptional value = this.processFlexBasis().resolve(referenceLength);
        if (this.style.getBoxSizing() == YogaBoxSizing.BORDER_BOX) {
            return value;
        }
        YogaDimension dim = FlexDirectionUtil.dimension(flexDirection);
        FloatOptional dimensionPaddingAndBorder = FloatOptional.of(this.style.computePaddingAndBorderForDimension(direction, dim, ownerWidth));
        return value.add(dimensionPaddingAndBorder.isDefined() ? dimensionPaddingAndBorder : FloatOptional.of(0.0f));
    }

    public void processDimensions() {
        for (YogaDimension dim : List.of(YogaDimension.WIDTH, YogaDimension.HEIGHT)) {
            if (this.style.getMaxDimension(dim).isDefined() && this.style.getMaxDimension(dim).inexactEquals(this.style.getMinDimension(dim))) {
                this.processedDimensions[dim.ordinal()] = this.style.getMaxDimension(dim);
                continue;
            }
            this.processedDimensions[dim.ordinal()] = this.style.getDimension(dim);
        }
    }

    public YogaDirection resolveDirection(YogaDirection ownerDirection) {
        if (this.style.getDirection() == YogaDirection.INHERIT) {
            return ownerDirection != YogaDirection.INHERIT ? ownerDirection : YogaDirection.LTR;
        }
        return this.style.getDirection();
    }

    public void clearChildren() {
        this.children.clear();
    }

    public void replaceChild(YogaNode oldChild, YogaNode newChild) {
        if (oldChild.getStyle().getDisplay() == YogaDisplay.CONTENTS && newChild.getStyle().getDisplay() != YogaDisplay.CONTENTS) {
            --this.contentsChildrenCount;
        } else if (oldChild.getStyle().getDisplay() != YogaDisplay.CONTENTS && newChild.getStyle().getDisplay() == YogaDisplay.CONTENTS) {
            ++this.contentsChildrenCount;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != oldChild) continue;
            this.children.set(i, newChild);
            break;
        }
    }

    public void replaceChild(YogaNode child, int index) {
        YogaNode previousChild = this.children.get(index);
        if (previousChild.getStyle().getDisplay() == YogaDisplay.CONTENTS && child.getStyle().getDisplay() != YogaDisplay.CONTENTS) {
            --this.contentsChildrenCount;
        } else if (previousChild.getStyle().getDisplay() != YogaDisplay.CONTENTS && child.getStyle().getDisplay() == YogaDisplay.CONTENTS) {
            ++this.contentsChildrenCount;
        }
        this.children.set(index, child);
    }

    public void addChildAt(YogaNode child, int index) {
        this.insertChild(child, index);
        child.setOwner(this);
        this.markDirtyAndPropagate();
    }

    public void insertChild(YogaNode child, int index) {
        if (child.getOwner() != null) {
            throw new IllegalArgumentException("Child already has a owner, it must be removed first.");
        }
        if (this.measureFunc != null) {
            throw new IllegalArgumentException("Cannot add child: Nodes with measure functions cannot have children.");
        }
        if (child.getStyle().getDisplay() == YogaDisplay.CONTENTS) {
            ++this.contentsChildrenCount;
        }
        this.children.add(index, child);
    }

    public boolean removeChild(YogaNode child) {
        if (this.getChildCount() == 0) {
            return false;
        }
        int index = this.children.indexOf(child);
        if (index != -1) {
            if (child.getStyle().getDisplay() == YogaDisplay.CONTENTS) {
                --this.contentsChildrenCount;
            }
            this.children.remove(index);
            return true;
        }
        return false;
    }

    public boolean removeChildAndInvalidate(YogaNode child) {
        YogaNode childOwner = child.getOwner();
        if (this.removeChild(child)) {
            if (this == childOwner) {
                child.setLayout(new LayoutResults());
                child.setOwner(null);
            }
            this.markDirtyAndPropagate();
            return true;
        }
        return false;
    }

    public void removeChild(int index) {
        if (this.children.get(index).getStyle().getDisplay() == YogaDisplay.CONTENTS) {
            --this.contentsChildrenCount;
        }
        this.children.remove(index);
    }

    public void cloneChildrenIfNeeded() {
        for (int i = 0; i < this.children.size(); ++i) {
            YogaNode child = this.children.get(i);
            if (child.getOwner() == this) continue;
            YogaNode clone = this.config.cloneNode(child, this, i);
            clone.setOwner(this);
            this.children.set(i, clone);
        }
    }

    public void markDirtyAndPropagate() {
        if (!this.isDirty) {
            this.setDirty(true);
            this.setLayoutComputedFlexBasis(FloatOptional.of());
            if (this.owner != null) {
                this.owner.markDirtyAndPropagate();
            }
        }
    }

    public float resolveFlexGrow() {
        if (this.owner == null) {
            return 0.0f;
        }
        if (this.style.getFlexGrow().isDefined()) {
            return this.style.getFlexGrow().unwrap();
        }
        if (this.style.getFlex().isDefined() && this.style.getFlex().unwrap() > 0.0f) {
            return this.style.getFlex().unwrap();
        }
        return 0.0f;
    }

    public float resolveFlexShrink() {
        if (this.owner == null) {
            return 0.0f;
        }
        if (this.style.getFlexShrink().isDefined()) {
            return this.style.getFlexShrink().unwrap();
        }
        if (!this.config.useWebDefaults() && this.style.getFlex().isDefined() && this.style.getFlex().unwrap() < 0.0f) {
            return -this.style.getFlex().unwrap();
        }
        return this.config.useWebDefaults() ? 1.0f : 0.0f;
    }

    public boolean isNodeFlexible() {
        return this.style.getPositionType() != YogaPositionType.ABSOLUTE && (this.resolveFlexGrow() != 0.0f || this.resolveFlexShrink() != 0.0f);
    }

    public void reset() {
        if (!this.children.isEmpty()) {
            throw new IllegalStateException("Cannot reset a node which still has children attached");
        }
        if (this.owner != null) {
            throw new IllegalStateException("Cannot reset a node still attached to an owner");
        }
        YogaConfig savedConfig = this.config;
        this.hasNewLayout = true;
        this.isReferenceBaseline = false;
        this.isDirty = true;
        this.alwaysFormsContainingBlock = false;
        this.nodeType = YogaNodeType.DEFAULT;
        this.context = null;
        this.measureFunc = null;
        this.baselineFunc = null;
        this.dirtiedFunc = null;
        this.style = new YogaStyle();
        this.layout = new LayoutResults();
        this.lineIndex = 0;
        this.contentsChildrenCount = 0;
        this.owner = null;
        this.children = new ArrayList<YogaNode>();
        this.config = savedConfig;
        this.processedDimensions[YogaDimension.WIDTH.ordinal()] = StyleSizeLength.undefined();
        this.processedDimensions[YogaDimension.HEIGHT.ordinal()] = StyleSizeLength.undefined();
        if (this.config.useWebDefaults()) {
            this.useWebDefaults();
        }
    }

    private void useWebDefaults() {
        this.style.setFlexDirection(YogaFlexDirection.ROW);
        this.style.setAlignContent(YogaAlign.STRETCH);
    }

    private float relativePosition(YogaFlexDirection axis, YogaDirection direction, float axisSize) {
        if (this.style.getPositionType() == YogaPositionType.STATIC) {
            return 0.0f;
        }
        if (this.style.isInlineStartPositionDefined(axis, direction) && !this.style.isInlineStartPositionAuto(axis, direction)) {
            return this.style.computeInlineStartPosition(axis, direction, axisSize);
        }
        return -1.0f * this.style.computeInlineEndPosition(axis, direction, axisSize);
    }

    public void setPosition(YogaDirection direction, float ownerWidth, float ownerHeight) {
        YogaDirection directionRespectingRoot = this.owner != null ? direction : YogaDirection.LTR;
        YogaFlexDirection mainAxis = FlexDirectionUtil.resolveDirection(this.style.getFlexDirection(), directionRespectingRoot);
        YogaFlexDirection crossAxis = FlexDirectionUtil.resolveCrossDirection(mainAxis, directionRespectingRoot);
        float relativePositionMain = this.relativePosition(mainAxis, directionRespectingRoot, FlexDirectionUtil.isRow(mainAxis) ? ownerWidth : ownerHeight);
        float relativePositionCross = this.relativePosition(crossAxis, directionRespectingRoot, FlexDirectionUtil.isRow(mainAxis) ? ownerHeight : ownerWidth);
        YogaPhysicalEdge mainAxisLeadingEdge = FlexDirectionUtil.inlineStartEdge(mainAxis, direction);
        YogaPhysicalEdge mainAxisTrailingEdge = FlexDirectionUtil.inlineEndEdge(mainAxis, direction);
        YogaPhysicalEdge crossAxisLeadingEdge = FlexDirectionUtil.inlineStartEdge(crossAxis, direction);
        YogaPhysicalEdge crossAxisTrailingEdge = FlexDirectionUtil.inlineEndEdge(crossAxis, direction);
        this.setLayoutPosition(this.style.computeInlineStartMargin(mainAxis, direction, ownerWidth) + relativePositionMain, mainAxisLeadingEdge);
        this.setLayoutPosition(this.style.computeInlineEndMargin(mainAxis, direction, ownerWidth) + relativePositionMain, mainAxisTrailingEdge);
        this.setLayoutPosition(this.style.computeInlineStartMargin(crossAxis, direction, ownerWidth) + relativePositionCross, crossAxisLeadingEdge);
        this.setLayoutPosition(this.style.computeInlineEndMargin(crossAxis, direction, ownerWidth) + relativePositionCross, crossAxisTrailingEdge);
    }

    @Override
    public YogaDirection getStyleDirection() {
        return this.style.getDirection();
    }

    @Override
    public void setDirection(YogaDirection direction) {
        if (this.style.getDirection() != direction) {
            this.style.setDirection(direction);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaFlexDirection getFlexDirection() {
        return this.style.getFlexDirection();
    }

    @Override
    public void setFlexDirection(YogaFlexDirection flexDirection) {
        if (this.style.getFlexDirection() != flexDirection) {
            this.style.setFlexDirection(flexDirection);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaJustify getJustifyContent() {
        return this.style.getJustifyContent();
    }

    @Override
    public void setJustifyContent(YogaJustify justifyContent) {
        if (this.style.getJustifyContent() != justifyContent) {
            this.style.setJustifyContent(justifyContent);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaAlign getAlignItems() {
        return this.style.getAlignItems();
    }

    @Override
    public void setAlignItems(YogaAlign alignItems) {
        if (this.style.getAlignItems() != alignItems) {
            this.style.setAlignItems(alignItems);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaAlign getAlignSelf() {
        return this.style.getAlignSelf();
    }

    @Override
    public void setAlignSelf(YogaAlign alignSelf) {
        if (this.style.getAlignSelf() != alignSelf) {
            this.style.setAlignSelf(alignSelf);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaAlign getAlignContent() {
        return this.style.getAlignContent();
    }

    @Override
    public void setAlignContent(YogaAlign alignContent) {
        if (this.style.getAlignContent() != alignContent) {
            this.style.setAlignContent(alignContent);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaPositionType getPositionType() {
        return this.style.getPositionType();
    }

    @Override
    public void setPositionType(YogaPositionType positionType) {
        if (this.style.getPositionType() != positionType) {
            this.style.setPositionType(positionType);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaBoxSizing getBoxSizing() {
        return this.style.getBoxSizing();
    }

    @Override
    public void setBoxSizing(YogaBoxSizing boxSizing) {
        if (this.style.getBoxSizing() != boxSizing) {
            this.style.setBoxSizing(boxSizing);
            this.markDirtyAndPropagate();
        }
    }

    public YogaWrap getWrap() {
        return this.style.getFlexWrap();
    }

    @Override
    public void setWrap(YogaWrap flexWrap) {
        if (this.style.getFlexWrap() != flexWrap) {
            this.style.setFlexWrap(flexWrap);
            this.markDirtyAndPropagate();
        }
    }

    public YogaOverflow getOverflow() {
        return this.style.getOverflow();
    }

    public void setOverflow(YogaOverflow overflow) {
        if (this.style.getOverflow() != overflow) {
            this.style.setOverflow(overflow);
            this.markDirtyAndPropagate();
        }
    }

    public YogaDisplay getDisplay() {
        return this.style.getDisplay();
    }

    public void setDisplay(YogaDisplay display) {
        if (this.style.getDisplay() != display) {
            this.style.setDisplay(display);
            this.markDirtyAndPropagate();
        }
    }

    public float getFlex() {
        return this.style.getFlex().unwrapOrDefault(Float.NaN);
    }

    @Override
    public void setFlex(float flex) {
        FloatOptional value = FloatOptional.of(flex);
        if (!this.style.getFlex().equals(value)) {
            this.style.setFlex(value);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public float getFlexGrow() {
        return this.style.getFlexGrow().unwrapOrDefault(0.0f);
    }

    @Override
    public void setFlexGrow(float flexGrow) {
        FloatOptional value = FloatOptional.of(flexGrow);
        if (!this.style.getFlexGrow().equals(value)) {
            this.style.setFlexGrow(value);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public float getFlexShrink() {
        return this.style.getFlexShrink().unwrapOrDefault(this.config.useWebDefaults() ? 1.0f : 0.0f);
    }

    @Override
    public void setFlexShrink(float flexShrink) {
        FloatOptional value = FloatOptional.of(flexShrink);
        if (!this.style.getFlexShrink().equals(value)) {
            this.style.setFlexShrink(value);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaValue getFlexBasis() {
        return this.style.getFlexBasis().asYogaValue();
    }

    @Override
    public void setFlexBasis(float flexBasis) {
        StyleSizeLength value = StyleSizeLength.points(flexBasis);
        if (!this.style.getFlexBasis().equals(value)) {
            this.style.setFlexBasis(value);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public void setFlexBasisPercent(float percent) {
        StyleSizeLength value = StyleSizeLength.percent(percent);
        if (!this.style.getFlexBasis().equals(value)) {
            this.style.setFlexBasis(value);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public void setFlexBasisAuto() {
        StyleSizeLength value = StyleSizeLength.ofAuto();
        if (!this.style.getFlexBasis().equals(value)) {
            this.style.setFlexBasis(value);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public void setFlexBasisMaxContent() {
        StyleSizeLength value = StyleSizeLength.ofMaxContent();
        if (!this.style.getFlexBasis().equals(value)) {
            this.style.setFlexBasis(value);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public void setFlexBasisFitContent() {
        StyleSizeLength value = StyleSizeLength.ofFitContent();
        if (!this.style.getFlexBasis().equals(value)) {
            this.style.setFlexBasis(value);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public void setFlexBasisStretch() {
        StyleSizeLength value = StyleSizeLength.ofStretch();
        if (!this.style.getFlexBasis().equals(value)) {
            this.style.setFlexBasis(value);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaValue getMargin(YogaEdge edge) {
        return this.style.getMargin(edge).asYogaValue();
    }

    @Override
    public void setMargin(YogaEdge edge, StyleLength length) {
        if (!this.style.getMargin(edge).equals(length)) {
            this.style.setMargin(edge, length);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaValue getPadding(YogaEdge edge) {
        return this.style.getPadding(edge).asYogaValue();
    }

    @Override
    public void setPadding(YogaEdge edge, StyleLength value) {
        if (!this.style.getPadding(edge).equals(value)) {
            this.style.setPadding(edge, value);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public void setPaddingPercent(YogaEdge edge, float percent) {
        StyleLength length = StyleLength.percent(percent);
        if (!this.style.getPadding(edge).equals(length)) {
            this.style.setPadding(edge, length);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public float getBorder(YogaEdge edge) {
        StyleLength border = this.style.getBorder(edge);
        if (border.isUndefined() || border.isAuto()) {
            return Float.NaN;
        }
        return border.asYogaValue().value;
    }

    @Override
    public void setBorder(YogaEdge edge, float border) {
        StyleLength length = StyleLength.points(border);
        if (!this.style.getBorder(edge).equals(length)) {
            this.style.setBorder(edge, length);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaValue getPosition(YogaEdge edge) {
        return this.style.getPosition(edge).asYogaValue();
    }

    @Override
    public void setPosition(YogaEdge edge, StyleLength value) {
        if (!this.style.getPosition(edge).equals(value)) {
            this.style.setPosition(edge, value);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaValue getWidth() {
        return this.style.getDimension(YogaDimension.WIDTH).asYogaValue();
    }

    @Override
    public void setWidth(StyleSizeLength length) {
        if (!this.style.getDimension(YogaDimension.WIDTH).equals(length)) {
            this.style.setDimension(YogaDimension.WIDTH, length);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaValue getHeight() {
        return this.style.getDimension(YogaDimension.HEIGHT).asYogaValue();
    }

    @Override
    public void setHeight(StyleSizeLength length) {
        if (!this.style.getDimension(YogaDimension.HEIGHT).equals(length)) {
            this.style.setDimension(YogaDimension.HEIGHT, length);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public void setMinWidth(StyleSizeLength length) {
        if (!this.style.getMinDimension(YogaDimension.WIDTH).equals(length)) {
            this.style.setMinDimension(YogaDimension.WIDTH, length);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaValue getMinWidth() {
        return this.style.getMinDimension(YogaDimension.WIDTH).asYogaValue();
    }

    @Override
    public YogaValue getMinHeight() {
        return this.style.getMinDimension(YogaDimension.HEIGHT).asYogaValue();
    }

    @Override
    public void setMinHeight(StyleSizeLength length) {
        if (!this.style.getMinDimension(YogaDimension.HEIGHT).equals(length)) {
            this.style.setMinDimension(YogaDimension.HEIGHT, length);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaValue getMaxWidth() {
        return this.style.getMaxDimension(YogaDimension.WIDTH).asYogaValue();
    }

    @Override
    public void setMaxWidth(StyleSizeLength length) {
        if (!this.style.getMaxDimension(YogaDimension.WIDTH).equals(length)) {
            this.style.setMaxDimension(YogaDimension.WIDTH, length);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public YogaValue getMaxHeight() {
        return this.style.getMaxDimension(YogaDimension.HEIGHT).asYogaValue();
    }

    @Override
    public void setMaxHeight(StyleSizeLength length) {
        if (!this.style.getMaxDimension(YogaDimension.HEIGHT).equals(length)) {
            this.style.setMaxDimension(YogaDimension.HEIGHT, length);
            this.markDirtyAndPropagate();
        }
    }

    @Override
    public float getAspectRatio() {
        return this.style.getAspectRatio().unwrapOrDefault(Float.NaN);
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        FloatOptional value = FloatOptional.of(aspectRatio);
        if (!this.style.getAspectRatio().equals(value)) {
            this.style.setAspectRatio(value);
            this.markDirtyAndPropagate();
        }
    }

    public boolean isMeasureDefined() {
        return this.measureFunc != null;
    }

    public void setData(Object data) {
        this.setContext(data);
    }

    @Nullable
    public Object getData() {
        return this.getContext();
    }

    public float getLayoutX() {
        return this.layout.position(YogaPhysicalEdge.LEFT);
    }

    public float getLayoutY() {
        return this.layout.position(YogaPhysicalEdge.TOP);
    }

    public float getLayoutRight() {
        return this.layout.position(YogaPhysicalEdge.RIGHT);
    }

    public float getLayoutBottom() {
        return this.layout.position(YogaPhysicalEdge.BOTTOM);
    }

    public float getLayoutWidth() {
        return this.layout.dimension(YogaDimension.WIDTH);
    }

    public float getLayoutHeight() {
        return this.layout.dimension(YogaDimension.HEIGHT);
    }

    public float getLayoutMargin(YogaEdge edge) {
        return switch (edge) {
            case YogaEdge.LEFT -> this.layout.margin(YogaPhysicalEdge.LEFT);
            case YogaEdge.TOP -> this.layout.margin(YogaPhysicalEdge.TOP);
            case YogaEdge.RIGHT -> this.layout.margin(YogaPhysicalEdge.RIGHT);
            case YogaEdge.BOTTOM -> this.layout.margin(YogaPhysicalEdge.BOTTOM);
            case YogaEdge.START -> {
                if (this.getLayoutDirection() == YogaDirection.RTL) {
                    yield this.layout.margin(YogaPhysicalEdge.RIGHT);
                }
                yield this.layout.margin(YogaPhysicalEdge.LEFT);
            }
            case YogaEdge.END -> {
                if (this.getLayoutDirection() == YogaDirection.RTL) {
                    yield this.layout.margin(YogaPhysicalEdge.LEFT);
                }
                yield this.layout.margin(YogaPhysicalEdge.RIGHT);
            }
            default -> throw new IllegalArgumentException("Cannot get layout margins of multi-edge shorthands");
        };
    }

    public float getLayoutPadding(YogaEdge edge) {
        return switch (edge) {
            case YogaEdge.LEFT -> this.layout.padding(YogaPhysicalEdge.LEFT);
            case YogaEdge.TOP -> this.layout.padding(YogaPhysicalEdge.TOP);
            case YogaEdge.RIGHT -> this.layout.padding(YogaPhysicalEdge.RIGHT);
            case YogaEdge.BOTTOM -> this.layout.padding(YogaPhysicalEdge.BOTTOM);
            case YogaEdge.START -> {
                if (this.getLayoutDirection() == YogaDirection.RTL) {
                    yield this.layout.padding(YogaPhysicalEdge.RIGHT);
                }
                yield this.layout.padding(YogaPhysicalEdge.LEFT);
            }
            case YogaEdge.END -> {
                if (this.getLayoutDirection() == YogaDirection.RTL) {
                    yield this.layout.padding(YogaPhysicalEdge.LEFT);
                }
                yield this.layout.padding(YogaPhysicalEdge.RIGHT);
            }
            default -> throw new IllegalArgumentException("Cannot get layout padding of multi-edge shorthands");
        };
    }

    public float getLayoutBorder(YogaEdge edge) {
        return switch (edge) {
            case YogaEdge.LEFT -> this.layout.border(YogaPhysicalEdge.LEFT);
            case YogaEdge.TOP -> this.layout.border(YogaPhysicalEdge.TOP);
            case YogaEdge.RIGHT -> this.layout.border(YogaPhysicalEdge.RIGHT);
            case YogaEdge.BOTTOM -> this.layout.border(YogaPhysicalEdge.BOTTOM);
            case YogaEdge.START -> {
                if (this.getLayoutDirection() == YogaDirection.RTL) {
                    yield this.layout.border(YogaPhysicalEdge.RIGHT);
                }
                yield this.layout.border(YogaPhysicalEdge.LEFT);
            }
            case YogaEdge.END -> {
                if (this.getLayoutDirection() == YogaDirection.RTL) {
                    yield this.layout.border(YogaPhysicalEdge.LEFT);
                }
                yield this.layout.border(YogaPhysicalEdge.RIGHT);
            }
            default -> throw new IllegalArgumentException("Cannot get layout border of multi-edge shorthands");
        };
    }

    public YogaDirection getLayoutDirection() {
        return this.layout.direction();
    }

    @Override
    public YogaValue getGap(YogaGutter gutter) {
        return this.style.getGap(gutter).asYogaValue();
    }

    @Override
    public void setGap(YogaGutter gutter, StyleLength value) {
        if (!this.style.getGap(gutter).equals(value)) {
            this.style.setGap(gutter, value);
            this.markDirtyAndPropagate();
        }
    }

    public void calculateLayout(float width, float height) {
        this.calculateLayout(width, height, this.style.getDirection());
    }

    public void calculateLayout(float width, float height, YogaDirection direction) {
        this.freeze(null);
        ArrayList<YogaNode> n = new ArrayList<YogaNode>();
        n.add(this);
        for (int i = 0; i < n.size(); ++i) {
            YogaNode parent = (YogaNode)n.get(i);
            List<YogaNode> children = parent.children;
            if (children == null) continue;
            for (YogaNode child : children) {
                child.freeze(parent);
            }
        }
        CalculateLayout.calculateLayout(this, width, height, direction);
    }

    private void freeze(YogaNode parent) {
        Object data = this.getData();
        if (data instanceof Inputs) {
            Inputs inputs = (Inputs)data;
            inputs.freeze(this, parent);
        }
    }

    public void copyStyle(YogaNode other) {
        if (!this.style.equals(other.style)) {
            this.style = new YogaStyle(other.style);
            this.markDirtyAndPropagate();
        }
    }

    public YogaNode cloneWithChildren() {
        YogaNode node = new YogaNode(this);
        YogaEvent.publish(node, YogaEventType.NODE_ALLOCATION, new YogaEvent.NodeAllocationData(this.config));
        node.setOwner(null);
        return node;
    }

    public YogaNode cloneWithoutChildren() {
        YogaNode node = new YogaNode(this);
        YogaEvent.publish(node, YogaEventType.NODE_ALLOCATION, new YogaEvent.NodeAllocationData(this.config));
        node.setOwner(null);
        node.clearChildren();
        return node;
    }

    public float getAbsolutePositionX() {
        if (this.owner != null) {
            return this.owner.getAbsolutePositionX() + this.getLayoutX();
        }
        return this.getLayoutX();
    }

    public float getAbsolutePositionY() {
        if (this.owner != null) {
            return this.owner.getAbsolutePositionY() + this.getLayoutY();
        }
        return this.getLayoutY();
    }

    public String toString() {
        if (this.debugName != null) {
            return this.debugName;
        }
        if (this.context != null) {
            return "context[" + String.valueOf(this.context) + "]";
        }
        return super.toString();
    }

    public static interface Inputs {
        public void freeze(YogaNode var1, @Nullable YogaNode var2);
    }
}

