/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaAlign;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDimension;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPhysicalEdge;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPositionType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.AlignUtil;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.FlexDirectionUtil;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.YogaEvent;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.YogaEventType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.node.LayoutableChildren;

public class Baseline {
    public static float calculateBaseline(YogaNode node) {
        YogaNode child;
        if (node.isBaselineDefined()) {
            YogaEvent.publish(node, YogaEventType.NODE_BASELINE_START);
            float baseline = node.baseline(node.getLayout().measuredDimension(YogaDimension.WIDTH), node.getLayout().measuredDimension(YogaDimension.HEIGHT));
            YogaEvent.publish(node, YogaEventType.NODE_BASELINE_END);
            assert (!Float.isNaN(baseline)) : "Expect custom baseline function to not return NaN";
            return baseline;
        }
        YogaNode baselineChild = null;
        LayoutableChildren.LayoutIterator layoutIterator = node.getLayoutChildren().iterator();
        while (layoutIterator.hasNext() && (child = (YogaNode)layoutIterator.next()).getLineIndex() <= 0) {
            if (child.getStyle().getPositionType() == YogaPositionType.ABSOLUTE) continue;
            if (AlignUtil.resolveChildAlignment(node, child) == YogaAlign.BASELINE || child.isReferenceBaseline()) {
                baselineChild = child;
                break;
            }
            if (baselineChild != null) continue;
            baselineChild = child;
        }
        if (baselineChild == null) {
            return node.getLayout().measuredDimension(YogaDimension.HEIGHT);
        }
        float baseline = Baseline.calculateBaseline(baselineChild);
        return baseline + baselineChild.getLayout().position(YogaPhysicalEdge.TOP);
    }

    public static boolean isBaselineLayout(YogaNode node) {
        if (FlexDirectionUtil.isColumn(node.getStyle().getFlexDirection())) {
            return false;
        }
        if (node.getStyle().getAlignItems() == YogaAlign.BASELINE) {
            return true;
        }
        for (YogaNode child : node.getLayoutChildren()) {
            if (child.getStyle().getPositionType() == YogaPositionType.ABSOLUTE || child.getStyle().getAlignSelf() != YogaAlign.BASELINE) continue;
            return true;
        }
        return false;
    }
}

