/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDimension;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaFlexDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.FlexDirectionUtil;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.Comparison;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.FloatOptional;

public class BoundAxis {
    public static float paddingAndBorderForAxis(YogaNode node, YogaFlexDirection axis, YogaDirection direction, float widthSize) {
        return node.getStyle().computeInlineStartPaddingAndBorder(axis, direction, widthSize) + node.getStyle().computeInlineEndPaddingAndBorder(axis, direction, widthSize);
    }

    public static FloatOptional boundAxisWithinMinAndMax(YogaNode node, YogaDirection direction, YogaFlexDirection axis, FloatOptional value, float axisSize, float widthSize) {
        FloatOptional min = FloatOptional.of();
        FloatOptional max = FloatOptional.of();
        if (FlexDirectionUtil.isColumn(axis)) {
            min = node.getStyle().resolveMinDimension(direction, YogaDimension.HEIGHT, axisSize, widthSize);
            max = node.getStyle().resolveMaxDimension(direction, YogaDimension.HEIGHT, axisSize, widthSize);
        } else if (FlexDirectionUtil.isRow(axis)) {
            min = node.getStyle().resolveMinDimension(direction, YogaDimension.WIDTH, axisSize, widthSize);
            max = node.getStyle().resolveMaxDimension(direction, YogaDimension.WIDTH, axisSize, widthSize);
        }
        if (max.isDefined() && max.unwrap() >= 0.0f && value.unwrap() > max.unwrap()) {
            return max;
        }
        if (min.isDefined() && min.unwrap() >= 0.0f && value.unwrap() < min.unwrap()) {
            return min;
        }
        return value;
    }

    public static float boundAxis(YogaNode node, YogaFlexDirection axis, YogaDirection direction, float value, float axisSize, float widthSize) {
        return Comparison.maxOrDefined(BoundAxis.boundAxisWithinMinAndMax(node, direction, axis, FloatOptional.of(value), axisSize, widthSize).unwrap(), BoundAxis.paddingAndBorderForAxis(node, axis, direction, widthSize));
    }
}

