/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDimension;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNodeType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPhysicalEdge;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.Comparison;

public class PixelGrid {
    public static float roundValueToPixelGrid(double value, double pointScaleFactor, boolean forceCeil, boolean forceFloor) {
        double scaledValue = value * pointScaleFactor;
        double fractial = scaledValue % 1.0;
        if (fractial < 0.0) {
            fractial += 1.0;
        }
        scaledValue = Comparison.inexactEquals(fractial, 0.0) ? (scaledValue -= fractial) : (Comparison.inexactEquals(fractial, 1.0) ? scaledValue - fractial + 1.0 : (forceCeil ? scaledValue - fractial + 1.0 : (forceFloor ? (scaledValue -= fractial) : scaledValue - fractial + (!Double.isNaN(fractial) && (fractial > 0.5 || Comparison.inexactEquals(fractial, 0.5)) ? 1.0 : 0.0))));
        return Double.isNaN(scaledValue) || Double.isNaN(pointScaleFactor) ? Float.NaN : (float)(scaledValue / pointScaleFactor);
    }

    public static void roundLayoutResultsToPixelGrid(YogaNode node, double absoluteLeft, double absoluteTop) {
        double pointScaleFactor = node.getConfig().getPointScaleFactor();
        double nodeLeft = node.getLayout().position(YogaPhysicalEdge.LEFT);
        double nodeTop = node.getLayout().position(YogaPhysicalEdge.TOP);
        double nodeWidth = node.getLayout().dimension(YogaDimension.WIDTH);
        double nodeHeight = node.getLayout().dimension(YogaDimension.HEIGHT);
        double absoluteNodeLeft = absoluteLeft + nodeLeft;
        double absoluteNodeTop = absoluteTop + nodeTop;
        double absoluteNodeRight = absoluteNodeLeft + nodeWidth;
        double absoluteNodeBottom = absoluteNodeTop + nodeHeight;
        if (pointScaleFactor != 0.0) {
            boolean textRounding = node.getNodeType() == YogaNodeType.TEXT;
            node.setLayoutPosition(PixelGrid.roundValueToPixelGrid(nodeLeft, pointScaleFactor, false, textRounding), YogaPhysicalEdge.LEFT);
            node.setLayoutPosition(PixelGrid.roundValueToPixelGrid(nodeTop, pointScaleFactor, false, textRounding), YogaPhysicalEdge.TOP);
            double scaledNodeWith = nodeWidth * pointScaleFactor;
            boolean hasFractionalWidth = !Comparison.inexactEquals((double)Math.round(scaledNodeWith), scaledNodeWith);
            double scaledNodeHeight = nodeHeight * pointScaleFactor;
            boolean hasFractionalHeight = !Comparison.inexactEquals((double)Math.round(scaledNodeHeight), scaledNodeHeight);
            node.setLayoutDimension(PixelGrid.roundValueToPixelGrid(absoluteNodeRight, pointScaleFactor, textRounding && hasFractionalWidth, textRounding && !hasFractionalWidth) - PixelGrid.roundValueToPixelGrid(absoluteNodeLeft, pointScaleFactor, false, textRounding), YogaDimension.WIDTH);
            node.setLayoutDimension(PixelGrid.roundValueToPixelGrid(absoluteNodeBottom, pointScaleFactor, textRounding && hasFractionalHeight, textRounding && !hasFractionalHeight) - PixelGrid.roundValueToPixelGrid(absoluteNodeTop, pointScaleFactor, false, textRounding), YogaDimension.HEIGHT);
        }
        for (YogaNode child : node.getChildren()) {
            PixelGrid.roundLayoutResultsToPixelGrid(child, absoluteNodeLeft, absoluteNodeTop);
        }
    }
}

