/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.utils;

import io.homo.superresolution.common.platform.Arch;
import io.homo.superresolution.common.platform.OS;
import io.homo.superresolution.common.platform.OSType;
import io.homo.superresolution.common.platform.Platform;
import io.homo.superresolution.core.GraphicsCapabilities;
import io.homo.superresolution.core.interop.GlVkInteropManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Requirement {
    private final Set<String> requiredGlExtensions = new HashSet<String>();
    private final Set<OS> supportedOS = new HashSet<OS>();
    private final Set<String> requiredVulkanDeviceExtensions = new HashSet<String>();
    private int glMajorVersion = -1;
    private int glMinorVersion = -1;
    private int vulkanMajorVersion = -1;
    private int vulkanMinorVersion = -1;
    private int vulkanPatchVersion = -1;
    private boolean requiresDevEnv = false;
    private boolean requiresVulkan = false;

    private Requirement() {
    }

    public static Requirement nothing() {
        return new Requirement();
    }

    public Requirement vulkanMajorVersion(int vulkanMajorVersion) {
        this.vulkanMajorVersion = vulkanMajorVersion;
        return this;
    }

    public Requirement vulkanMinorVersion(int vulkanMinorVersion) {
        this.vulkanMinorVersion = vulkanMinorVersion;
        return this;
    }

    public Requirement vulkanPatchVersion(int vulkanPatchVersion) {
        this.vulkanPatchVersion = vulkanPatchVersion;
        return this;
    }

    public Set<String> getRequiredGlExtensions() {
        return Collections.unmodifiableSet(this.requiredGlExtensions);
    }

    public Set<String> getRequiredVulkanDeviceExtensions() {
        return Collections.unmodifiableSet(this.requiredVulkanDeviceExtensions);
    }

    public boolean isRequiresVulkan() {
        return this.requiresVulkan;
    }

    public boolean isRequiresDevEnv() {
        return this.requiresDevEnv;
    }

    public int getGlMinorVersion() {
        return this.glMinorVersion;
    }

    public int getGlMajorVersion() {
        return this.glMajorVersion;
    }

    public int getVulkanMajorVersion() {
        return this.vulkanMajorVersion;
    }

    public int getVulkanMinorVersion() {
        return this.vulkanMinorVersion;
    }

    public int getVulkanPatchVersion() {
        return this.vulkanPatchVersion;
    }

    public Requirement developmentEnvironment(boolean developmentEnvironment) {
        this.requiresDevEnv = developmentEnvironment;
        return this;
    }

    public Requirement requireVulkan(boolean requireVulkan) {
        this.requiresVulkan = requireVulkan;
        return this;
    }

    public Requirement glVersion(int major, int minor) {
        this.glMajorVersion = major;
        this.glMinorVersion = minor;
        return this;
    }

    public Requirement vulkanVersion(int major, int minor, int patch) {
        this.vulkanMajorVersion = major;
        this.vulkanMinorVersion = minor;
        this.vulkanPatchVersion = patch;
        return this;
    }

    private boolean checkVulkanVersion() {
        if (this.vulkanMajorVersion == -1) {
            return true;
        }
        int[] current = GraphicsCapabilities.getVulkanVersion();
        return current[0] > this.vulkanMajorVersion || current[0] == this.vulkanMajorVersion && (current[1] > this.vulkanMinorVersion || current[1] == this.vulkanMinorVersion && current[2] >= this.vulkanPatchVersion);
    }

    private boolean checkVulkanDeviceExtensions() {
        return this.requiredVulkanDeviceExtensions.stream().allMatch(GraphicsCapabilities::hasVulkanDeviceExtension);
    }

    public Requirement requireVulkanDeviceExtension(String extension) {
        this.requiredVulkanDeviceExtensions.add(extension);
        return this;
    }

    public Requirement glMajorVersion(int major) {
        this.glMajorVersion = major;
        return this;
    }

    public Requirement glMinorVersion(int minor) {
        this.glMinorVersion = minor;
        return this;
    }

    public Requirement requiredGlExtension(String name) {
        this.requiredGlExtensions.add(Objects.requireNonNull(name, "\u6269\u5c55\u540d\u79f0\u4e0d\u80fd\u4e3anull"));
        return this;
    }

    public Result check() {
        return new Result(this.checkOSCompatibility(), this.checkGLVersion(), this.checkGLExtensions(), this.checkEnvironment(), this.checkVulkanSupport(), this.checkVulkanVersion(), this.checkVulkanDeviceExtensions());
    }

    private boolean checkOSCompatibility() {
        if (this.supportedOS.isEmpty()) {
            return true;
        }
        OS current = Platform.currentPlatform.getOS();
        return this.supportedOS.stream().anyMatch(os -> os.arch.equals(current.arch) && os.type.equals(current.type));
    }

    private boolean checkGLVersion() {
        if (this.glMajorVersion == -1) {
            return true;
        }
        int[] currentVersion = GraphicsCapabilities.getGLVersion();
        return currentVersion[0] > this.glMajorVersion || currentVersion[0] == this.glMajorVersion && currentVersion[1] >= this.glMinorVersion;
    }

    private boolean checkGLExtensions() {
        return this.requiredGlExtensions.stream().allMatch(GraphicsCapabilities::hasGLExtension);
    }

    private boolean checkEnvironment() {
        return !this.requiresDevEnv || Platform.currentPlatform.isDevelopmentEnvironment();
    }

    private boolean checkVulkanSupport() {
        return !this.requiresVulkan || GlVkInteropManager.isSupportVulkan();
    }

    public List<String> getMissingGlExtensions() {
        return this.requiredGlExtensions.stream().filter(ext -> !GraphicsCapabilities.hasGLExtension(ext)).toList();
    }

    public List<String> getMissingVkExtensions() {
        return this.requiredVulkanDeviceExtensions.stream().filter(ext -> !GraphicsCapabilities.hasVulkanDeviceExtension(ext)).toList();
    }

    public Set<OS> getSupportedOS() {
        return Collections.unmodifiableSet(this.supportedOS);
    }

    public Requirement addSupportedOS(Arch arch) {
        return this.addSupportedOS(new OS(arch, OSType.ANY));
    }

    public Requirement addSupportedOS(OSType type) {
        return this.addSupportedOS(new OS(Arch.ANY, type));
    }

    public Requirement addSupportedOS(Arch arch, OSType type) {
        return this.addSupportedOS(new OS(arch, type));
    }

    public Requirement addSupportedOS(OS os) {
        this.supportedOS.add(Objects.requireNonNull(os, "\u64cd\u4f5c\u7cfb\u7edf\u914d\u7f6e\u4e0d\u80fd\u4e3anull"));
        return this;
    }

    @Deprecated
    public ArrayList<OS> getIncludeOS() {
        return new ArrayList<OS>(this.supportedOS);
    }

    public record Result(boolean osSupported, boolean glVersionMet, boolean glExtensionsPresent, boolean environmentValid, boolean vulkanAvailable, boolean vulkanVersionMet, boolean vulkanDeviceExtensionsMet) {
        public boolean support() {
            return this.osSupported && this.glVersionMet && this.glExtensionsPresent && this.environmentValid && this.vulkanAvailable && this.vulkanVersionMet && this.vulkanDeviceExtensionsMet;
        }
    }
}

