/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import io.homo.superresolution.core.gl.utils.GlBlitRenderer;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;

public class FrameBufferRenderTargetAdapter
extends RenderTarget {
    private IFrameBuffer frameBuffer;

    FrameBufferRenderTargetAdapter(IFrameBuffer frameBuffer) {
        super(frameBuffer.getDepthTextureFormat() != null);
        this.frameBuffer = frameBuffer;
        this.updateState();
    }

    protected static FrameBufferRenderTargetAdapter ofRenderTarget(IFrameBuffer frameBuffer) {
        return new FrameBufferRenderTargetAdapter(frameBuffer);
    }

    public FrameBufferRenderTargetAdapter bindFrameBuffer(IFrameBuffer frameBuffer) {
        this.frameBuffer = frameBuffer;
        return this;
    }

    private void updateState() {
        this.f_83915_ = this.frameBuffer.getWidth();
        this.f_83916_ = this.frameBuffer.getHeight();
        this.f_83917_ = this.frameBuffer.getWidth();
        this.f_83918_ = this.frameBuffer.getHeight();
        this.f_83920_ = this.frameBuffer.getFrameBufferId();
        this.f_83923_ = this.frameBuffer.getTextureId(FrameBufferAttachmentType.COLOR);
        this.f_83924_ = this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL) == -1 ? this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH) : this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL);
    }

    public void m_83956_() {
        this.updateState();
        this.frameBuffer.bind(FrameBufferBindPoint.READ);
    }

    public void m_83963_() {
        this.updateState();
        this.frameBuffer.unbind(FrameBufferBindPoint.READ);
    }

    public void m_83947_(boolean setViewport) {
        this.updateState();
        this.frameBuffer.bind(FrameBufferBindPoint.WRITE, setViewport);
    }

    public void m_83970_() {
        this.updateState();
        this.frameBuffer.unbind(FrameBufferBindPoint.WRITE);
    }

    public void m_83931_(float red, float green, float blue, float alpha) {
        this.updateState();
        this.frameBuffer.m_83931_(red, green, blue, alpha);
    }

    public void m_83938_(int width, int height) {
        this.updateState();
        GlBlitRenderer.blitToScreen(this.frameBuffer.getTextureId(FrameBufferAttachmentType.COLOR), this.f_83917_, this.f_83918_);
    }

    public void blitAndBlendToScreen(int width, int height) {
        this.updateState();
        this.m_83938_(width, height);
    }

    public void m_83954_(boolean a) {
        this.updateState();
        this.frameBuffer.clearFrameBuffer();
    }

    public void m_83941_(int width, int height, boolean clearError) {
    }

    public void m_83950_(int width, int height, boolean clearError) {
        this.updateState();
    }

    public int m_83975_() {
        this.updateState();
        return this.frameBuffer.getTextureId(FrameBufferAttachmentType.COLOR);
    }

    public int m_83980_() {
        this.updateState();
        return this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL) == -1 ? this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH) : this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL);
    }

    public void m_83930_() {
        this.updateState();
    }

    public void m_83945_(RenderTarget otherTarget) {
        this.updateState();
        GlStateManager._glBindFramebuffer((int)36008, (int)otherTarget.f_83920_);
        GlStateManager._glBindFramebuffer((int)36009, (int)this.f_83920_);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)otherTarget.f_83915_, (int)otherTarget.f_83916_, (int)0, (int)0, (int)this.f_83915_, (int)this.f_83916_, (int)256, (int)9728);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }
}

