/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;
import net.minecraft.client.Minecraft;

public class LegacyStorageFrameBuffer
extends RenderTarget
implements IFrameBuffer {
    private int colorAttachment1 = -1;
    private boolean stencilEnabled = false;

    public LegacyStorageFrameBuffer(boolean useDepth) {
        super(useDepth);
    }

    public void m_83950_(int width, int height, boolean clearError) {
        RenderSystem.assertOnRenderThreadOrInit();
        int maxSupportedTextureSize = RenderSystem.maxSupportedTextureSize();
        if (width > 0 && width <= maxSupportedTextureSize && height > 0 && height <= maxSupportedTextureSize) {
            this.f_83917_ = width;
            this.f_83918_ = height;
            this.f_83915_ = width;
            this.f_83916_ = height;
            this.f_83922_ = 9728;
            this.f_83920_ = Gl.glGenFramebuffers();
            this.f_83923_ = TextureUtil.generateTextureId();
            this.f_83924_ = TextureUtil.generateTextureId();
            this.colorAttachment1 = TextureUtil.generateTextureId();
            Gl.glBindFramebuffer(36160, this.f_83920_);
            Gl.glBindTexture(3553, this.f_83924_);
            Gl.glTexParameteri(3553, 10241, 9728);
            Gl.glTexParameteri(3553, 10240, 9728);
            Gl.glTexParameteri(3553, 34892, 0);
            Gl.glTexParameteri(3553, 10242, 33071);
            Gl.glTexParameteri(3553, 10243, 33071);
            if (this.stencilEnabled) {
                Gl.glTexStorage2D(3553, 1, 35056, this.f_83915_, this.f_83916_);
                Gl.glFramebufferTexture2D(36160, 36128, 3553, this.f_83924_, 0);
            } else {
                Gl.glTexStorage2D(3553, 1, 33190, this.f_83915_, this.f_83916_);
            }
        } else {
            throw new IllegalArgumentException("Window " + width + "x" + height + " size out of bounds (max. size: " + maxSupportedTextureSize + ")");
        }
        Gl.glFramebufferTexture2D(36160, 36096, 3553, this.f_83924_, 0);
        Gl.glBindTexture(3553, this.f_83923_);
        Gl.glTexParameteri(3553, 10241, 9728);
        Gl.glTexParameteri(3553, 10240, 9728);
        Gl.glTexParameteri(3553, 10242, 33071);
        Gl.glTexParameteri(3553, 10243, 33071);
        Gl.glTexStorage2D(3553, 1, 32856, this.f_83915_, this.f_83916_);
        Gl.glFramebufferTexture2D(36160, 36064, 3553, this.f_83923_, 0);
        Gl.glBindTexture(3553, this.colorAttachment1);
        Gl.glTexParameteri(3553, 10241, 9728);
        Gl.glTexParameteri(3553, 10240, 9728);
        Gl.glTexParameteri(3553, 10242, 33071);
        Gl.glTexParameteri(3553, 10243, 33071);
        Gl.glTexStorage2D(3553, 1, TextureFormat.RG16F.gl(), this.f_83915_, this.f_83916_);
        this.m_83949_();
        this.m_83954_(clearError);
        this.m_83963_();
    }

    public void enableStencil() {
        if (!this.stencilEnabled) {
            this.stencilEnabled = true;
            this.m_83941_(this.f_83917_, this.f_83918_, Minecraft.f_91002_);
        }
    }

    public boolean isStencilEnabled() {
        return this.stencilEnabled;
    }

    @Override
    public int getWidth() {
        return this.f_83915_;
    }

    @Override
    public int getHeight() {
        return this.f_83916_;
    }

    @Override
    public void destroy() {
        this.m_83930_();
    }

    @Override
    public void clearFrameBuffer() {
        this.m_83954_(Minecraft.f_91002_);
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.m_83941_(width, height, Minecraft.f_91002_);
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.READ) {
            this.m_83956_();
        } else {
            this.m_83947_(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        if (bindPoint == FrameBufferBindPoint.READ) {
            this.m_83963_();
        } else if (bindPoint == FrameBufferBindPoint.WRITE) {
            this.m_83970_();
        } else {
            this.m_83963_();
            this.m_83970_();
        }
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferAttachmentType.COLOR -> {
                if (attachmentType.getIndex() == 0) {
                    yield this.f_83923_;
                }
                yield this.colorAttachment1;
            }
            case FrameBufferAttachmentType.ANY_DEPTH, FrameBufferAttachmentType.DEPTH -> this.f_83924_;
            case FrameBufferAttachmentType.DEPTH_STENCIL -> this.stencilEnabled ? this.f_83924_ : -1;
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return FrameBufferTextureAdapter.of(this, attachmentType);
    }

    @Override
    public int getFrameBufferId() {
        return this.f_83920_;
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return this.stencilEnabled ? TextureFormat.DEPTH24_STENCIL8 : TextureFormat.DEPTH24;
    }

    @Override
    public void m_83931_(float red, float green, float blue, float alpha) {
        super.m_83931_(red, green, blue, alpha);
    }

    @Override
    public RenderTarget asMcRenderTarget() {
        return this;
    }
}

