/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.api.event.AlgorithmDispatchEvent;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.Config;
import io.homo.superresolution.common.config.enums.CaptureMode;
import io.homo.superresolution.common.debug.PerformanceInfo;
import io.homo.superresolution.common.minecraft.CallType;
import io.homo.superresolution.common.minecraft.LegacyStorageFrameBuffer;
import io.homo.superresolution.common.minecraft.MinecraftRenderTargetType;
import io.homo.superresolution.common.minecraft.MinecraftRenderTargetWrapper;
import io.homo.superresolution.common.mixin.core.accessor.MinecraftAccessor;
import io.homo.superresolution.common.mixin.core.accessor.PostChainAccessor;
import io.homo.superresolution.common.platform.Platform;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.GlState;
import io.homo.superresolution.core.gl.GlStates;
import io.homo.superresolution.core.gl.texture.GlTexture2D;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.renderdoc.RenderDoc;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import org.lwjgl.opengl.GL11;

public class MinecraftRenderHandle {
    private static final Map<MinecraftRenderTargetType, IFrameBuffer> renderTargets = new HashMap<MinecraftRenderTargetType, IFrameBuffer>();
    private static final Map<IFrameBuffer, RenderTarget> renderTargetMap = new HashMap<IFrameBuffer, RenderTarget>();
    public static boolean isRenderingWorld = false;
    public static float frameTime;
    private static int frameCount;
    private static Minecraft minecraft;
    private static IFrameBuffer originRenderTarget;
    private static IFrameBuffer renderTarget;
    private static boolean needCapture;
    private static boolean needCaptureUpscale;

    public static void needCapture() {
        needCapture = true;
    }

    public static void needCaptureUpscale() {
        needCaptureUpscale = true;
    }

    public static int getFrameCount() {
        return frameCount;
    }

    public static IFrameBuffer getOriginRenderTarget() {
        return originRenderTarget;
    }

    public static IFrameBuffer getRenderTarget() {
        return renderTarget;
    }

    public static void init() {
        RenderSystem.assertOnRenderThread();
        minecraft = Minecraft.m_91087_();
        originRenderTarget = MinecraftRenderTargetWrapper.of(minecraft.m_91385_());
        renderTarget = new LegacyStorageFrameBuffer(true);
        renderTarget.m_83931_(1.0f, 1.0f, 1.0f, 1.0f);
        renderTarget.resizeFrameBuffer(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight());
    }

    public static void updateLevelEffect() {
    }

    public static void fixPostChain(PostChain postChain) {
        int renderWidth = MinecraftRenderHandle.getRenderWidth();
        int renderHeight = MinecraftRenderHandle.getRenderHeight();
        for (RenderTarget renderTarget : ((PostChainAccessor)postChain).getFullSizedTargets()) {
            if (renderTarget.f_83915_ == renderWidth && renderTarget.f_83916_ == renderHeight && ((PostChainAccessor)postChain).getScreenWidth() == renderWidth && ((PostChainAccessor)postChain).getScreenHeight() == renderHeight) continue;
            postChain.m_110025_(renderWidth, renderHeight);
            break;
        }
    }

    public static void updateRenderTarget() {
        renderTargets.clear();
        for (MinecraftRenderTargetType minecraftRenderTargetType : MinecraftRenderTargetType.values()) {
            IFrameBuffer renderTarget = minecraftRenderTargetType.get(Minecraft.m_91087_().f_91060_);
            if (renderTarget == null) continue;
            renderTargets.put(minecraftRenderTargetType, renderTarget);
        }
    }

    public static IFrameBuffer getRenderTarget(MinecraftRenderTargetType type) {
        return renderTargets.get((Object)type);
    }

    public static void onInitEntityEffectBegin() {
    }

    public static void onInitEntityEffectEnd() {
    }

    public static void resize() {
        int screenWidth = MinecraftRenderHandle.getScreenWidth();
        int screenHeight = MinecraftRenderHandle.getScreenHeight();
        int renderWidth = MinecraftRenderHandle.getRenderWidth();
        int renderHeight = MinecraftRenderHandle.getRenderHeight();
        MinecraftRenderHandle.callOnRenderTargets(renderTarget -> MinecraftRenderHandle.resizeRenderTarget(renderTarget, renderWidth, renderHeight), false);
    }

    private static void resizeRenderTarget(IFrameBuffer renderTarget, int width, int height) {
        renderTarget.resizeFrameBuffer(width, height);
    }

    private static boolean checkRenderWorldCallPos(CallType type) {
        return switch (Config.getCaptureMode()) {
            default -> throw new IncompatibleClassChangeError();
            case CaptureMode.A, CaptureMode.C -> {
                if (type == CallType.GAME_RENDERER) {
                    yield true;
                }
                yield false;
            }
            case CaptureMode.B -> type == CallType.LEVEL_RENDERER;
        };
    }

    private static boolean checkRenderHandCallPos() {
        boolean bl;
        block4: {
            switch (Config.getCaptureMode()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case A: 
                case B: {
                    break;
                }
                case C: {
                    if (Platform.currentPlatform.iris().isShaderPackInUse()) break;
                    bl = true;
                    break block4;
                }
            }
            bl = false;
        }
        return bl;
    }

    public static void onRenderWorldBegin(CallType type) {
        if (!MinecraftRenderHandle.checkRenderWorldCallPos(type)) {
            return;
        }
        isRenderingWorld = true;
        if (SuperResolution.cachedWidth != MinecraftRenderHandle.getScreenWidth() || SuperResolution.cachedHeight != MinecraftRenderHandle.getScreenHeight()) {
            SuperResolution.getInstance().resize(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight());
        }
        PerformanceInfo.begin("world");
        MinecraftRenderHandle.updateLevelEffect();
        MinecraftRenderHandle.updateRenderTarget();
        MinecraftRenderHandle.updateRenderTargetSize();
        MinecraftRenderHandle.setClientRenderTarget(MinecraftRenderHandle.getRenderTarget().asMcRenderTarget());
        MinecraftRenderHandle.getRenderTarget().bind(FrameBufferBindPoint.WRITE);
        SuperResolution.getCurrentAlgorithm().setInputFrameBuffer(MinecraftRenderHandle.getRenderTarget());
        if (needCapture && RenderDoc.renderdoc != null) {
            RenderDoc.renderdoc.StartFrameCapture.call(null, null);
        }
    }

    public static void onRenderWorldEnd(CallType type) {
        if (!MinecraftRenderHandle.checkRenderWorldCallPos(type)) {
            return;
        }
        isRenderingWorld = false;
        ++frameCount;
        MinecraftRenderHandle.setClientRenderTarget(MinecraftRenderHandle.getOriginRenderTarget().asMcRenderTarget());
        MinecraftRenderHandle.getOriginRenderTarget().bind(FrameBufferBindPoint.WRITE);
        try (GlState ignored = new GlState();){
            PerformanceInfo.begin("upscale");
            if (needCaptureUpscale && RenderDoc.renderdoc != null) {
                RenderDoc.renderdoc.StartFrameCapture.call(null, null);
            }
            AlgorithmManager.update();
            try (GlState ignored_ = new GlState();){
                DispatchResource dispatchResource = AlgorithmManager.getDispatchResource();
                if (SuperResolution.currentAlgorithm != null) {
                    AlgorithmDispatchEvent.EVENT.invoker().onAlgorithmRegister(SuperResolution.currentAlgorithm, dispatchResource);
                }
                SuperResolution.getCurrentAlgorithm().dispatch(dispatchResource);
            }
            IFrameBuffer outFbo = SuperResolution.getCurrentAlgorithm().getOutputFrameBuffer();
            Gl.DSA.blitFramebuffer(outFbo.getFrameBufferId(), MinecraftRenderHandle.getOriginRenderTarget().getFrameBufferId(), 0, 0, outFbo.getWidth(), outFbo.getHeight(), 0, 0, MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight(), 16384, 9728);
            if (needCaptureUpscale && RenderDoc.renderdoc != null) {
                needCaptureUpscale = false;
                RenderDoc.renderdoc.EndFrameCapture.call(null, null);
            }
            PerformanceInfo.end("upscale");
            if (Config.getCaptureMode() == CaptureMode.C && !Platform.currentPlatform.iris().isShaderPackInUse()) {
                MinecraftRenderHandle.blitHandRenderTarget();
            }
        }
        PerformanceInfo.end("world");
        frameTime = PerformanceInfo.getAsMillis("world");
        if (needCapture && RenderDoc.renderdoc != null) {
            needCapture = false;
            RenderDoc.renderdoc.EndFrameCapture.call(null, null);
        }
        MinecraftRenderHandle.getOriginRenderTarget().bind(FrameBufferBindPoint.WRITE);
    }

    public static void setClientRenderTarget(RenderTarget renderTarget) {
        if (renderTarget == null) {
            throw new RuntimeException();
        }
        ((MinecraftAccessor)Minecraft.m_91087_()).setRenderTarget(renderTarget);
    }

    public static float getCurrentScaleFactor() {
        return isRenderingWorld && MinecraftRenderHandle.minecraft.f_91073_ != null ? MinecraftRenderHandle.getScaleFactor() : 1.0f;
    }

    public static float getScaleFactor() {
        return Config.isEnableUpscale() ? Config.getRenderScaleFactor() : 1.0f;
    }

    public static int getRenderHeight() {
        return (int)Math.max((float)MinecraftRenderHandle.getScreenHeight() * MinecraftRenderHandle.getScaleFactor(), 1.0f);
    }

    public static int getRenderWidth() {
        return (int)Math.max((float)MinecraftRenderHandle.getScreenWidth() * MinecraftRenderHandle.getScaleFactor(), 1.0f);
    }

    public static int getScreenHeight() {
        return Math.max(SuperResolution.getMinecraftHeight(), 1);
    }

    public static int getScreenWidth() {
        return Math.max(SuperResolution.getMinecraftWidth(), 1);
    }

    public static void callOnRenderTargets(Consumer<IFrameBuffer> callback) {
        renderTargets.forEach((minecraftRenderTargetType, renderTarget) -> {
            if (renderTarget != null && minecraftRenderTargetType != MinecraftRenderTargetType.HAND) {
                callback.accept((IFrameBuffer)renderTarget);
            }
        });
    }

    public static void callOnRenderTargets(BiConsumer<IFrameBuffer, MinecraftRenderTargetType> callback) {
        renderTargets.forEach((minecraftRenderTargetType, renderTarget) -> {
            if (renderTarget != null) {
                callback.accept((IFrameBuffer)renderTarget, (MinecraftRenderTargetType)((Object)minecraftRenderTargetType));
            }
        });
    }

    public static void callOnRenderTarget(MinecraftRenderTargetType type, Consumer<IFrameBuffer> callback) {
        if (MinecraftRenderHandle.getRenderTarget(type) != null) {
            callback.accept(MinecraftRenderHandle.getRenderTarget(type));
        }
    }

    public static void callOnRenderTarget(Consumer<IFrameBuffer> callback) {
        if (MinecraftRenderHandle.getRenderTarget() != null) {
            callback.accept(MinecraftRenderHandle.getRenderTarget());
        }
    }

    public static void callOnRenderTargets(Consumer<IFrameBuffer> callback, boolean includeMainRenderTarget) {
        MinecraftRenderHandle.callOnRenderTargets(callback);
        if (includeMainRenderTarget) {
            callback.accept(MinecraftRenderHandle.getRenderTarget());
        }
    }

    public static void onBlitEntityEffect() {
        if (MinecraftRenderHandle.getRenderTarget(MinecraftRenderTargetType.ENTITY) == null) {
            return;
        }
        GlTexture2D.blitToScreen(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight(), MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight(), MinecraftRenderHandle.getRenderTarget(MinecraftRenderTargetType.ENTITY).getTextureId(FrameBufferAttachmentType.COLOR));
    }

    public static void updateRenderTargetSize() {
        int renderWidth = MinecraftRenderHandle.getRenderWidth();
        int renderHeight = MinecraftRenderHandle.getRenderHeight();
        int screenWidth = MinecraftRenderHandle.getScreenWidth();
        int screenHeight = MinecraftRenderHandle.getScreenHeight();
        MinecraftRenderHandle.callOnRenderTargets(renderTarget -> {
            if (renderTarget.getWidth() != renderWidth || renderTarget.getHeight() != renderHeight) {
                renderTarget.resizeFrameBuffer(renderWidth, renderHeight);
            }
        }, true);
        IFrameBuffer handRenderTarget = MinecraftRenderHandle.getRenderTarget(MinecraftRenderTargetType.HAND);
        if (handRenderTarget.getWidth() != screenWidth || handRenderTarget.getHeight() != screenHeight) {
            handRenderTarget.resizeFrameBuffer(screenWidth, screenHeight);
        }
    }

    public static void onRenderHandBegin() {
        if (!MinecraftRenderHandle.checkRenderHandCallPos()) {
            return;
        }
        GlStates.save("hand");
        MinecraftRenderHandle.setClientRenderTarget(MinecraftRenderHandle.getRenderTarget(MinecraftRenderTargetType.HAND).asMcRenderTarget());
        MinecraftRenderHandle.getRenderTarget(MinecraftRenderTargetType.HAND).clearFrameBuffer();
        MinecraftRenderHandle.getRenderTarget(MinecraftRenderTargetType.HAND).bind(FrameBufferBindPoint.ALL);
    }

    public static void blitHandRenderTarget() {
        GL11.glEnable((int)3042);
        MinecraftRenderHandle.callOnRenderTarget(MinecraftRenderTargetType.HAND, renderTarget -> GlTexture2D.blitToScreen(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight(), MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight(), renderTarget.getTextureId(FrameBufferAttachmentType.COLOR)));
        GL11.glDisable((int)3042);
    }

    public static void onRenderHandEnd() {
        if (!MinecraftRenderHandle.checkRenderHandCallPos()) {
            return;
        }
        MinecraftRenderHandle.setClientRenderTarget(MinecraftRenderHandle.getRenderTarget().asMcRenderTarget());
        GlStates.pop("hand").restore();
    }

    static {
        frameCount = 0;
        needCapture = false;
        needCaptureUpscale = false;
    }
}

