/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.pipeline;

import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineJob;
import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineJobDispatchResource;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceDescription;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceDescriptions;
import java.util.LinkedHashMap;
import java.util.Map;

public class GlPipeline {
    private final Map<String, GlPipelineJob> jobs = new LinkedHashMap<String, GlPipelineJob>();
    private final GlPipelineResourceDescriptions globalResources = new GlPipelineResourceDescriptions();

    public static GlPipeline create() {
        return new GlPipeline();
    }

    public GlPipelineResourceDescriptions getGlobalResources() {
        return this.globalResources;
    }

    public GlPipeline addJob(String jobName, GlPipelineJob job) {
        this.jobs.put(jobName, job);
        job.bindPipeline(this);
        return this;
    }

    public GlPipelineJob getJob(String jobName) {
        return this.jobs.get(jobName);
    }

    public GlPipeline addResource(GlPipelineResourceDescriptions descriptions) {
        this.globalResources.resource.putAll(descriptions.resource);
        return this;
    }

    public GlPipeline addResource(GlPipelineResourceDescription description) {
        this.globalResources.resource.put(description.name(), description);
        return this;
    }

    public void scheduleJobs(GlPipelineJobDispatchResource dispatchResource) {
        this.jobs.values().forEach(job -> job.schedule(dispatchResource));
    }

    public void executeJobs(GlPipelineJobDispatchResource dispatchResource) {
        this.jobs.values().forEach(job -> job.execute(dispatchResource));
    }

    public void scheduleJobs() {
        this.jobs.values().forEach(job -> job.schedule(GlPipelineJobDispatchResource.nothing()));
    }

    public void executeJobs() {
        this.jobs.values().forEach(job -> job.execute(GlPipelineJobDispatchResource.nothing()));
    }

    public void scheduleJob(String name, GlPipelineJobDispatchResource dispatchResource) {
        this.jobs.get(name).schedule(dispatchResource);
    }

    public void executeJob(String name, GlPipelineJobDispatchResource dispatchResource) {
        this.jobs.get(name).execute(dispatchResource);
    }

    public void scheduleJob(String name) {
        this.jobs.get(name).schedule(GlPipelineJobDispatchResource.nothing());
    }

    public void executeJob(String name) {
        this.jobs.get(name).execute(GlPipelineJobDispatchResource.nothing());
    }

    public void executeAll(GlPipelineJobDispatchResource dispatchResource) {
        this.scheduleJobs(dispatchResource);
        this.executeJobs(dispatchResource);
    }

    public void execute(String name, GlPipelineJobDispatchResource dispatchResource) {
        this.scheduleJob(name, dispatchResource);
        this.executeJob(name, dispatchResource);
    }

    public void execute(String name) {
        this.scheduleJob(name, GlPipelineJobDispatchResource.nothing());
        this.executeJob(name, GlPipelineJobDispatchResource.nothing());
    }

    public void executeAll() {
        this.scheduleJobs(GlPipelineJobDispatchResource.nothing());
        this.executeJobs(GlPipelineJobDispatchResource.nothing());
    }

    public GlPipelineResourceDescription findResource(String name, boolean searchJobs) {
        if (this.globalResources.resource.get(name) != null) {
            return this.globalResources.resource.get(name);
        }
        if (searchJobs) {
            for (GlPipelineJob job : this.jobs.values()) {
                if (job.resourcesMap.resource.get(name) == null) continue;
                return job.resourcesMap.resource.get(name);
            }
        }
        return null;
    }

    public GlPipelineResourceDescription findResource(String name) {
        return this.findResource(name, true);
    }
}

