/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.pipeline.jobs;

import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineJob;
import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineJobDispatchResource;
import io.homo.superresolution.core.gl.shader.AbstractGlShaderProgram;
import io.homo.superresolution.core.impl.Vec3;
import java.util.function.Supplier;
import org.lwjgl.opengl.GL42;

public class GlPipelineComputeJob
extends GlPipelineJob {
    private final AbstractGlShaderProgram program;
    private Supplier<Vec3> workGroupSizeSupplier;

    public GlPipelineComputeJob(AbstractGlShaderProgram program, Supplier<Vec3> workGroupSizeSupplier) {
        this.program = program;
        this.workGroupSizeSupplier = workGroupSizeSupplier;
    }

    public GlPipelineComputeJob(AbstractGlShaderProgram program, Vec3 workGroupSize) {
        this(program, () -> workGroupSize);
    }

    public void setWorkGroupSize(Vec3 workGroupSize) {
        this.workGroupSizeSupplier = () -> workGroupSize;
    }

    public void setWorkGroupSizeSupplier(Supplier<Vec3> workGroupSizeSupplier) {
        this.workGroupSizeSupplier = workGroupSizeSupplier;
    }

    @Override
    public void schedule(GlPipelineJobDispatchResource dispatchResource) {
        this.program.use();
        this.setupResource();
    }

    @Override
    public void execute(GlPipelineJobDispatchResource dispatchResource) {
        this.program.use();
        Vec3 workGroupSize = this.workGroupSizeSupplier.get();
        Gl.glDispatchCompute((int)workGroupSize.x, (int)workGroupSize.y, (int)workGroupSize.z);
        GL42.glMemoryBarrier((int)-1);
    }
}

