/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.impl.texture;

import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;

public class TextureFrameBufferAdapter
implements IFrameBuffer {
    private final ITexture texture;

    TextureFrameBufferAdapter(ITexture texture) {
        this.texture = texture;
    }

    public static TextureFrameBufferAdapter of(ITexture texture) {
        return new TextureFrameBufferAdapter(texture);
    }

    @Override
    public int getWidth() {
        return this.texture.getWidth();
    }

    @Override
    public int getHeight() {
        return this.texture.getHeight();
    }

    @Override
    public void clearFrameBuffer() {
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.texture.resize(width, height);
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return attachmentType == FrameBufferAttachmentType.COLOR ? this.texture.getTextureId() : -1;
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return this.texture;
    }

    @Override
    public int getFrameBufferId() {
        return -100;
    }

    @Override
    public void m_83931_(float red, float green, float blue, float alpha) {
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return this.texture.getTextureFormat();
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return this.texture.getTextureFormat();
    }

    @Override
    public void destroy() {
    }
}

