/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.utils.ColorUtil;
import net.minecraft.class_276;
import org.lwjgl.opengl.GL30;

public class MinecraftRenderTargetWrapper
implements IBindableFrameBuffer {
    public class_276 renderTarget;
    private int clearColor = ColorUtil.color(255, 0, 0, 0);

    public MinecraftRenderTargetWrapper(class_276 renderTarget) {
        this.renderTarget = renderTarget;
    }

    public static MinecraftRenderTargetWrapper of(class_276 renderTarget) {
        if (renderTarget == null) {
            return null;
        }
        MinecraftRenderTargetWrapper wrapper = new MinecraftRenderTargetWrapper(renderTarget);
        wrapper.clearColor = ColorUtil.color(255, 0, 0, 0);
        return wrapper;
    }

    @Override
    public void clearFrameBuffer() {
        this.renderTarget.method_1230();
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.renderTarget.method_1234(width, height);
    }

    @Override
    public int getWidth() {
        return this.renderTarget.field_1482;
    }

    @Override
    public int getHeight() {
        return this.renderTarget.field_1481;
    }

    @Override
    public void destroy() {
        this.renderTarget.method_1238();
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.Read) {
            this.renderTarget.method_35610();
        } else {
            this.renderTarget.method_1235(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        GL30.glBindFramebuffer((int)GlFrameBuffer.resolveBindTarget(bindPoint), (int)0);
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.Color -> this.renderTarget.method_30277();
            case FrameBufferAttachmentType.AnyDepth, FrameBufferAttachmentType.Depth, FrameBufferAttachmentType.DepthStencil -> this.renderTarget.method_30278();
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.Color -> FrameBufferTextureAdapter.ofColor(this);
            case FrameBufferAttachmentType.AnyDepth, FrameBufferAttachmentType.Depth, FrameBufferAttachmentType.DepthStencil -> FrameBufferTextureAdapter.ofDepth(this);
        };
    }

    @Override
    public long handle() {
        return this.renderTarget.field_1476;
    }

    @Override
    public void setClearColorRGBA(float red, float green, float blue, float alpha) {
        this.renderTarget.method_1236(red, green, blue, alpha);
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return TextureFormat.DEPTH32F;
    }

    @Override
    public class_276 asMcRenderTarget() {
        return this.renderTarget;
    }
}

