/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl;

import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CopyOperation {
    private ITexture srcTexture;
    private ITexture dstTexture;
    private final List<ChannelMapping> mappings = new ArrayList<ChannelMapping>();

    private CopyOperation() {
    }

    public static CopyOperation create() {
        return new CopyOperation();
    }

    public CopyOperation src(ITexture texture) {
        this.srcTexture = Objects.requireNonNull(texture);
        return this;
    }

    public CopyOperation dst(ITexture texture) {
        this.dstTexture = Objects.requireNonNull(texture);
        return this;
    }

    public CopyOperation fromTo(TextureChancel src, TextureChancel dst) {
        this.mappings.add(new ChannelMapping(src, dst));
        return this;
    }

    public ITexture getSrcTexture() {
        return this.srcTexture;
    }

    public ITexture getDstTexture() {
        return this.dstTexture;
    }

    public List<ChannelMapping> getMappings() {
        return List.copyOf(this.mappings);
    }

    public static class ChannelMapping {
        public final TextureChancel src;
        public final TextureChancel dst;

        public ChannelMapping(TextureChancel src, TextureChancel dst) {
            this.src = Objects.requireNonNull(src);
            this.dst = Objects.requireNonNull(dst);
        }
    }

    public static enum TextureChancel {
        R,
        G,
        B,
        A;

    }
}

