/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.buffer;

import io.homo.superresolution.core.graphics.impl.buffer.IBufferData;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.lwjgl.system.MemoryUtil;

public class DynamicBufferData
implements IBufferData {
    private final Buffer buffer;
    private final long size;
    private final boolean owned;
    private boolean dirty = false;

    private DynamicBufferData(Buffer buffer, long size, boolean owned) {
        this.buffer = buffer;
        this.size = size;
        this.owned = owned;
    }

    public static DynamicBufferData create(long size) {
        if (size <= 0L) {
            throw new IllegalArgumentException("Size must be positive");
        }
        ByteBuffer buffer = MemoryUtil.memCalloc((int)1, (int)((int)size));
        return new DynamicBufferData(buffer, size, true);
    }

    public static DynamicBufferData copy(Buffer buffer) {
        Objects.requireNonNull(buffer, "Buffer cannot be null");
        if (buffer.limit() <= 0) {
            throw new IllegalArgumentException("Buffer must have positive size");
        }
        long size = buffer.limit();
        ByteBuffer internalBuffer = MemoryUtil.memCalloc((int)1, (int)((int)size));
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((Buffer)buffer), (long)MemoryUtil.memAddress((Buffer)internalBuffer), (long)size);
        return new DynamicBufferData(internalBuffer, size, true);
    }

    public static DynamicBufferData wrap(long address, long size) {
        if (address == 0L) {
            throw new IllegalArgumentException("Address cannot be zero");
        }
        if (size <= 0L) {
            throw new IllegalArgumentException("Size must be positive");
        }
        ByteBuffer buffer = MemoryUtil.memByteBuffer((long)address, (int)((int)size));
        return new DynamicBufferData(buffer, size, false);
    }

    public static DynamicBufferData wrap(Buffer buffer) {
        Objects.requireNonNull(buffer, "Buffer cannot be null");
        if (buffer.limit() <= 0) {
            throw new IllegalArgumentException("Buffer must have positive size");
        }
        return new DynamicBufferData(buffer, buffer.limit(), false);
    }

    @Override
    public void update(Buffer data) {
        Objects.requireNonNull(data, "Data buffer cannot be null");
        if ((long)data.limit() != this.size) {
            throw new IllegalArgumentException("Data size must match buffer size");
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((Buffer)data), (long)MemoryUtil.memAddress((Buffer)this.buffer), (long)this.size);
        this.markDirty();
    }

    @Override
    public void updatePartial(Buffer data, long offset, long length) {
        Objects.requireNonNull(data, "Data buffer cannot be null");
        if (offset < 0L || length < 0L || offset + length > this.size) {
            throw new IndexOutOfBoundsException("Invalid offset or length");
        }
        if ((long)data.remaining() < length) {
            throw new IllegalArgumentException("Not enough data in input buffer");
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((Buffer)data), (long)(MemoryUtil.memAddress((Buffer)this.buffer) + offset), (long)length);
        this.markDirty();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public Buffer container() {
        return this.buffer;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void free() {
        if (this.owned) {
            MemoryUtil.memFree((Buffer)this.buffer);
        }
    }

    @Override
    public void put(byte[] src, long offset) {
        Objects.requireNonNull(src, "Source array cannot be null");
        if (offset < 0L || offset + (long)src.length > this.size) {
            throw new IndexOutOfBoundsException("Invalid offset or data length");
        }
        ByteBuffer byteBuffer = this.asByteBuffer();
        int position = byteBuffer.position();
        byteBuffer.position((int)offset);
        byteBuffer.put(src);
        byteBuffer.position(position);
        this.markDirty();
    }

    @Override
    public ByteBuffer asByteBuffer() {
        if (this.buffer instanceof ByteBuffer) {
            return (ByteBuffer)this.buffer;
        }
        throw new UnsupportedOperationException("Buffer is not a ByteBuffer");
    }
}

