/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.vertex;

import io.homo.superresolution.core.graphics.impl.vertex.IVertexArray;
import io.homo.superresolution.core.graphics.impl.vertex.IVertexBuffer;
import io.homo.superresolution.core.graphics.impl.vertex.VertexAttribute;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.opengl.GlState;
import org.lwjgl.opengl.GL41;

public class GlVertexArray
implements IVertexArray {
    private final int id = Gl.DSA.createVertexArray();

    @Override
    public void destroy() {
        Gl.DSA.deleteVertexArray(this.id);
    }

    @Override
    public void setAttributes(VertexAttribute[] attributes, IVertexBuffer vertexBuffer) {
        if (!Gl.isSupportDSA()) {
            try (GlState ignored = new GlState(25165828L);){
                GL41.glBindVertexArray((int)this.id);
                GL41.glBindBuffer((int)34962, (int)((int)vertexBuffer.handle()));
                for (VertexAttribute attr : attributes) {
                    int loc = attr.getLocation();
                    int componentCount = attr.getComponentCount();
                    int stride = attr.getStride();
                    int offset = attr.getOffset();
                    switch (attr.getDataType()) {
                        case FLOAT: {
                            GL41.glVertexAttribPointer((int)loc, (int)componentCount, (int)5126, (boolean)false, (int)stride, (long)offset);
                            break;
                        }
                        case INTEGER: {
                            GL41.glVertexAttribIPointer((int)loc, (int)componentCount, (int)5124, (int)stride, (long)offset);
                        }
                    }
                    GL41.glEnableVertexAttribArray((int)loc);
                }
                GL41.glBindBuffer((int)34962, (int)0);
                GL41.glBindVertexArray((int)0);
            }
        } else {
            int bindingIndex = 0;
            Gl.DSA.vertexArrayVertexBuffer(this.id, bindingIndex, (int)vertexBuffer.handle(), 0L, attributes[0].getStride());
            for (VertexAttribute attr : attributes) {
                int loc = attr.getLocation();
                Gl.DSA.vertexArrayAttribBinding(this.id, loc, bindingIndex);
                switch (attr.getDataType()) {
                    case FLOAT: {
                        Gl.DSA.vertexArrayAttribFormat(this.id, loc, attr.getComponentCount(), 5126, false, attr.getOffset());
                        break;
                    }
                    case INTEGER: {
                        Gl.DSA.vertexArrayAttribFormat(this.id, loc, attr.getComponentCount(), 5124, false, attr.getOffset());
                    }
                }
                Gl.DSA.enableVertexArrayAttrib(this.id, loc);
            }
        }
    }

    @Override
    public long handle() {
        return this.id;
    }
}

