/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui;

import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.buffer.BufferDescription;
import io.homo.superresolution.core.graphics.impl.buffer.BufferUsage;
import io.homo.superresolution.core.graphics.impl.buffer.IBuffer;
import io.homo.superresolution.core.graphics.impl.buffer.StructuredUniformBuffer;
import io.homo.superresolution.core.graphics.impl.buffer.UniformStructBuilder;
import io.homo.superresolution.core.graphics.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.Pipeline;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobBuilders;
import io.homo.superresolution.core.graphics.impl.pipeline.PipelineJobResource;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import io.homo.superresolution.core.graphics.impl.shader.ShaderDescription;
import io.homo.superresolution.core.graphics.impl.shader.ShaderSource;
import io.homo.superresolution.core.graphics.impl.shader.ShaderType;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.framebuffer.GlFrameBuffer;
import java.util.Optional;
import org.lwjgl.opengl.GL41;

public class GUIAntiAliasingPostprocessing {
    private IShaderProgram<?> sgsrShader;
    private Pipeline pipeline;
    private ITexture output;
    private IFrameBuffer outputFbo;
    private StructuredUniformBuffer buffer;
    private IBuffer ubo;
    private ITexture input;

    public IFrameBuffer getOutputFramebuffer() {
        return this.outputFbo;
    }

    public void init() {
        this.buffer = UniformStructBuilder.start().vec4Entry("ViewportInfo").build();
        this.ubo = RenderSystems.current().device().createBuffer(BufferDescription.create().usage(BufferUsage.Ubo).size(this.buffer.size()).build());
        this.ubo.setBufferData(this.buffer);
        this.output = RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).width(RenderHandlerManager.getScreenWidth()).height(RenderHandlerManager.getScreenHeight()).format(SuperResolutionConfig.getInternalTextureFormat()).usages(TextureUsages.create().sampler().storage().attachmentColor()).label("Sgsr1Output").build());
        this.outputFbo = GlFrameBuffer.create(this.output, null, RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
        this.outputFbo.label("Sgsr1OutputFbo");
        this.sgsrShader = RenderSystems.current().device().createShaderProgram(ShaderDescription.create().vertex(ShaderSource.file(ShaderType.Vertex, "/shader/sgsr/v1/sgsr1_shader.vert.glsl")).fragment(ShaderSource.file(ShaderType.Fragment, "/shader/sgsr/v1/sgsr1_shader.frag.glsl")).name("SGSRV1").addDefine("UseEdgeDirection", "").addDefine("SR_INTERNAL_TEXTURE_FORMAT", SuperResolutionConfig.getInternalTextureFormatGlslFormatQualifier()).uniformBuffer("sgsr1_data", 0, (int)this.buffer.size()).uniformSamplerTexture("ps0", 1).build());
        this.sgsrShader.compile();
        this.pipeline = new Pipeline();
        this.pipeline.job("sgsr1_main", ((PipelineJobBuilders.GraphicsJobBuilder)((PipelineJobBuilders.GraphicsJobBuilder)PipelineJobBuilders.graphics(this.sgsrShader).resource("ps0", PipelineJobResource.SamplerTexture.create(() -> Optional.ofNullable(this.input)))).resource("sgsr1_data", PipelineJobResource.UniformBuffer.create(this.ubo))).targetFramebuffer(this.outputFbo).build());
        this.resize(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight());
    }

    public void resize(int width, int height) {
        this.output.resize(width, height);
        this.outputFbo.resizeFrameBuffer(width, height);
    }

    public void dispatch(ITexture inputTexture) {
        this.buffer.setVec4("ViewportInfo", 1.0f / (float)inputTexture.getWidth(), 1.0f / (float)inputTexture.getHeight(), inputTexture.getWidth(), inputTexture.getHeight());
        this.buffer.fillBuffer();
        this.ubo.upload();
        this.outputFbo.clearFrameBuffer();
        GL41.glDisable((int)2929);
        GL41.glDisable((int)2884);
        RenderSystems.current().device().commandEncoder().begin();
        this.pipeline.execute(RenderSystems.current().device().commandEncoder().getCommandBuffer());
        RenderSystems.current().device().submitCommandBuffer(RenderSystems.current().device().commandEncoder().end());
        GL41.glEnable((int)2929);
        GL41.glEnable((int)2884);
    }
}

