/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.fsr2.common;

import io.homo.superresolution.core.graphics.impl.pipeline.Pipeline;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Context;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2DeviceCapabilities;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2Dimensions;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineDispatchResource;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineResources;
import java.util.HashMap;
import java.util.Map;

public abstract class Fsr2Pipeline {
    protected final Fsr2Context context;
    public Pipeline pipeline = new Pipeline();

    public Fsr2Pipeline(Fsr2Context context) {
        this.context = context;
    }

    public abstract void resize(Fsr2Dimensions var1);

    public abstract void destroy();

    public abstract void init();

    protected Fsr2PipelineResources.Fsr2ResourceEntry getResourcesDescription(String name) {
        if (!this.context.resources.shaderNameMap().containsKey(name)) {
            throw new RuntimeException(name);
        }
        return this.context.resources.resource(this.context.resources.shaderNameMap().get(name));
    }

    private String bool(boolean b) {
        return String.valueOf(b ? 1 : 0);
    }

    public Map<String, String> getShaderDefines(Map<String, String> override) {
        HashMap<String, String> defines = new HashMap<String, String>();
        defines.put("FFX_FSR2_OPTION_HDR_COLOR_INPUT", this.bool(this.context.config.flags.isEnableHighDynamicRange()));
        defines.put("FFX_FSR2_OPTION_LOW_RESOLUTION_MOTION_VECTORS", this.bool(!this.context.config.flags.isEnableDisplayResolutionMotionVectors()));
        defines.put("FFX_FSR2_OPTION_JITTERED_MOTION_VECTORS", this.bool(this.context.config.flags.isEnableMotionVectorsJitterCancellation()));
        defines.put("FFX_FSR2_OPTION_INVERTED_DEPTH", this.bool(this.context.config.flags.isEnableDepthInverted()));
        defines.put("FFX_FSR2_OPTION_APPLY_SHARPENING", this.bool(false));
        defines.put("FFX_FSR2_OPTION_REPROJECT_USE_LANCZOS_TYPE", this.bool(false));
        defines.put("FFX_FSR2_OPTION_UPSAMPLE_SAMPLERS_USE_DATA_HALF", "0");
        defines.put("FFX_FSR2_OPTION_ACCUMULATE_SAMPLERS_USE_DATA_HALF", "0");
        defines.put("FFX_FSR2_OPTION_REPROJECT_SAMPLERS_USE_DATA_HALF", "1");
        defines.put("FFX_FSR2_OPTION_POSTPROCESSLOCKSTATUS_SAMPLERS_USE_DATA_HALF", "0");
        defines.put("FFX_FSR2_OPTION_UPSAMPLE_USE_LANCZOS_TYPE", "2");
        defines.put("FFX_GLSL", this.bool(true));
        defines.put("FFX_GPU", this.bool(true));
        defines.put("FFX_HALF", this.bool(Fsr2DeviceCapabilities.isFp16Supported()));
        if (override != null) {
            defines.putAll(override);
        }
        return defines;
    }

    public abstract void execute(Fsr2PipelineDispatchResource var1);
}

