/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.fsr2.common;

import io.homo.superresolution.core.RenderSystems;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureMipmapSettings;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.opengl.buffer.GlBuffer;
import io.homo.superresolution.core.graphics.opengl.texture.GlTexture1D;
import io.homo.superresolution.core.graphics.opengl.texture.GlTexture2D;
import io.homo.superresolution.core.impl.Destroyable;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2MaximumBias;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2PipelineResourceType;
import io.homo.superresolution.thirdparty.fsr2.common.Fsr2ResourceCreateDescription;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.joml.Vector2f;

public class Fsr2PipelineResources {
    private final Map<Fsr2ResourceEntry, Fsr2PipelineResourceType> resourceEntriesMap = new HashMap<Fsr2ResourceEntry, Fsr2PipelineResourceType>();
    private final Map<Fsr2PipelineResourceType, Fsr2ResourceEntry> resources = new HashMap<Fsr2PipelineResourceType, Fsr2ResourceEntry>();
    private final Map<Fsr2PipelineResourceType, Fsr2ResourceCreateDescription> resourceCreateDescriptions = new HashMap<Fsr2PipelineResourceType, Fsr2ResourceCreateDescription>();
    private final Map<String, Fsr2PipelineResourceType> shaderNameMap = new HashMap<String, Fsr2PipelineResourceType>();

    public Map<Fsr2ResourceEntry, Fsr2PipelineResourceType> resourceEntriesMap() {
        return this.resourceEntriesMap;
    }

    public Map<Fsr2PipelineResourceType, Fsr2ResourceEntry> resources() {
        return this.resources;
    }

    public Map<Fsr2PipelineResourceType, Fsr2ResourceCreateDescription> resourceCreateDescriptions() {
        return this.resourceCreateDescriptions;
    }

    public Map<String, Fsr2PipelineResourceType> shaderNameMap() {
        return this.shaderNameMap;
    }

    private void addResourceDescription(Fsr2PipelineResourceType type, Fsr2ResourceCreateDescription description) {
        if (this.resourceCreateDescriptions.containsKey(type) || this.resources.containsKey(type)) {
            throw new RuntimeException(type.toString());
        }
        this.resourceCreateDescriptions.put(type, description);
        this.resources.put(type, new Fsr2ResourceEntry(description));
        this.resourceEntriesMap.put(this.resources.get(type), type);
        if (type.srvShaderName() != null) {
            this.shaderNameMap.put(type.srvShaderName(), type);
        }
        if (type.uavShaderName() != null) {
            this.shaderNameMap.put(type.uavShaderName(), type);
        }
    }

    public void init(int renderWidth, int renderHeight, int upscaledWidth, int upscaledHeight) {
        this.resourceCreateDescriptions.clear();
        this.resources.clear();
        this.addResourceDescription(Fsr2PipelineResourceType.INPUT_COLOR, new Fsr2ResourceCreateDescription(null, null, 2, "InputColor"));
        this.addResourceDescription(Fsr2PipelineResourceType.INPUT_OPAQUE_ONLY, new Fsr2ResourceCreateDescription(null, null, 2, "InputOpaqueOnly"));
        this.addResourceDescription(Fsr2PipelineResourceType.INPUT_MOTION_VECTORS, new Fsr2ResourceCreateDescription(null, null, 2, "InputMotionVectors"));
        this.addResourceDescription(Fsr2PipelineResourceType.INPUT_DEPTH, new Fsr2ResourceCreateDescription(null, null, 2, "InputDepth"));
        this.addResourceDescription(Fsr2PipelineResourceType.INPUT_EXPOSURE, new Fsr2ResourceCreateDescription(null, null, 2, "InputExposure"));
        this.addResourceDescription(Fsr2PipelineResourceType.INPUT_REACTIVE_MASK, new Fsr2ResourceCreateDescription(null, null, 2, "InputReactiveMask"));
        this.addResourceDescription(Fsr2PipelineResourceType.INPUT_TRANSPARENCY_AND_COMPOSITION_MASK, new Fsr2ResourceCreateDescription(null, null, 2, "InputTransparencyAndCompositionMask"));
        this.addResourceDescription(Fsr2PipelineResourceType.UPSCALED_OUTPUT, new Fsr2ResourceCreateDescription(null, null, 2, "upscaledOutput"));
        this.addResourceDescription(Fsr2PipelineResourceType.DILATED_MOTION_VECTORS, new Fsr2ResourceCreateDescription(null, null, 2, "DilatedMotionVectors"));
        this.addResourceDescription(Fsr2PipelineResourceType.PREVIOUS_DILATED_MOTION_VECTORS, new Fsr2ResourceCreateDescription(null, null, 2, "PreviousDilatedMotionVectors"));
        this.addResourceDescription(Fsr2PipelineResourceType.INTERNAL_UPSCALED_COLOR, new Fsr2ResourceCreateDescription(null, null, 2, "InternalUpscaledColor"));
        this.addResourceDescription(Fsr2PipelineResourceType.LOCK_STATUS, new Fsr2ResourceCreateDescription(null, null, 2, "LockStatus"));
        this.addResourceDescription(Fsr2PipelineResourceType.LUMA_HISTORY, new Fsr2ResourceCreateDescription(null, null, 2, "LumaHistory"));
        this.addResourceDescription(Fsr2PipelineResourceType.RCAS_INPUT, new Fsr2ResourceCreateDescription(null, null, 2, "RcasInput"));
        this.addResourceDescription(Fsr2PipelineResourceType.SCENE_LUMINANCE_MIPMAP_SHADING_CHANGE, new Fsr2ResourceCreateDescription(null, null, 2, "SceneLuminanceShadingChange"));
        this.addResourceDescription(Fsr2PipelineResourceType.SCENE_LUMINANCE_MIPMAP_5, new Fsr2ResourceCreateDescription(null, null, 2, "SceneLuminanceMip5"));
        this.addResourceDescription(Fsr2PipelineResourceType.PREV_PRE_ALPHA_COLOR, new Fsr2ResourceCreateDescription(null, null, 2, "PrevPreAlphaColor"));
        this.addResourceDescription(Fsr2PipelineResourceType.PREV_POST_ALPHA_COLOR, new Fsr2ResourceCreateDescription(null, null, 2, "PrevPostAlphaColor"));
        this.addResourceDescription(Fsr2PipelineResourceType.PREPARED_INPUT_COLOR, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.RGBA16F, 2, "FSR2_PreparedInputColor"));
        this.addResourceDescription(Fsr2PipelineResourceType.RECONSTRUCTED_PREVIOUS_NEAREST_DEPTH, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.R32UI, 2, "FSR2_ReconstructedPrevNearestDepth"));
        this.addResourceDescription(Fsr2PipelineResourceType.INTERNAL_DILATED_MOTION_VECTORS_1, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.RG16F, 2, "FSR2_InternalDilatedVelocity1"));
        this.addResourceDescription(Fsr2PipelineResourceType.INTERNAL_DILATED_MOTION_VECTORS_2, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.RG16F, 2, "FSR2_InternalDilatedVelocity2"));
        this.addResourceDescription(Fsr2PipelineResourceType.DILATED_DEPTH, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.R32F, 2, "FSR2_DilatedDepth"));
        this.addResourceDescription(Fsr2PipelineResourceType.LOCK_STATUS_1, new Fsr2ResourceCreateDescription(new Vector2f((float)upscaledWidth, (float)upscaledHeight), TextureFormat.RG16F, 2, "FSR2_LockStatus1"));
        this.addResourceDescription(Fsr2PipelineResourceType.LOCK_STATUS_2, new Fsr2ResourceCreateDescription(new Vector2f((float)upscaledWidth, (float)upscaledHeight), TextureFormat.RG16F, 2, "FSR2_LockStatus2"));
        this.addResourceDescription(Fsr2PipelineResourceType.LOCK_INPUT_LUMA, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.R16F, 2, "FSR2_LockInputLuma"));
        this.addResourceDescription(Fsr2PipelineResourceType.NEW_LOCKS, new Fsr2ResourceCreateDescription(new Vector2f((float)upscaledWidth, (float)upscaledHeight), TextureFormat.R8, 2, "FSR2_NewLocks"));
        this.addResourceDescription(Fsr2PipelineResourceType.INTERNAL_UPSCALED_COLOR_1, new Fsr2ResourceCreateDescription(new Vector2f((float)upscaledWidth, (float)upscaledHeight), TextureFormat.RGBA16F, 2, "FSR2_InternalUpscaled1"));
        this.addResourceDescription(Fsr2PipelineResourceType.INTERNAL_UPSCALED_COLOR_2, new Fsr2ResourceCreateDescription(new Vector2f((float)upscaledWidth, (float)upscaledHeight), TextureFormat.RGBA16F, 2, "FSR2_InternalUpscaled2"));
        this.addResourceDescription(Fsr2PipelineResourceType.SCENE_LUMINANCE, new Fsr2ResourceCreateDescription(new Vector2f(Math.max((float)Math.ceil((float)renderWidth / 2.0f), 1.0f), Math.max((float)Math.ceil((float)renderHeight / 2.0f), 1.0f)), TextureFormat.R16F, 2, "FSR2_ExposureMips", 0));
        this.addResourceDescription(Fsr2PipelineResourceType.LUMA_HISTORY_1, new Fsr2ResourceCreateDescription(new Vector2f((float)upscaledWidth, (float)upscaledHeight), TextureFormat.RGBA8, 2, "FSR2_LumaHistory1"));
        this.addResourceDescription(Fsr2PipelineResourceType.LUMA_HISTORY_2, new Fsr2ResourceCreateDescription(new Vector2f((float)upscaledWidth, (float)upscaledHeight), TextureFormat.RGBA8, 2, "FSR2_LumaHistory2"));
        this.addResourceDescription(Fsr2PipelineResourceType.SPD_ATOMIC_COUNT, new Fsr2ResourceCreateDescription(new Vector2f(1.0f), TextureFormat.R32UI, 2, "FSR2_SpdAtomicCounter"));
        this.addResourceDescription(Fsr2PipelineResourceType.DILATED_REACTIVE_MASKS, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.RG8, 2, "FSR2_DilatedReactiveMasks"));
        this.addResourceDescription(Fsr2PipelineResourceType.LANCZOS_LUT, new Fsr2ResourceCreateDescription(new Vector2f(128.0f, 1.0f), TextureFormat.R16_SNORM, 1, "FSR2_LanczosLutData"));
        this.addResourceDescription(Fsr2PipelineResourceType.INTERNAL_DEFAULT_REACTIVITY, new Fsr2ResourceCreateDescription(new Vector2f(1.0f), TextureFormat.R8, 1, "FSR2_DefaultReactiviyMask"));
        this.addResourceDescription(Fsr2PipelineResourceType.UPSAMPLE_MAXIMUM_BIAS_LUT, new Fsr2ResourceCreateDescription(new Vector2f((float)Fsr2MaximumBias.FFX_FSR2_MAXIMUM_BIAS_TEXTURE_WIDTH, (float)Fsr2MaximumBias.FFX_FSR2_MAXIMUM_BIAS_TEXTURE_HEIGHT), TextureFormat.R16_SNORM, 2, "FSR2_MaximumUpsampleBias"));
        this.addResourceDescription(Fsr2PipelineResourceType.INTERNAL_DEFAULT_EXPOSURE, new Fsr2ResourceCreateDescription(new Vector2f(1.0f), TextureFormat.RG32F, 1, "FSR2_DefaultExposure"));
        this.addResourceDescription(Fsr2PipelineResourceType.AUTO_EXPOSURE, new Fsr2ResourceCreateDescription(new Vector2f(1.0f), TextureFormat.RG32F, 1, "FSR2_AutoExposure"));
        this.addResourceDescription(Fsr2PipelineResourceType.AUTOREACTIVE, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.R8, 2, "FSR2_AutoReactive"));
        this.addResourceDescription(Fsr2PipelineResourceType.AUTOCOMPOSITION, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.R8, 2, "FSR2_AutoComposition"));
        this.addResourceDescription(Fsr2PipelineResourceType.PREV_PRE_ALPHA_COLOR_1, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.R11G11B10F, 2, "FSR2_PrevPreAlpha0"));
        this.addResourceDescription(Fsr2PipelineResourceType.PREV_POST_ALPHA_COLOR_1, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.R11G11B10F, 2, "FSR2_PrevPostAlpha0"));
        this.addResourceDescription(Fsr2PipelineResourceType.PREV_PRE_ALPHA_COLOR_2, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.R11G11B10F, 2, "FSR2_PrevPreAlpha1"));
        this.addResourceDescription(Fsr2PipelineResourceType.PREV_POST_ALPHA_COLOR_2, new Fsr2ResourceCreateDescription(new Vector2f((float)renderWidth, (float)renderHeight), TextureFormat.R11G11B10F, 2, "FSR2_PrevPostAlpha1"));
        HashSet<Map.Entry<Fsr2PipelineResourceType, Fsr2ResourceCreateDescription>> entries = new HashSet<Map.Entry<Fsr2PipelineResourceType, Fsr2ResourceCreateDescription>>(this.resourceCreateDescriptions.entrySet());
        for (Map.Entry entry : entries) {
            ITexture tex;
            Fsr2PipelineResourceType type = (Fsr2PipelineResourceType)entry.getKey();
            Fsr2ResourceCreateDescription desc = (Fsr2ResourceCreateDescription)entry.getValue();
            Fsr2ResourceEntry resourceEntry = this.resources.get(type);
            if (desc.size == null || desc.format == null) continue;
            this.resources.get(type).setNeedDestroy(true);
            if (desc.dim == 1) {
                if (desc.size.y != 1.0f) {
                    throw new RuntimeException(desc.label);
                }
                tex = (GlTexture1D)RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture1D).usages(TextureUsages.create().storage().sampler()).width((int)desc.size.x).mipmapSettings(desc.mipCount == 0 ? TextureMipmapSettings.auto() : (desc.mipCount == -1 ? TextureMipmapSettings.disabled() : TextureMipmapSettings.manual(desc.mipCount))).format(desc.format).filterMode(desc.mipCount == 0 ? TextureFilterMode.Linear : (desc.mipCount == -1 ? TextureFilterMode.Nearest : TextureFilterMode.Linear)).label(desc.label).build());
                resourceEntry.setResource(tex);
                continue;
            }
            if (desc.dim == 2) {
                tex = (GlTexture2D)RenderSystems.current().device().createTexture(TextureDescription.create().type(TextureType.Texture2D).usages(TextureUsages.create().storage().sampler()).width((int)desc.size.x).height((int)desc.size.y).mipmapSettings(desc.mipCount == 0 ? TextureMipmapSettings.auto() : (desc.mipCount == -1 ? TextureMipmapSettings.disabled() : TextureMipmapSettings.manual(desc.mipCount))).format(desc.format).filterMode(desc.mipCount == 0 ? TextureFilterMode.Linear : (desc.mipCount == -1 ? TextureFilterMode.Nearest : TextureFilterMode.Linear)).label(desc.label).build());
                resourceEntry.setResource(tex);
                continue;
            }
            throw new RuntimeException(desc.label);
        }
    }

    public void destroy() {
        for (Fsr2ResourceEntry entry : this.resources.values()) {
            if (entry.getResource() == null) continue;
            if (entry.getResource() instanceof Destroyable && entry.needDestroy()) {
                ((Destroyable)entry.getResource()).destroy();
            }
            entry.setResource(null);
        }
    }

    public Fsr2ResourceEntry resource(Fsr2PipelineResourceType type) {
        Fsr2ResourceEntry entry = this.resources.get(type);
        if (entry == null) {
            throw new RuntimeException("\u8d44\u6e90\u672a\u627e\u5230: " + String.valueOf(type));
        }
        return entry;
    }

    public static class Fsr2ResourceEntry {
        private final Fsr2ResourceCreateDescription description;
        private Object resource;
        private boolean needDestroy = false;

        public Fsr2ResourceEntry(Fsr2ResourceCreateDescription description) {
            this.description = description;
        }

        public boolean needDestroy() {
            return this.needDestroy;
        }

        public Fsr2ResourceEntry setNeedDestroy(boolean needDestroy) {
            this.needDestroy = needDestroy;
            return this;
        }

        public Fsr2ResourceType type() {
            return this.resource == null ? Fsr2ResourceType.NULL : (this.resource instanceof GlBuffer ? Fsr2ResourceType.UBO : Fsr2ResourceType.TEXTURE);
        }

        public Fsr2ResourceCreateDescription getDescription() {
            return this.description;
        }

        public Object getResource() {
            return this.resource;
        }

        public void setResource(Object resource) {
            this.resource = resource;
        }
    }

    public static enum Fsr2ResourceType {
        TEXTURE,
        UBO,
        NULL;

    }
}

