/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDimension;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaFlexDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPhysicalEdge;

public final class FlexDirectionUtil {
    private FlexDirectionUtil() {
    }

    public static boolean isRow(YogaFlexDirection flexDirection) {
        return flexDirection == YogaFlexDirection.ROW || flexDirection == YogaFlexDirection.ROW_REVERSE;
    }

    public static boolean isColumn(YogaFlexDirection flexDirection) {
        return flexDirection == YogaFlexDirection.COLUMN || flexDirection == YogaFlexDirection.COLUMN_REVERSE;
    }

    public static YogaFlexDirection resolveDirection(YogaFlexDirection flexDirection, YogaDirection direction) {
        if (direction == YogaDirection.RTL) {
            if (flexDirection == YogaFlexDirection.ROW) {
                return YogaFlexDirection.ROW_REVERSE;
            }
            if (flexDirection == YogaFlexDirection.ROW_REVERSE) {
                return YogaFlexDirection.ROW;
            }
        }
        return flexDirection;
    }

    public static YogaFlexDirection resolveCrossDirection(YogaFlexDirection flexDirection, YogaDirection direction) {
        return FlexDirectionUtil.isColumn(flexDirection) ? FlexDirectionUtil.resolveDirection(YogaFlexDirection.ROW, direction) : YogaFlexDirection.COLUMN;
    }

    public static YogaPhysicalEdge flexStartEdge(YogaFlexDirection flexDirection) {
        switch (flexDirection) {
            case COLUMN: {
                return YogaPhysicalEdge.TOP;
            }
            case COLUMN_REVERSE: {
                return YogaPhysicalEdge.BOTTOM;
            }
            case ROW: {
                return YogaPhysicalEdge.LEFT;
            }
            case ROW_REVERSE: {
                return YogaPhysicalEdge.RIGHT;
            }
        }
        throw new IllegalArgumentException("Invalid FlexDirection");
    }

    public static YogaPhysicalEdge flexEndEdge(YogaFlexDirection flexDirection) {
        switch (flexDirection) {
            case COLUMN: {
                return YogaPhysicalEdge.BOTTOM;
            }
            case COLUMN_REVERSE: {
                return YogaPhysicalEdge.TOP;
            }
            case ROW: {
                return YogaPhysicalEdge.RIGHT;
            }
            case ROW_REVERSE: {
                return YogaPhysicalEdge.LEFT;
            }
        }
        throw new IllegalArgumentException("Invalid FlexDirection");
    }

    public static YogaPhysicalEdge inlineStartEdge(YogaFlexDirection flexDirection, YogaDirection direction) {
        if (FlexDirectionUtil.isRow(flexDirection)) {
            return direction == YogaDirection.RTL ? YogaPhysicalEdge.RIGHT : YogaPhysicalEdge.LEFT;
        }
        return YogaPhysicalEdge.TOP;
    }

    public static YogaPhysicalEdge inlineEndEdge(YogaFlexDirection flexDirection, YogaDirection direction) {
        if (FlexDirectionUtil.isRow(flexDirection)) {
            return direction == YogaDirection.RTL ? YogaPhysicalEdge.LEFT : YogaPhysicalEdge.RIGHT;
        }
        return YogaPhysicalEdge.BOTTOM;
    }

    public static YogaDimension dimension(YogaFlexDirection flexDirection) {
        switch (flexDirection) {
            case COLUMN: 
            case COLUMN_REVERSE: {
                return YogaDimension.HEIGHT;
            }
            case ROW: 
            case ROW_REVERSE: {
                return YogaDimension.WIDTH;
            }
        }
        throw new IllegalArgumentException("Invalid FlexDirection");
    }
}

