/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.nis;

import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.common.config.Config;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.common.upscale.nis.NVIDIAImageScalingConfig;
import io.homo.superresolution.common.upscale.nis.NVIDIAImageScalingConst;
import io.homo.superresolution.common.upscale.nis.enums.NISHDRMode;
import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.GlState;
import io.homo.superresolution.core.gl.buffer.GlUniformBuffer;
import io.homo.superresolution.core.gl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.gl.pipeline.GlPipeline;
import io.homo.superresolution.core.gl.pipeline.GlPipelineJobBuilders;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceAccess;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceDescription;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceType;
import io.homo.superresolution.core.gl.shader.GlComputeShaderProgram;
import io.homo.superresolution.core.gl.texture.GlTexture2D;
import io.homo.superresolution.core.impl.Vec3;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.shader.ShaderSource;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL43;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;

public class NVIDIAImageScaling
extends AbstractAlgorithm {
    private NVIDIAImageScalingConfig config;
    private ITexture output;
    private GlPipeline pipeline;
    private GlComputeShaderProgram scaleShader;
    private GlComputeShaderProgram sharpenShader;
    private ITexture coefScaler;
    private ITexture coefUSM;
    private GlUniformBuffer<NVIDIAImageScalingConfig> uniformBuffer;
    private GlFrameBuffer outputFbo;

    @Override
    public void init() {
        this.config = new NVIDIAImageScalingConfig();
        this.uniformBuffer = new GlUniformBuffer<NVIDIAImageScalingConfig>(this.config);
        this.input = MinecraftRenderHandle.getRenderTarget();
        this.output = GlTexture2D.create(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight(), TextureFormat.RGBA8);
        this.outputFbo = GlFrameBuffer.create(this.output, null, MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight());
        STBImage.stbi_set_flip_vertically_on_load((boolean)true);
        try (GlState ignored = new GlState();){
            ByteBuffer buf;
            IntBuffer channels;
            IntBuffer h;
            IntBuffer w;
            try (MemoryStack stack = MemoryStack.stackPush();){
                w = stack.mallocInt(1);
                h = stack.mallocInt(1);
                channels = stack.mallocInt(1);
                buf = STBImage.stbi_load((CharSequence)"I:/super_resolution_moddev/superresolution/common/src/main/resources/assets/super_resolution/textures/coef_scaler.png", (IntBuffer)w, (IntBuffer)h, (IntBuffer)channels, (int)4);
                this.coefScaler = GlTexture2D.create(2, 64, TextureFormat.RGBA8);
                Gl.glBindTexture(3553, this.coefScaler.getTextureId());
                if (buf != null) {
                    GL43.glPixelStorei((int)3317, (int)1);
                    GL43.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)2, (int)64, (int)6408, (int)5121, (ByteBuffer)buf);
                    STBImage.stbi_image_free((ByteBuffer)buf);
                }
            }
            stack = MemoryStack.stackPush();
            try {
                w = stack.mallocInt(1);
                h = stack.mallocInt(1);
                channels = stack.mallocInt(1);
                buf = STBImage.stbi_load((CharSequence)"I:/super_resolution_moddev/superresolution/common/src/main/resources/assets/super_resolution/textures/coef_usm.png", (IntBuffer)w, (IntBuffer)h, (IntBuffer)channels, (int)4);
                this.coefUSM = GlTexture2D.create(2, 64, TextureFormat.RGBA8);
                Gl.glBindTexture(3553, this.coefUSM.getTextureId());
                if (buf != null) {
                    GL43.glPixelStorei((int)3317, (int)1);
                    GL43.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)2, (int)64, (int)6408, (int)5121, (ByteBuffer)buf);
                    STBImage.stbi_image_free((ByteBuffer)buf);
                }
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        STBImage.stbi_set_flip_vertically_on_load((boolean)false);
        this.scaleShader = ((GlComputeShaderProgram)GlComputeShaderProgram.create().addShaderSource(new ShaderSource(ShaderSource.Type.COMPUTE, "/shader/nis/nis_scaler.comp.glsl", true)).setShaderName("nis_scaler").build()).compileShader();
        this.sharpenShader = ((GlComputeShaderProgram)GlComputeShaderProgram.create().addShaderSource(new ShaderSource(ShaderSource.Type.COMPUTE, "/shader/nis/nis_sharpen.comp.glsl", true)).setShaderName("nis_sharpen").build()).compileShader();
        this.pipeline = new GlPipeline();
        this.pipeline.addJob("nis_scaler", GlPipelineJobBuilders.compute(this.scaleShader).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Sampler2D, "in_texture", FrameBufferTextureAdapter.ofColor(this.input), GlPipelineResourceAccess.READ, null, NVIDIAImageScalingConst.IN_TEX_BINDING)).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Image2D, "out_texture", this.output, GlPipelineResourceAccess.WRITE, null, NVIDIAImageScalingConst.OUT_TEX_BINDING)).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Sampler2D, "coef_scaler", this.coefScaler, GlPipelineResourceAccess.READ, null, NVIDIAImageScalingConst.COEF_SCALAR_BINDING)).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Sampler2D, "coef_usm", this.coefUSM, GlPipelineResourceAccess.READ, null, NVIDIAImageScalingConst.COEF_USM_BINDING)).resource(GlPipelineResourceDescription.createUBOResource("const_buffer", this.uniformBuffer, 0)).workGroupSupplier(this::getWorkGroupSize).build());
    }

    private Vec3 getWorkGroupSize() {
        return new Vec3((float)Math.ceil(MinecraftRenderHandle.getScreenWidth() / 32) + 1.0f, (float)Math.ceil(MinecraftRenderHandle.getScreenHeight() / 24) + 1.0f, 1.0f);
    }

    @Override
    public boolean dispatch(DispatchResource dispatchResource) {
        this.config.NVScalerUpdateConfig(Config.getSharpness(), 0, 0, dispatchResource.renderWidth(), dispatchResource.renderHeight(), dispatchResource.renderWidth(), dispatchResource.renderHeight(), 0, 0, dispatchResource.screenWidth(), dispatchResource.screenHeight(), dispatchResource.screenWidth(), dispatchResource.screenHeight(), NISHDRMode.None);
        this.uniformBuffer.struct().updateData(dispatchResource);
        this.uniformBuffer.update();
        this.pipeline.execute("nis_scaler");
        return true;
    }

    @Override
    public void destroy() {
        this.output.destroy();
        this.scaleShader.destroy();
        this.sharpenShader.destroy();
        this.coefUSM.destroy();
        this.coefScaler.destroy();
        this.uniformBuffer.delete();
        this.outputFbo.destroy();
    }

    @Override
    public void resize(int width, int height) {
        this.output.resize(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight());
        this.outputFbo.resizeFrameBuffer(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight());
    }

    @Override
    public int getOutputTextureId() {
        return this.output.getTextureId();
    }

    @Override
    public IFrameBuffer getOutputFrameBuffer() {
        return this.outputFbo;
    }
}

