/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.sgsr.v2.variants;

import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.common.upscale.sgsr.v2.AbstractSgsrVariant;
import io.homo.superresolution.common.upscale.sgsr.v2.Sgsr2;
import io.homo.superresolution.common.upscale.sgsr.v2.SgsrUtils;
import io.homo.superresolution.core.gl.pipeline.GlPipeline;
import io.homo.superresolution.core.gl.pipeline.GlPipelineJobBuilders;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceAccess;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceDescription;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceType;
import io.homo.superresolution.core.gl.shader.GlComputeShaderProgram;
import io.homo.superresolution.core.gl.texture.GlSampler;
import io.homo.superresolution.core.gl.texture.GlTexture2D;
import io.homo.superresolution.core.impl.Vec3;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.impl.shader.ShaderSource;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;
import io.homo.superresolution.core.impl.texture.TextureSupplier;

public class Sgsr2PassCompute
extends AbstractSgsrVariant {
    private GlComputeShaderProgram convertShader;
    private GlComputeShaderProgram upscaleShader;
    private GlPipeline sgsrPipeline;
    private ITexture PrevLumaHistory;
    private ITexture YCoCgColor;
    private ITexture MotionDepthClipAlphaBuffer;
    private ITexture PrevHistoryOutput;
    private ITexture HistoryOutput;

    private Vec3 getWorkGroupSize() {
        int dispatchX = SgsrUtils.divideRoundUp(MinecraftRenderHandle.getScreenWidth(), 8);
        int dispatchY = SgsrUtils.divideRoundUp(MinecraftRenderHandle.getScreenHeight(), 8);
        return new Vec3(dispatchX, dispatchY, 1.0f);
    }

    @Override
    public void dispatch(DispatchResource resource, Sgsr2 sgsr) {
        this.swapHistoryOutput();
        this.sgsrPipeline.execute("convert");
        this.sgsrPipeline.execute("upscale");
    }

    @Override
    public void init(Sgsr2 sgsr) {
        this.convertShader = ((GlComputeShaderProgram)GlComputeShaderProgram.create().addShaderSource(new ShaderSource(ShaderSource.Type.COMPUTE, "/shader/sgsr/2pass_cs/sgsr2_convert.comp.glsl", true)).setShaderName("SGSR_2PCS_A").build()).compileShader();
        this.upscaleShader = ((GlComputeShaderProgram)GlComputeShaderProgram.create().addShaderSource(new ShaderSource(ShaderSource.Type.COMPUTE, "/shader/sgsr/2pass_cs/sgsr2_upscale.comp.glsl", true)).setShaderName("SGSR_2PCS_B").build()).compileShader();
        this.sgsrPipeline = new GlPipeline();
        this.PrevLumaHistory = GlTexture2D.create(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight(), TextureFormat.R32UI);
        this.YCoCgColor = GlTexture2D.create(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight(), TextureFormat.R32UI);
        this.MotionDepthClipAlphaBuffer = GlTexture2D.create(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight(), TextureFormat.RGBA16F);
        this.PrevHistoryOutput = GlTexture2D.create(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight(), TextureFormat.RGBA16F);
        this.HistoryOutput = GlTexture2D.create(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight(), TextureFormat.RGBA16F);
        this.sgsrPipeline.addJob("convert", GlPipelineJobBuilders.compute(this.convertShader).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Sampler2D, "InputColor", FrameBufferTextureAdapter.ofColor(sgsr.getInputFrameBuffer()), GlPipelineResourceAccess.READ, null, 1)).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Sampler2D, "InputDepth", FrameBufferTextureAdapter.ofDepth(sgsr.getInputFrameBuffer()), GlPipelineResourceAccess.READ, GlSampler.create(GlSampler.SamplerType.NearestClamp), 2)).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Sampler2D, "InputVelocity", FrameBufferTextureAdapter.ofColor(AlgorithmManager.getDispatchResource().motionVectors()), GlPipelineResourceAccess.READ, null, 3)).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Image2D, "MotionDepthClipAlphaBuffer", this.MotionDepthClipAlphaBuffer, GlPipelineResourceAccess.WRITE, null, 0)).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Image2D, "YCoCgColor", this.YCoCgColor, GlPipelineResourceAccess.WRITE, null, 1)).resource(GlPipelineResourceDescription.createUBOResource("Params", sgsr.getParams(), 0)).workGroupSupplier(this::getWorkGroupSize).build());
        this.sgsrPipeline.addJob("upscale", GlPipelineJobBuilders.compute(this.upscaleShader).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Sampler2D, "PrevHistoryOutput", TextureSupplier.of(() -> this.PrevHistoryOutput), GlPipelineResourceAccess.READ, GlSampler.create(GlSampler.SamplerType.LinearClamp), 7)).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Sampler2D, "MotionDepthClipAlphaBuffer", this.MotionDepthClipAlphaBuffer, GlPipelineResourceAccess.READ, GlSampler.create(GlSampler.SamplerType.LinearClamp), 8)).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Sampler2D, "YCoCgColor", this.YCoCgColor, GlPipelineResourceAccess.READ, GlSampler.create(GlSampler.SamplerType.NearestClamp), 9)).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Image2D, "SceneColorOutput", FrameBufferTextureAdapter.ofColor(sgsr.getOutputFrameBuffer()), GlPipelineResourceAccess.WRITE, null, 0)).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Image2D, "HistoryOutput", TextureSupplier.of(() -> this.HistoryOutput), GlPipelineResourceAccess.WRITE, null, 1)).resource(GlPipelineResourceDescription.createUBOResource("Params", sgsr.getParams(), 0)).workGroupSupplier(this::getWorkGroupSize).build());
    }

    private void swapHistoryOutput() {
        ITexture tempA = this.PrevHistoryOutput;
        this.PrevHistoryOutput = this.HistoryOutput;
        this.HistoryOutput = tempA;
    }

    @Override
    public void destroy() {
        this.HistoryOutput.destroy();
        this.PrevHistoryOutput.destroy();
        this.convertShader.destroy();
        this.upscaleShader.destroy();
        this.MotionDepthClipAlphaBuffer.destroy();
        this.YCoCgColor.destroy();
    }

    @Override
    public void resize(int width, int height) {
        this.HistoryOutput.resize(width, height);
        this.PrevHistoryOutput.resize(width, height);
        this.MotionDepthClipAlphaBuffer.resize(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight());
        this.YCoCgColor.resize(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight());
    }
}

